/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss;

import iskallia.vault.VaultMod;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class MobSpawningUtils {
    public static final String TAG_BOSS_SUMMONED = "boss_summoned";

    @Nullable
    public static Entity spawnMob(ServerLevel serverLevel, double radius, EntityType<?> entityType, CompoundTag entityNbt, Vec3 spawnCenter) {
        return MobSpawningUtils.spawnMob(serverLevel, radius, 0, entityType, entityNbt, spawnCenter, false);
    }

    public static Entity spawnMob(ServerLevel serverLevel, double radius, int maxYOffset, EntityType<?> entityType, CompoundTag entityNbt, Vec3 spawnCenter, boolean checkCollision) {
        return MobSpawningUtils.spawnMob(serverLevel, 0.0, radius, maxYOffset, entityType, entityNbt, spawnCenter, checkCollision);
    }

    public static Entity spawnMob(ServerLevel serverLevel, double minDistanceFromCenter, double radius, int maxYOffset, EntityType<?> entityType, CompoundTag entityNbt, Vec3 spawnCenter, boolean checkCollision) {
        BlockPos spawnPos = MobSpawningUtils.getRandomSpawnPos(serverLevel, minDistanceFromCenter, radius, maxYOffset, entityType, spawnCenter, checkCollision);
        if (spawnPos == null) {
            return null;
        }
        Entity entity = entityType.m_20592_(serverLevel, null, null, spawnPos, MobSpawnType.SPAWNER, false, false);
        if (entity == null) {
            VaultMod.LOGGER.error("Unable to spawn entity type {} because its factory returned null", (Object)entityType.getRegistryName());
            return null;
        }
        if (entityNbt != null) {
            CompoundTag entityTag = entity.m_20240_(new CompoundTag());
            entityTag.m_128391_(entityNbt.m_6426_());
            entity.m_20258_(entityTag);
        }
        if (entity instanceof Mob) {
            ((Mob)entity).m_21373_();
        }
        entity.m_19880_().add(TAG_BOSS_SUMMONED);
        return entity;
    }

    private static BlockPos getRandomSpawnPos(ServerLevel serverLevel, double minDistanceFromCenter, double radius, int maxYOffset, EntityType<?> entityType, Vec3 spawnCenter, boolean checkCollision) {
        int remainingTries;
        double angle = Math.PI * 2 * serverLevel.f_46441_.nextDouble();
        double distance = minDistanceFromCenter + (radius - minDistanceFromCenter) * serverLevel.f_46441_.nextDouble();
        double x = spawnCenter.m_7096_() + Math.cos(angle) * distance + 0.5;
        double y = spawnCenter.m_7098_() + (double)(maxYOffset > 0 ? serverLevel.f_46441_.nextInt(2 * maxYOffset) - maxYOffset : 0);
        double z = spawnCenter.m_7094_() + Math.sin(angle) * distance + 0.5;
        for (remainingTries = 20; checkCollision && remainingTries > 0 && !serverLevel.m_45772_(entityType.m_20585_(x, y, z)); --remainingTries) {
            angle = Math.PI * 2 * serverLevel.f_46441_.nextDouble();
            distance = minDistanceFromCenter + (radius - minDistanceFromCenter) * serverLevel.f_46441_.nextDouble();
            x = spawnCenter.m_7096_() + Math.cos(angle) * distance + 0.5;
            y = spawnCenter.m_7098_() + (double)(maxYOffset > 0 ? serverLevel.f_46441_.nextInt(2 * maxYOffset) - maxYOffset : 0);
            z = spawnCenter.m_7094_() + Math.sin(angle) * distance + 0.5;
        }
        if (remainingTries == 0) {
            return null;
        }
        return new BlockPos(x, y, z);
    }

    public record EntitySpawnData(EntityType<?> entityType, @javax.annotation.Nullable CompoundTag entityNbt) {
        public static Optional<EntitySpawnData> from(CompoundTag tag) {
            EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(tag.m_128461_("EntityType")));
            CompoundTag entityNbt = tag.m_128441_("EntityNbt") ? tag.m_128469_("EntityNbt") : null;
            return entityType == null ? Optional.empty() : Optional.of(new EntitySpawnData(entityType, entityNbt));
        }

        public CompoundTag serializeTo(CompoundTag tag) {
            tag.m_128359_("EntityType", this.entityType.getRegistryName().toString());
            if (this.entityNbt != null) {
                tag.m_128365_("EntityNbt", (Tag)this.entityNbt);
            }
            return tag;
        }
    }
}

