/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss;

import iskallia.vault.entity.boss.VaultBossEntity;
import iskallia.vault.init.ModEntities;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class RuneBossShieldEntity
extends Entity {
    private static final EntityDataAccessor<Float> BASE_ANGLE = SynchedEntityData.m_135353_(RuneBossShieldEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ORBIT_RADIUS = SynchedEntityData.m_135353_(RuneBossShieldEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> HEIGHT_OFFSET = SynchedEntityData.m_135353_(RuneBossShieldEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ROLL = SynchedEntityData.m_135353_(RuneBossShieldEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final float DEFAULT_RADIUS = 3.0f;
    private static final float DEFAULT_HEIGHT_OFFSET = 1.5f;
    private static final float MIN_RADIUS = 0.75f;
    private static final float MAX_RADIUS = 12.0f;
    private static final float ORBIT_SPEED = 0.045f;
    private static final float DISTANCE_WOBBLE = 0.45f;
    private static final float HEIGHT_SWAY = 0.35f;
    @Nullable
    private UUID bossUuid;
    @Nullable
    private VaultBossEntity cachedBoss;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private float previousRoll;

    public RuneBossShieldEntity(EntityType<? extends RuneBossShieldEntity> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = true;
        this.m_20242_(true);
    }

    public RuneBossShieldEntity(Level level, VaultBossEntity boss, float baseAngle, float orbitRadius, float heightOffset) {
        this(ModEntities.RUNE_BOSS_SHIELD, level);
        this.setBoss(boss);
        this.setBaseAngle(baseAngle);
        this.setOrbitRadius(orbitRadius);
        this.setHeightOffset(heightOffset);
        this.snapToOrbit(boss);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BASE_ANGLE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ORBIT_RADIUS, (Object)Float.valueOf(3.0f));
        this.f_19804_.m_135372_(HEIGHT_OFFSET, (Object)Float.valueOf(1.5f));
        this.f_19804_.m_135372_(ROLL, (Object)Float.valueOf(0.0f));
    }

    public void m_8119_() {
        this.previousRoll = this.getRoll();
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            if (this.lerpSteps > 0) {
                double x = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
                double y = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
                double z = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
                --this.lerpSteps;
                this.m_6034_(x, y, z);
            }
            return;
        }
        VaultBossEntity boss = this.resolveBoss();
        if (boss == null || !boss.m_6084_() || !boss.isRuneShieldActive()) {
            this.m_146870_();
            return;
        }
        this.updatePosition(boss);
    }

    private void updatePosition(VaultBossEntity boss) {
        float radius = Mth.m_14036_((float)this.getOrbitRadius(), (float)0.75f, (float)12.0f);
        double orbitProgress = this.getBaseAngle() + (float)this.f_19853_.m_46467_() * 0.045f;
        double wobbleProgress = orbitProgress * 3.5;
        double horizontalRadius = (double)radius + Math.cos(wobbleProgress) * (double)0.45f;
        Vec3 center = boss.m_20182_().m_82520_(0.0, (double)this.getHeightOffset(), 0.0);
        double x = center.f_82479_ + horizontalRadius * Math.cos(orbitProgress);
        double z = center.f_82481_ + horizontalRadius * Math.sin(orbitProgress);
        double y = center.f_82480_ + (double)0.35f * Math.sin(wobbleProgress);
        this.m_6034_(x, y, z);
        Vec3 toCenter = center.m_82546_(this.m_20182_());
        double dx = toCenter.f_82479_;
        double dy = toCenter.f_82480_;
        double dz = toCenter.f_82481_;
        float previousYaw = this.m_146908_();
        float previousPitch = this.m_146909_();
        float yaw = (float)(Math.toDegrees(Math.atan2(dz, dx)) + 90.0);
        float pitch = (float)(-Math.toDegrees(Math.atan2(dy, Math.sqrt(dx * dx + dz * dz))));
        this.f_19859_ = previousYaw;
        this.f_19860_ = previousPitch;
        this.m_146922_(yaw);
        this.m_146926_(pitch);
        float roll = (float)(Math.sin(wobbleProgress) * 12.0);
        this.setRoll(roll);
        this.m_20256_(Vec3.f_82478_);
    }

    private void snapToOrbit(VaultBossEntity boss) {
        if (boss != null) {
            this.updatePosition(boss);
            this.previousRoll = this.getRoll();
        }
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int lerpSteps, boolean teleport) {
        super.m_6453_(x, y, z, yaw, pitch, lerpSteps, teleport);
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpSteps = lerpSteps;
    }

    @Nullable
    private VaultBossEntity resolveBoss() {
        ServerLevel serverLevel;
        Entity entity;
        if (this.cachedBoss != null && this.cachedBoss.m_6084_()) {
            return this.cachedBoss;
        }
        if (this.bossUuid == null) {
            return null;
        }
        Level level = this.f_19853_;
        if (level instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).m_8791_(this.bossUuid)) instanceof VaultBossEntity) {
            VaultBossEntity boss;
            this.cachedBoss = boss = (VaultBossEntity)entity;
            return boss;
        }
        return null;
    }

    public void setBoss(VaultBossEntity boss) {
        this.cachedBoss = boss;
        this.bossUuid = boss.m_142081_();
    }

    public void setBaseAngle(float angle) {
        this.f_19804_.m_135381_(BASE_ANGLE, (Object)Float.valueOf(angle));
    }

    public float getBaseAngle() {
        return ((Float)this.f_19804_.m_135370_(BASE_ANGLE)).floatValue();
    }

    public void setOrbitRadius(float radius) {
        this.f_19804_.m_135381_(ORBIT_RADIUS, (Object)Float.valueOf(radius <= 0.0f ? 3.0f : radius));
    }

    public float getOrbitRadius() {
        return ((Float)this.f_19804_.m_135370_(ORBIT_RADIUS)).floatValue();
    }

    public void setHeightOffset(float heightOffset) {
        this.f_19804_.m_135381_(HEIGHT_OFFSET, (Object)Float.valueOf(heightOffset <= 0.0f ? 1.5f : heightOffset));
    }

    public float getHeightOffset() {
        return ((Float)this.f_19804_.m_135370_(HEIGHT_OFFSET)).floatValue();
    }

    public void setRoll(float roll) {
        this.f_19804_.m_135381_(ROLL, (Object)Float.valueOf(roll));
    }

    public float getRoll() {
        return ((Float)this.f_19804_.m_135370_(ROLL)).floatValue();
    }

    public float getRoll(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.previousRoll, (float)this.getRoll());
    }

    protected void m_7380_(CompoundTag tag) {
        if (this.bossUuid != null) {
            tag.m_128362_("Boss", this.bossUuid);
        }
        tag.m_128350_("BaseAngle", this.getBaseAngle());
        tag.m_128350_("OrbitRadius", this.getOrbitRadius());
        tag.m_128350_("HeightOffset", this.getHeightOffset());
        tag.m_128350_("Roll", this.getRoll());
    }

    protected void m_7378_(CompoundTag tag) {
        this.bossUuid = tag.m_128403_("Boss") ? tag.m_128342_("Boss") : null;
        this.cachedBoss = null;
        this.setBaseAngle(tag.m_128441_("BaseAngle") ? tag.m_128457_("BaseAngle") : 0.0f);
        this.setOrbitRadius(tag.m_128441_("OrbitRadius") ? tag.m_128457_("OrbitRadius") : 3.0f);
        this.setHeightOffset(tag.m_128441_("HeightOffset") ? tag.m_128457_("HeightOffset") : 1.5f);
        this.setRoll(tag.m_128441_("Roll") ? tag.m_128457_("Roll") : 0.0f);
        this.previousRoll = this.getRoll();
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }
}

