/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss;

import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.entity.VaultBoss;
import iskallia.vault.entity.boss.attack.IMeleeAttack;
import iskallia.vault.world.data.ServerVaults;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public abstract class VaultBossBaseEntity
extends Monster
implements VaultBoss {
    protected static final EntityDataAccessor<String> ACTIVE_ATTACK_MOVE = SynchedEntityData.m_135353_(VaultBossBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected Vec3 spawnPosition;

    public abstract Map<String, BiFunction<VaultBossBaseEntity, Double, IMeleeAttack>> getMeleeAttackFactories();

    public VaultBossBaseEntity(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    public Vec3 getSpawnPosition() {
        return this.spawnPosition;
    }

    public int getPlayerCount() {
        if (this.f_19853_ instanceof ServerLevel) {
            return ServerVaults.get(this.f_19853_).map(vault -> vault.get(Vault.LISTENERS).getAll().size()).orElse(1);
        }
        return 1;
    }

    public int getPlayerAdjustedRandomCount(int minCount, int maxCount, float additionalPlayersRatio) {
        int playerCount = this.getPlayerCount();
        return this.m_183503_().m_5822_().nextInt((int)((float)minCount + (float)((playerCount - 1) * minCount) * additionalPlayersRatio), (int)((float)maxCount + (float)((playerCount - 1) * maxCount) * additionalPlayersRatio) + 1);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ACTIVE_ATTACK_MOVE, (Object)"");
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.spawnPosition = this.m_20182_();
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    public void setActiveAttackMove(String attackMove) {
        this.f_19804_.m_135381_(ACTIVE_ATTACK_MOVE, (Object)attackMove);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("SpawnPosition", (Tag)this.serializeSpawnPosition());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.spawnPosition = this.deserializeSpawnPosition(compound.m_128469_("SpawnPosition"));
    }

    private Vec3 deserializeSpawnPosition(CompoundTag spawnPosition) {
        return new Vec3(spawnPosition.m_128459_("X"), spawnPosition.m_128459_("Y"), spawnPosition.m_128459_("Z"));
    }

    private CompoundTag serializeSpawnPosition() {
        if (this.spawnPosition == null) {
            return new CompoundTag();
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("X", this.spawnPosition.f_82479_);
        tag.m_128347_("Y", this.spawnPosition.f_82480_);
        tag.m_128347_("Z", this.spawnPosition.f_82481_);
        return tag;
    }

    public Optional<String> getActiveAttackMove() {
        String attackMove = (String)this.f_19804_.m_135370_(ACTIVE_ATTACK_MOVE);
        return attackMove.isBlank() ? Optional.empty() : Optional.of(attackMove);
    }

    public boolean m_6779_(LivingEntity target) {
        return (target instanceof Player || target instanceof AbstractVillager) && super.m_6779_(target);
    }

    public abstract WeightedList<AttackData> getMeleeAttacks();

    public abstract WeightedList<AttackData> getRageAttacks();

    public final Vec3 calculateViewVector(float adjustedYaw) {
        return this.m_20171_(this.m_5686_(1.0f), adjustedYaw);
    }

    public void setSpawnPosition(Vec3 position) {
        this.spawnPosition = position;
    }

    public abstract double getAttackReach();

    public void playAttackSound() {
    }

    public record AttackData(String name, double multiplier) {
        public static AttackData from(CompoundTag tag) {
            return new AttackData(tag.m_128461_("Name"), tag.m_128459_("Multiplier"));
        }

        public void serializeTo(CompoundTag tag) {
            tag.m_128359_("Name", this.name);
            tag.m_128347_("Multiplier", this.multiplier);
        }
    }
}

