/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss;

import iskallia.vault.config.VaultBossConfig;
import iskallia.vault.core.data.compound.ItemStackList;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.spi.predicate.IModifierImmunity;
import iskallia.vault.core.vault.modifier.spi.predicate.ModifierPredicate;
import iskallia.vault.core.vault.objective.AwardCrateObjective;
import iskallia.vault.entity.VaultBoss;
import iskallia.vault.entity.boss.BossRuneModifiers;
import iskallia.vault.entity.boss.RuneBossShieldEntity;
import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.attack.IMeleeAttack;
import iskallia.vault.entity.boss.trait.IOnHitEffect;
import iskallia.vault.entity.boss.trait.ITrait;
import iskallia.vault.entity.boss.trait.ModifierType;
import iskallia.vault.entity.boss.trait.RuneReviveTrait;
import iskallia.vault.entity.boss.trait.RuneShieldTrait;
import iskallia.vault.entity.boss.trait.RuneWaveBlastTrait;
import iskallia.vault.entity.boss.trait.VaultBossTraitRegistry;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModParticles;
import iskallia.vault.network.message.ClientboundBossSyncTraitsMessage;
import iskallia.vault.network.message.NovaParticleMessage;
import iskallia.vault.world.data.ServerVaults;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

@Mod.EventBusSubscriber
public class VaultBossEntity
extends VaultBossBaseEntity
implements IAnimatable,
VaultBoss,
IModifierImmunity {
    private CompositeGoal compositeGoal = new CompositeGoal(this);
    private final AnimationFactory animationFactory = GeckoLibUtil.createFactory((IAnimatable)this);
    private boolean bossInitialized = false;
    private Set<IOnHitEffect> onHitEffects = new HashSet<IOnHitEffect>();
    private Map<String, ITrait> traits = new LinkedHashMap<String, ITrait>();
    private List<ItemStack> loot = new ArrayList<ItemStack>();
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
    private ShieldAbilityState runeShieldAbility;
    private WaveBlastAbilityState runeWaveBlastAbility;
    private ReviveAbilityState runeReviveAbility;

    @Override
    public Map<String, BiFunction<VaultBossBaseEntity, Double, IMeleeAttack>> getMeleeAttackFactories() {
        return Map.of();
    }

    public VaultBossEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.bossInfo.m_7003_(false);
        this.bossInfo.m_7006_(false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 18.0).m_22268_(Attributes.f_22276_, 32.0);
    }

    public boolean m_7301_(MobEffectInstance potionEffect) {
        if (potionEffect.m_19544_() == ModEffects.CHILLED || potionEffect.m_19544_() == ModEffects.GLACIAL_SHATTER || potionEffect.m_19544_() == ModEffects.NO_AI) {
            return false;
        }
        return super.m_7301_(potionEffect);
    }

    @Override
    public WeightedList<VaultBossBaseEntity.AttackData> getMeleeAttacks() {
        return (WeightedList)WeightedList.empty();
    }

    @Override
    public WeightedList<VaultBossBaseEntity.AttackData> getRageAttacks() {
        return (WeightedList)WeightedList.empty();
    }

    @Override
    public double getAttackReach() {
        return (double)this.m_20205_() * 2.0;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
    }

    @Override
    public ServerBossEvent getServerBossInfo() {
        this.bossInfo.m_6456_(this.m_5446_());
        return this.bossInfo;
    }

    public void registerControllers(AnimationData data) {
    }

    public AnimationFactory getFactory() {
        return this.animationFactory;
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public void m_8119_() {
        if (!this.bossInitialized) {
            if (!this.f_19853_.f_46443_) {
                this.f_21345_.m_25352_(3, (Goal)this.compositeGoal);
            }
            this.bossInitialized = true;
        }
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            this.tickShieldAbility();
            this.tickWaveBlastAbility();
            this.tickReviveAbility();
        }
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        ModNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ClientboundBossSyncTraitsMessage(this.m_142049_(), this.traits));
    }

    protected void m_6153_() {
        super.m_6153_();
        this.compositeGoal.m_8041_();
    }

    public void addOnHitEffect(IOnHitEffect effect) {
        this.onHitEffects.add(effect);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        ListTag traitsNbt = new ListTag();
        this.traits.forEach((id, trait) -> {
            CompoundTag traitNbt = trait.serializeNBT();
            traitNbt.m_128359_("Id", id);
            traitNbt.m_128359_("Type", trait.getType());
            traitsNbt.add((Object)traitNbt);
        });
        nbt.m_128365_("Traits", (Tag)traitsNbt);
        ListTag itemsNbt = new ListTag();
        this.loot.forEach(stack -> itemsNbt.add((Object)stack.m_41739_(new CompoundTag())));
        nbt.m_128365_("Loot", (Tag)itemsNbt);
        if (this.runeShieldAbility != null) {
            nbt.m_128365_("RuneShieldAbility", (Tag)this.runeShieldAbility.save());
        }
        if (this.runeWaveBlastAbility != null) {
            nbt.m_128365_("RuneWaveBlastAbility", (Tag)this.runeWaveBlastAbility.save());
        }
        if (this.runeReviveAbility != null) {
            nbt.m_128365_("RuneReviveAbility", (Tag)this.runeReviveAbility.save());
        }
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.compositeGoal.clear();
        ListTag traitsNbt = nbt.m_128437_("Traits", 10);
        this.traits.clear();
        traitsNbt.forEach(tag -> {
            CompoundTag traitNbt = (CompoundTag)tag;
            VaultBossTraitRegistry.createTrait(traitNbt.m_128461_("Type"), this, traitNbt).ifPresent(trait -> {
                String id = traitNbt.m_128461_("Id");
                this.traits.put(id, (ITrait)trait);
                if (this.f_19853_ != null && !this.f_19853_.f_46443_) {
                    trait.apply(this);
                }
            });
        });
        ListTag lootNbt = nbt.m_128437_("Loot", 10);
        this.loot.clear();
        lootNbt.forEach(tag -> this.loot.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)tag))));
        this.runeShieldAbility = nbt.m_128425_("RuneShieldAbility", 10) ? new ShieldAbilityState().load(nbt.m_128469_("RuneShieldAbility")) : null;
        this.runeWaveBlastAbility = nbt.m_128425_("RuneWaveBlastAbility", 10) ? new WaveBlastAbilityState().load(nbt.m_128469_("RuneWaveBlastAbility")) : null;
        this.runeReviveAbility = nbt.m_128425_("RuneReviveAbility", 10) ? new ReviveAbilityState().load(nbt.m_128469_("RuneReviveAbility")) : null;
    }

    private void runOnHitEffects(Player playerHit, float damage) {
        this.onHitEffects.forEach(effect -> effect.onHit(this, playerHit, damage));
    }

    @SubscribeEvent
    public static void onEntityAttack(LivingAttackEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof VaultBossEntity) {
            VaultBossEntity boss = (VaultBossEntity)entity;
            entity = event.getEntityLiving();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                boss.runOnHitEffects(player, event.getAmount());
            }
        }
    }

    public Collection<ITrait> getTraits() {
        return this.traits.values();
    }

    public void addTraitGoal(Goal goal) {
        this.compositeGoal.addGoal(goal);
    }

    public void setTraits(Map<String, ITrait> traits) {
        this.traits = traits;
        if (this.f_19853_ != null && this.f_19853_.f_46443_) {
            traits.values().forEach(trait -> trait.apply(this));
        }
    }

    protected void m_6668_(DamageSource pDamageSource) {
        super.m_6668_(pDamageSource);
        ServerVaults.get(this.f_19853_).ifPresent(vault -> vault.get(Vault.OBJECTIVES).getAll(AwardCrateObjective.class).forEach(crate -> {
            crate.setIfAbsent(AwardCrateObjective.ADDITIONAL_ITEMS, ItemStackList::create);
            crate.modify(AwardCrateObjective.ADDITIONAL_ITEMS, list -> {
                list.addAll(this.loot);
                return list;
            });
        }));
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    public void setLoot(List<ItemStack> loot) {
        this.loot = loot;
    }

    public void addTraits(BossRuneModifiers runeModifiers) {
        double damage;
        ModConfigs.VAULT_BOSS.getBossBaseTraits(this.m_6095_().getRegistryName()).forEach(this::addTrait);
        BossRuneModifiers modifiers = runeModifiers == null ? new BossRuneModifiers() : runeModifiers;
        double health = modifiers.getHealthPercent();
        if (health > 0.0) {
            this.traits.values().forEach(trait -> trait.addStack((ITrait)trait, ModifierType.HEALTH, this, health));
        }
        if ((damage = modifiers.getDamagePercent()) > 0.0) {
            this.traits.values().forEach(trait -> trait.addStack((ITrait)trait, ModifierType.DAMAGE, this, damage));
        }
        modifiers.getShieldAbility().ifPresent(settings -> {
            RuneShieldTrait trait = new RuneShieldTrait().setAttributes(settings.cooldownTicks(), settings.durationTicks(), settings.bossBarColor(), settings.particleRadius(), settings.cooldownReductionPerHaste());
            this.traits.put("rune_shield", trait);
            trait.apply(this);
        });
        modifiers.getWaveBlastAbility().ifPresent(settings -> {
            RuneWaveBlastTrait trait = new RuneWaveBlastTrait().setAttributes(settings.cooldownTicks(), settings.radius(), settings.damageMultiplier(), settings.cooldownReductionPerHaste(), settings.knockbackStrength());
            this.traits.put("rune_wave_blast", trait);
            trait.apply(this);
        });
        modifiers.getReviveAbility().ifPresent(settings -> {
            RuneReviveTrait trait = new RuneReviveTrait().setAttributes(settings.reviveCount(), settings.healthPercent(), settings.invulnerabilityTicks());
            this.traits.put("rune_revive", trait);
            trait.apply(this);
        });
        int abilityHaste = modifiers.getAbilityHaste();
        if (abilityHaste > 0) {
            this.traits.values().forEach(trait -> trait.addStack((ITrait)trait, ModifierType.ABILITY_HASTE, this, abilityHaste));
        }
        ModNetwork.CHANNEL.send(PacketDistributor.DIMENSION.with(() -> this.m_183503_().m_46472_()), (Object)new ClientboundBossSyncTraitsMessage(this.m_142049_(), this.traits));
    }

    private void addTrait(VaultBossConfig.TraitDefinition traitDefinition) {
        VaultBossTraitRegistry.createTrait(traitDefinition.type(), this, traitDefinition.attributesNbt()).ifPresent(trait -> {
            if (this.traits.containsKey(traitDefinition.id())) {
                this.traits.get(traitDefinition.id()).addStack((ITrait)trait, ModifierType.NONE, this);
            } else {
                this.traits.put(traitDefinition.id(), (ITrait)trait);
                trait.apply(this);
            }
        });
    }

    public void enableRuneShieldAbility(RuneShieldTrait trait) {
        if (trait == null) {
            return;
        }
        if (this.runeShieldAbility == null) {
            this.runeShieldAbility = new ShieldAbilityState();
        }
        this.runeShieldAbility.configure(trait.getCooldownTicks(), trait.getDurationTicks(), trait.getColor(), trait.getParticleRadius(), trait.getCooldownReductionPerHaste(), trait.getAbilityHasteStacks());
    }

    public void enableRuneWaveBlastAbility(RuneWaveBlastTrait trait) {
        if (trait == null) {
            return;
        }
        if (this.runeWaveBlastAbility == null) {
            this.runeWaveBlastAbility = new WaveBlastAbilityState();
        }
        this.runeWaveBlastAbility.configure(trait.getCooldownTicks(), trait.getRadius(), trait.getDamageMultiplier(), trait.getCooldownReductionPerHaste(), trait.getKnockbackStrength(), trait.getAbilityHasteStacks());
    }

    public void enableRuneReviveAbility(RuneReviveTrait trait) {
        if (trait == null) {
            return;
        }
        if (this.runeReviveAbility == null) {
            this.runeReviveAbility = new ReviveAbilityState();
        }
        this.runeReviveAbility.configure(trait.getReviveCount(), trait.getHealthPercent(), trait.getInvulnerabilityTicks());
    }

    public boolean isRuneShieldActive() {
        return this.runeShieldAbility != null && this.runeShieldAbility.isActive();
    }

    public int getRuneReviveCount() {
        return this.runeReviveAbility == null ? 0 : this.runeReviveAbility.getRemainingRevives();
    }

    private void tickShieldAbility() {
        if (this.runeShieldAbility != null) {
            this.runeShieldAbility.tick();
        }
    }

    private void tickWaveBlastAbility() {
        if (this.runeWaveBlastAbility != null) {
            this.runeWaveBlastAbility.tick();
        }
    }

    private void tickReviveAbility() {
        if (this.runeReviveAbility != null) {
            this.runeReviveAbility.tick();
        }
    }

    private void spawnShieldParticles(float radius) {
        Level level = this.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        double centerY = this.m_20186_() + (double)this.m_20206_() * 0.6;
        for (int i = 0; i < 12; ++i) {
            double angle = (float)(this.f_19797_ + i * 6) * 0.174533f;
            double x = this.m_20185_() + (double)radius * Math.cos(angle);
            double z = this.m_20189_() + (double)radius * Math.sin(angle);
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.BOSS_RUNE_CORE.get()), x, centerY, z, 1, 0.0, 0.02, 0.0, 0.0);
        }
    }

    private void performWaveBlast(float radius, float damageMultiplier, float knockbackStrength) {
        Level level = this.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 origin = this.m_20182_();
        AABB area = new AABB(origin.f_82479_ - (double)radius, origin.f_82480_ - (double)radius, origin.f_82481_ - (double)radius, origin.f_82479_ + (double)radius, origin.f_82480_ + (double)radius, origin.f_82481_ + (double)radius);
        AttributeInstance attackAttribute = this.m_21051_(Attributes.f_22281_);
        double attackDamage = attackAttribute == null ? 6.0 : attackAttribute.m_22135_();
        float baseDamage = (float)Math.max(1.0, attackDamage * (double)damageMultiplier);
        serverLevel.m_6443_(Player.class, area, player -> !player.m_5833_() && player.m_6084_()).forEach(player -> {
            Vec3 delta;
            if (player.m_6469_(DamageSource.m_19370_((LivingEntity)this), baseDamage) && (delta = player.m_20182_().m_82546_(origin)).m_82556_() > 0.0) {
                Vec3 knockback = delta.m_82541_().m_82490_((double)knockbackStrength);
                player.m_5997_(knockback.f_82479_, knockback.f_82480_ * 0.25, knockback.f_82481_);
                player.f_19864_ = true;
            }
        });
        this.f_19853_.m_6269_(null, (Entity)this, SoundEvents.f_11913_, SoundSource.HOSTILE, 0.7f, 1.0f);
        ModNetwork.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new NovaParticleMessage(origin, radius));
    }

    private void tickReviveParticles() {
        Level level = this.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.BOSS_RUNE_CORE.get()), this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * 0.5, this.m_20189_(), 6, 0.2, 0.2, 0.2, 0.01);
    }

    public Optional<WaveBlastWarning> getRuneWaveBlastWarning() {
        if (this.runeWaveBlastAbility == null) {
            return Optional.empty();
        }
        return this.runeWaveBlastAbility.getWarning();
    }

    public int getRuneWaveBlastWarningDuration() {
        if (this.runeWaveBlastAbility == null) {
            return 0;
        }
        return this.runeWaveBlastAbility.getWarningDuration();
    }

    public int getRuneWaveBlastCooldownDuration() {
        if (this.runeWaveBlastAbility == null) {
            return 0;
        }
        return this.runeWaveBlastAbility.getCurrentCooldownDuration();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.f_19853_ != null && !this.f_19853_.f_46443_ && this.runeReviveAbility != null && this.runeReviveAbility.handlePotentialRevive(this, source, amount)) {
            return false;
        }
        if (this.runeShieldAbility != null && this.runeShieldAbility.isActive() && (source == null || !source.m_19378_())) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6043_() {
        if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL) {
            this.m_146870_();
        } else {
            this.f_20891_ = 0;
        }
    }

    @Override
    public ModifierPredicate getImmunity() {
        return ModifierPredicate.TRUE;
    }

    @Override
    public void setImmunity(ModifierPredicate predicate) {
    }

    private static class CompositeGoal
    extends Goal {
        private final EnumSet<Goal.Flag> flags = EnumSet.noneOf(Goal.Flag.class);
        private final VaultBossEntity boss;
        private final Set<WrappedGoal> goals = new HashSet<WrappedGoal>();
        private int currentMaxPriority = 1;

        public CompositeGoal(VaultBossEntity boss) {
            this.boss = boss;
        }

        public void addGoal(Goal goal) {
            WrappedGoal wrappedGoal = new WrappedGoal(this.currentMaxPriority, goal);
            if (this.goals.contains(wrappedGoal)) {
                return;
            }
            ++this.currentMaxPriority;
            this.goals.add(wrappedGoal);
            this.flags.addAll(goal.m_7684_());
        }

        public boolean m_8036_() {
            for (Goal goal : this.goals) {
                if (!goal.m_8036_()) continue;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            for (Goal goal : this.goals) {
                if (!goal.m_8045_()) continue;
                return true;
            }
            return false;
        }

        public void m_8056_() {
            this.goals.forEach(goal -> {
                if (!goal.m_7620_() && goal.m_8036_()) {
                    goal.m_8056_();
                }
            });
        }

        public void m_8041_() {
            this.goals.forEach(goal -> {
                if (goal.m_7620_()) {
                    goal.m_8041_();
                }
            });
        }

        public void m_8037_() {
            this.goals.forEach(goal -> {
                if (!goal.m_7620_() && goal.m_8036_()) {
                    goal.m_8056_();
                }
                if (goal.m_7620_() && !goal.m_8045_()) {
                    goal.m_8041_();
                }
                if (goal.m_7620_()) {
                    goal.m_8037_();
                }
            });
        }

        public EnumSet<Goal.Flag> m_7684_() {
            return this.flags;
        }

        public boolean m_183429_() {
            for (Goal goal : this.goals) {
                if (!goal.m_183429_()) continue;
                return true;
            }
            return false;
        }

        public void clear() {
            this.goals.forEach(WrappedGoal::m_8041_);
            this.goals.clear();
        }
    }

    private class ShieldAbilityState {
        private BossEvent.BossBarColor defaultColor;
        private int baseCooldown;
        private int duration;
        private BossEvent.BossBarColor color = BossEvent.BossBarColor.WHITE;
        private float particleRadius;
        private double cooldownReductionPerHaste;
        private int abilityHasteStacks;
        private int cooldownTimer;
        private int activeTimer;
        private boolean active;
        private boolean colorApplied;
        private final List<UUID> shieldEntityIds = new ArrayList<UUID>(4);

        private ShieldAbilityState() {
            this.defaultColor = VaultBossEntity.this.bossInfo.m_18862_();
            this.baseCooldown = 200;
            this.duration = 100;
            this.particleRadius = 2.0f;
            this.cooldownReductionPerHaste = 0.0;
            this.abilityHasteStacks = 0;
            this.cooldownTimer = 200;
            this.activeTimer = 0;
            this.active = false;
            this.colorApplied = false;
        }

        private void configure(int baseCooldown, int duration, BossEvent.BossBarColor color, float particleRadius, double cooldownReduction, int abilityHasteStacks) {
            this.baseCooldown = Math.max(1, baseCooldown);
            this.duration = Math.max(1, duration);
            this.color = color;
            this.particleRadius = particleRadius;
            this.cooldownReductionPerHaste = Math.max(0.0, cooldownReduction);
            this.abilityHasteStacks = Math.max(0, abilityHasteStacks);
            if (!this.active) {
                this.defaultColor = VaultBossEntity.this.bossInfo.m_18862_();
            }
            this.cooldownTimer = Math.max(1, this.computeCooldown());
            if (this.active) {
                this.activeTimer = Math.min(this.activeTimer, this.duration);
            }
            this.updateShieldEntities();
        }

        private int computeCooldown() {
            return (int)Math.max(20.0, (double)this.baseCooldown - (double)this.abilityHasteStacks * this.cooldownReductionPerHaste);
        }

        private void tick() {
            if (this.active) {
                if (this.activeTimer > 0) {
                    --this.activeTimer;
                    this.updateShieldEntities();
                    if (this.activeTimer == 0) {
                        this.deactivate();
                    }
                }
                return;
            }
            if (this.cooldownTimer > 0) {
                --this.cooldownTimer;
            }
            if (this.cooldownTimer <= 0) {
                this.activate();
            }
        }

        private void activate() {
            this.active = true;
            this.activeTimer = this.duration;
            this.cooldownTimer = this.computeCooldown();
            this.applyColor();
            this.spawnShieldEntities();
            VaultBossEntity.this.f_19853_.m_6269_(null, (Entity)VaultBossEntity.this, SoundEvents.f_12346_, SoundSource.HOSTILE, 0.7f, 1.0f);
        }

        private void deactivate() {
            this.active = false;
            this.resetColor();
            this.removeShieldEntities();
        }

        private void applyColor() {
            if (!this.colorApplied) {
                VaultBossEntity.this.bossInfo.m_6451_(this.color);
                this.colorApplied = true;
            }
        }

        private void resetColor() {
            if (this.colorApplied) {
                VaultBossEntity.this.bossInfo.m_6451_(this.defaultColor);
                this.colorApplied = false;
            }
        }

        public boolean isActive() {
            return this.active;
        }

        public void onRevive() {
            this.active = false;
            this.activeTimer = 0;
            this.cooldownTimer = this.computeCooldown();
            this.resetColor();
            this.removeShieldEntities();
        }

        private void spawnShieldEntities() {
            Level level = VaultBossEntity.this.f_19853_;
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            this.removeShieldEntities();
            float radius = this.particleRadius <= 0.0f ? 2.0f : this.particleRadius;
            float heightOffset = VaultBossEntity.this.m_20206_() * 0.6f;
            for (int i = 0; i < 4; ++i) {
                float angle = (float)((double)i * 1.5707963267948966);
                RuneBossShieldEntity shieldEntity = new RuneBossShieldEntity((Level)serverLevel, VaultBossEntity.this, angle, radius, heightOffset);
                serverLevel.m_7967_((Entity)shieldEntity);
                this.shieldEntityIds.add(shieldEntity.m_142081_());
            }
        }

        private void removeShieldEntities() {
            Level level = VaultBossEntity.this.f_19853_;
            if (!(level instanceof ServerLevel)) {
                this.shieldEntityIds.clear();
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            Iterator<UUID> iterator = this.shieldEntityIds.iterator();
            while (iterator.hasNext()) {
                UUID uuid = iterator.next();
                Entity entity = serverLevel.m_8791_(uuid);
                if (entity instanceof RuneBossShieldEntity) {
                    RuneBossShieldEntity shieldEntity = (RuneBossShieldEntity)entity;
                    shieldEntity.m_146870_();
                }
                iterator.remove();
            }
        }

        private void updateShieldEntities() {
            Level level = VaultBossEntity.this.f_19853_;
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            float radius = this.particleRadius <= 0.0f ? 2.0f : this.particleRadius;
            float heightOffset = VaultBossEntity.this.m_20206_() * 0.6f;
            Iterator<UUID> iterator = this.shieldEntityIds.iterator();
            while (iterator.hasNext()) {
                UUID uuid = iterator.next();
                Entity entity = serverLevel.m_8791_(uuid);
                if (entity instanceof RuneBossShieldEntity) {
                    RuneBossShieldEntity shieldEntity = (RuneBossShieldEntity)entity;
                    shieldEntity.setBoss(VaultBossEntity.this);
                    shieldEntity.setOrbitRadius(radius);
                    shieldEntity.setHeightOffset(heightOffset);
                    continue;
                }
                iterator.remove();
            }
            if (this.active && this.shieldEntityIds.size() < 4) {
                this.spawnShieldEntities();
            }
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("BaseCooldown", this.baseCooldown);
            tag.m_128405_("Duration", this.duration);
            tag.m_128359_("Color", this.color.m_18886_());
            tag.m_128350_("Radius", this.particleRadius);
            tag.m_128347_("Reduction", this.cooldownReductionPerHaste);
            tag.m_128405_("HasteStacks", this.abilityHasteStacks);
            tag.m_128405_("CooldownTimer", this.cooldownTimer);
            tag.m_128405_("ActiveTimer", this.activeTimer);
            tag.m_128379_("Active", this.active);
            return tag;
        }

        public ShieldAbilityState load(CompoundTag tag) {
            this.baseCooldown = Math.max(1, tag.m_128451_("BaseCooldown"));
            this.duration = Math.max(1, tag.m_128451_("Duration"));
            this.color = this.parseColor(tag.m_128461_("Color"));
            this.particleRadius = tag.m_128441_("Radius") ? tag.m_128457_("Radius") : 2.0f;
            this.cooldownReductionPerHaste = tag.m_128441_("Reduction") ? tag.m_128459_("Reduction") : 0.0;
            this.abilityHasteStacks = tag.m_128441_("HasteStacks") ? Math.max(0, tag.m_128451_("HasteStacks")) : 0;
            this.cooldownTimer = Math.max(0, tag.m_128451_("CooldownTimer"));
            this.activeTimer = Math.max(0, tag.m_128451_("ActiveTimer"));
            this.active = tag.m_128471_("Active");
            this.defaultColor = VaultBossEntity.this.bossInfo.m_18862_();
            this.colorApplied = false;
            if (!this.active) {
                this.resetColor();
                this.removeShieldEntities();
            } else {
                this.applyColor();
                this.spawnShieldEntities();
            }
            return this;
        }

        private BossEvent.BossBarColor parseColor(String name) {
            try {
                return BossEvent.BossBarColor.valueOf((String)name.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                return BossEvent.BossBarColor.WHITE;
            }
        }
    }

    private class WaveBlastAbilityState {
        private int baseCooldown = 220;
        private float radius = 30.0f;
        private float damageMultiplier = 1.0f;
        private double cooldownReductionPerHaste = 0.0;
        private float knockbackStrength = 0.4f;
        private int abilityHasteStacks = 0;
        private int cooldownTimer = this.baseCooldown;
        private int currentCooldownDuration = this.baseCooldown;
        private int displayCooldownTimer = this.cooldownTimer;
        private static final int WARNING_WINDOW_TICKS = 60;

        private WaveBlastAbilityState() {
        }

        private void configure(int baseCooldown, float radius, float damageMultiplier, double cooldownReductionPerHaste, float knockbackStrength, int abilityHasteStacks) {
            this.baseCooldown = Math.max(1, baseCooldown);
            this.radius = Math.max(0.0f, radius);
            this.damageMultiplier = Math.max(0.0f, damageMultiplier);
            this.cooldownReductionPerHaste = Math.max(0.0, cooldownReductionPerHaste);
            this.knockbackStrength = Math.max(0.0f, knockbackStrength);
            this.abilityHasteStacks = Math.max(0, abilityHasteStacks);
            int cooldown = this.computeCooldown();
            if (this.cooldownTimer <= 0 || this.cooldownTimer > cooldown) {
                this.cooldownTimer = cooldown;
            }
            this.displayCooldownTimer = this.cooldownTimer;
        }

        private int computeCooldown() {
            int cooldown;
            this.currentCooldownDuration = cooldown = (int)Math.max(20.0, (double)this.baseCooldown - (double)this.abilityHasteStacks * this.cooldownReductionPerHaste);
            return cooldown;
        }

        private void tick() {
            if (this.cooldownTimer > 0) {
                --this.cooldownTimer;
            }
            this.displayCooldownTimer = Math.max(0, this.cooldownTimer);
            if (this.cooldownTimer <= 0) {
                VaultBossEntity.this.performWaveBlast(this.radius, this.damageMultiplier, this.knockbackStrength);
                this.displayCooldownTimer = this.cooldownTimer = this.computeCooldown();
            }
        }

        public void onRevive() {
            this.displayCooldownTimer = this.cooldownTimer = this.computeCooldown();
        }

        public Optional<WaveBlastWarning> getWarning() {
            if (this.displayCooldownTimer <= 60) {
                int window = Math.min(60, Math.max(1, this.currentCooldownDuration));
                int remaining = Math.max(0, Math.min(this.displayCooldownTimer, window));
                return Optional.of(new WaveBlastWarning(remaining, window));
            }
            return Optional.empty();
        }

        public int getWarningDuration() {
            return Math.min(60, Math.max(1, this.currentCooldownDuration));
        }

        public int getCurrentCooldownDuration() {
            return Math.max(1, this.currentCooldownDuration);
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("BaseCooldown", this.baseCooldown);
            tag.m_128350_("Radius", this.radius);
            tag.m_128350_("DamageMultiplier", this.damageMultiplier);
            tag.m_128347_("Reduction", this.cooldownReductionPerHaste);
            tag.m_128350_("Knockback", this.knockbackStrength);
            tag.m_128405_("HasteStacks", this.abilityHasteStacks);
            tag.m_128405_("CooldownTimer", this.cooldownTimer);
            return tag;
        }

        public WaveBlastAbilityState load(CompoundTag tag) {
            this.baseCooldown = Math.max(1, tag.m_128451_("BaseCooldown"));
            this.radius = tag.m_128441_("Radius") ? tag.m_128457_("Radius") : 30.0f;
            this.damageMultiplier = tag.m_128441_("DamageMultiplier") ? tag.m_128457_("DamageMultiplier") : 1.0f;
            this.cooldownReductionPerHaste = tag.m_128441_("Reduction") ? tag.m_128459_("Reduction") : 0.0;
            this.knockbackStrength = tag.m_128441_("Knockback") ? tag.m_128457_("Knockback") : 0.4f;
            this.abilityHasteStacks = tag.m_128441_("HasteStacks") ? Math.max(0, tag.m_128451_("HasteStacks")) : 0;
            this.cooldownTimer = Math.max(0, tag.m_128451_("CooldownTimer"));
            this.computeCooldown();
            if (this.cooldownTimer > this.currentCooldownDuration) {
                this.cooldownTimer = this.currentCooldownDuration;
            }
            this.displayCooldownTimer = Math.max(0, this.cooldownTimer);
            return this;
        }
    }

    private class ReviveAbilityState {
        private int remainingRevives = 0;
        private float healthPercent = 1.0f;
        private int invulnerabilityTicks = 40;
        private int invulnerabilityTimer = 0;

        private ReviveAbilityState() {
        }

        private void configure(int reviveCount, float healthPercent, int invulnerabilityTicks) {
            this.remainingRevives = Math.min(Math.max(0, reviveCount), 30);
            this.healthPercent = Math.max(0.0f, healthPercent);
            this.invulnerabilityTicks = Math.max(0, invulnerabilityTicks);
        }

        private void tick() {
            if (this.invulnerabilityTimer > 0) {
                --this.invulnerabilityTimer;
                VaultBossEntity.this.tickReviveParticles();
            }
        }

        private boolean handlePotentialRevive(VaultBossEntity boss, DamageSource source, float amount) {
            if (this.remainingRevives <= 0) {
                return false;
            }
            if (source != null && source.m_19378_()) {
                return false;
            }
            if (amount < boss.m_21223_()) {
                return false;
            }
            --this.remainingRevives;
            float restored = Math.max(1.0f, boss.m_21233_() * Math.max(0.05f, this.healthPercent));
            boss.m_21153_(restored);
            boss.m_20256_(Vec3.f_82478_);
            boss.f_19802_ = Math.max(this.invulnerabilityTicks, 20);
            boss.f_20916_ = 0;
            boss.f_20919_ = 0;
            this.invulnerabilityTimer = this.invulnerabilityTicks;
            Level level = boss.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.BOSS_RUNE_CORE.get()), boss.m_20185_(), boss.m_20186_() + (double)boss.m_20206_() * 0.5, boss.m_20189_(), 40, 0.35, 0.35, 0.35, 0.05);
            }
            boss.f_19853_.m_6269_(null, (Entity)boss, SoundEvents.f_12513_, SoundSource.HOSTILE, 1.0f, 1.0f);
            if (boss.runeShieldAbility != null) {
                boss.runeShieldAbility.onRevive();
            }
            if (boss.runeWaveBlastAbility != null) {
                boss.runeWaveBlastAbility.onRevive();
            }
            return true;
        }

        public int getRemainingRevives() {
            return this.remainingRevives;
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("Revives", this.remainingRevives);
            tag.m_128350_("Health", this.healthPercent);
            tag.m_128405_("Invulnerability", this.invulnerabilityTicks);
            tag.m_128405_("InvulnerabilityTimer", this.invulnerabilityTimer);
            return tag;
        }

        public ReviveAbilityState load(CompoundTag tag) {
            this.remainingRevives = Math.max(0, tag.m_128451_("Revives"));
            this.healthPercent = tag.m_128441_("Health") ? tag.m_128457_("Health") : 1.0f;
            this.invulnerabilityTicks = tag.m_128441_("Invulnerability") ? tag.m_128451_("Invulnerability") : 40;
            this.invulnerabilityTimer = Math.max(0, tag.m_128451_("InvulnerabilityTimer"));
            return this;
        }
    }

    public record WaveBlastWarning(int remainingTicks, int windowTicks) {
    }
}

