/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.attack;

import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.attack.IMeleeAttack;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;

public class AoeCloseAttack
implements IMeleeAttack {
    private static final TargetingConditions TARGETING_CONDITIONS = TargetingConditions.m_148352_().m_26883_(3.0);
    private static final TargetingConditions TARGETING_CONDITIONS_INSIDE = TargetingConditions.m_148352_().m_26883_(1.0);
    private static final TargetingConditions TARGETING_CONDITIONS_WIDER = TargetingConditions.m_148352_().m_26883_(7.0);
    private final VaultBossBaseEntity boss;
    private final double damageMultiplier;
    private long attackStartTime;
    private final Set<UUID> hitEntities = new HashSet<UUID>();

    public AoeCloseAttack(VaultBossBaseEntity boss, double damageMultiplier) {
        this.boss = boss;
        this.damageMultiplier = damageMultiplier;
    }

    @Override
    public boolean start(LivingEntity target, double distToTarget, double reach) {
        if (this.boss.m_183503_().m_45971_(LivingEntity.class, TARGETING_CONDITIONS, (LivingEntity)this.boss, this.boss.m_142469_().m_82400_(5.0)).isEmpty()) {
            return false;
        }
        this.attackStartTime = this.boss.m_183503_().m_46467_();
        return true;
    }

    @Override
    public void stop() {
        this.attackStartTime = 0L;
        this.hitEntities.clear();
    }

    @Override
    public void tick(double reach) {
        int startTick;
        long duration = this.boss.m_183503_().m_46467_() - this.attackStartTime;
        if (duration >= (long)(startTick = 20) && duration < (long)this.getDuration()) {
            List entities = this.boss.m_183503_().m_45971_(LivingEntity.class, TARGETING_CONDITIONS_WIDER, (LivingEntity)this.boss, this.boss.m_142469_().m_82400_(7.0));
            entities.forEach(entity -> {
                if (!this.hitEntities.contains(entity.m_142081_()) && (TARGETING_CONDITIONS_INSIDE.m_26885_((LivingEntity)this.boss, entity) || this.isWithinAttackableSlice(this.boss, (LivingEntity)entity, 0.6f, -0.1f + (float)(360L * (duration - (long)startTick)) / (float)(this.getDuration() - startTick)))) {
                    entity.f_19812_ = true;
                    this.knockbackTarget(this.boss, (LivingEntity)entity, 5.0, 0.1f);
                    entity.m_6469_(DamageSource.m_19370_((LivingEntity)this.boss), (float)(this.boss.m_21133_(Attributes.f_22281_) * this.damageMultiplier));
                    entity.f_19864_ = true;
                    this.hitEntities.add(entity.m_142081_());
                }
            });
        }
    }

    @Override
    public int getDuration() {
        return 30;
    }

    @Override
    public Optional<String> getAttackMove() {
        return Optional.of("aoeclose");
    }
}

