/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.attack;

import iskallia.vault.core.util.WeightedList;
import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.attack.IMeleeAttack;
import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;

public class BossMeleeAttackGoal
extends Goal {
    private final VaultBossBaseEntity boss;
    @Nullable
    private IMeleeAttack meleeAttack = null;
    @Nullable
    private IMeleeAttack rageAttack = null;
    private int remainingSwingDuration = 0;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private int ticksUntilNextRageAttack;
    private long lastCanUseCheck;
    private static final int COOLDOWN_BETWEEN_CAN_USE_CHECKS = 20;

    public BossMeleeAttackGoal(VaultBossBaseEntity boss) {
        this.boss = boss;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long i = this.boss.f_19853_.m_46467_();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        LivingEntity livingentity = this.boss.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        this.path = this.boss.m_21573_().m_6570_((Entity)livingentity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(livingentity) >= this.boss.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_8045_() {
        LivingEntity target = this.boss.m_5448_();
        if (target == null) {
            return false;
        }
        if (!target.m_6084_()) {
            return false;
        }
        if (!(target instanceof Player)) return true;
        Player player = (Player)target;
        if (target.m_5833_()) return false;
        if (player.m_7500_()) return false;
        return true;
    }

    public void m_8056_() {
        this.boss.m_21573_().m_26536_(this.path, 1.0);
        this.ticksUntilNextPathRecalculation = 0;
        this.boss.m_21561_(true);
        this.ticksUntilNextAttack = 0;
    }

    public void m_8041_() {
        LivingEntity livingentity = this.boss.m_5448_();
        if (!EntitySelector.f_20406_.test(livingentity)) {
            this.boss.m_6710_(null);
        }
        this.boss.m_21561_(false);
        this.boss.m_21573_().m_26573_();
        this.resetMeleeAttackValues();
    }

    public boolean m_183429_() {
        return true;
    }

    private double getAttackReachSqr(LivingEntity target) {
        return this.boss.getAttackReach();
    }

    private double getHitReachSqr(LivingEntity target) {
        double hitReach = this.boss.getAttackReach() + 1.0;
        return hitReach * hitReach + (double)target.m_20205_();
    }

    public void m_8037_() {
        if (this.remainingSwingDuration > 0) {
            if (this.boss.m_5448_() != null) {
                if (this.rageAttack != null) {
                    this.rageAttack.tick(this.getHitReachSqr(this.boss.m_5448_()));
                } else if (this.meleeAttack != null) {
                    this.meleeAttack.tick(this.getHitReachSqr(this.boss.m_5448_()));
                }
            }
            --this.remainingSwingDuration;
            if (this.remainingSwingDuration <= 0) {
                this.resetMeleeAttackValues();
            }
        } else {
            this.moveAndTryStartAttack();
        }
    }

    private void resetMeleeAttackValues() {
        if (this.rageAttack != null) {
            this.rageAttack.stop();
            this.rageAttack = null;
            this.resetRageAttackCooldown();
        } else if (this.meleeAttack != null) {
            this.meleeAttack.stop();
            this.meleeAttack = null;
            this.resetAttackCooldown();
        }
        this.boss.setActiveAttackMove("");
    }

    private void moveAndTryStartAttack() {
        LivingEntity target = this.boss.m_5448_();
        if (target != null) {
            this.boss.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            double distToTarget = this.boss.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            this.moveTowardsTarget(target, distToTarget);
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            this.ticksUntilNextRageAttack = Math.max(this.ticksUntilNextRageAttack - 1, 0);
            if (this.tryStartAttack(target, distToTarget, this.getAttackReachSqr(target))) {
                this.boss.m_21573_().m_26573_();
            }
        }
    }

    private boolean tryStartAttack(LivingEntity target, double distToTarget, double reach) {
        if (this.remainingSwingDuration <= 0) {
            if (this.isTimeToRageAttack() && this.getAndInitRandomAttack(this.boss, this.getRageAttacks()).map(attack -> {
                this.rageAttack = attack;
                if (this.rageAttack.start(target, distToTarget, reach)) {
                    this.remainingSwingDuration = this.rageAttack.getDuration();
                    this.rageAttack.getAttackMove().ifPresent(this.boss::setActiveAttackMove);
                    return true;
                }
                return false;
            }).orElse(false).booleanValue()) {
                return true;
            }
            return this.isTimeToAttack() && this.getAndInitRandomAttack(this.boss, this.getMeleeAttacks()).map(attack -> {
                this.meleeAttack = attack;
                if (this.meleeAttack.start(target, distToTarget, reach)) {
                    this.remainingSwingDuration = this.meleeAttack.getDuration();
                    this.meleeAttack.getAttackMove().ifPresent(this.boss::setActiveAttackMove);
                    return true;
                }
                return false;
            }).orElse(false) != false;
        }
        return false;
    }

    protected WeightedList<VaultBossBaseEntity.AttackData> getMeleeAttacks() {
        return this.boss.getMeleeAttacks();
    }

    protected WeightedList<VaultBossBaseEntity.AttackData> getRageAttacks() {
        return this.boss.getRageAttacks();
    }

    private Optional<IMeleeAttack> getAndInitRandomAttack(VaultBossBaseEntity boss, WeightedList<VaultBossBaseEntity.AttackData> attacks) {
        return attacks.getRandom(this.boss.m_21187_()).flatMap(attackData -> {
            if (boss.getMeleeAttackFactories().containsKey(attackData.name())) {
                return Optional.of(boss.getMeleeAttackFactories().get(attackData.name()).apply(this.boss, attackData.multiplier()));
            }
            return Optional.empty();
        });
    }

    private void moveTowardsTarget(LivingEntity target, double distToTarget) {
        this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
        if (this.boss.m_21574_().m_148306_((Entity)target) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || target.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= this.getAttackReachSqr(target) - 1.0 || this.boss.m_21573_().m_26571_() && this.boss.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= this.getAttackReachSqr(target) - 1.0)) {
            this.pathedTargetX = target.m_20185_();
            this.pathedTargetY = target.m_20186_();
            this.pathedTargetZ = target.m_20189_();
            this.ticksUntilNextPathRecalculation = 4 + this.boss.m_21187_().nextInt(7);
            if (distToTarget > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (distToTarget > 256.0) {
                this.ticksUntilNextPathRecalculation = (int)((double)this.ticksUntilNextPathRecalculation + this.boss.getAttackReach());
            }
            if (!this.boss.m_21573_().m_5624_((Entity)target, 1.0)) {
                this.ticksUntilNextPathRecalculation += 15;
            }
        }
    }

    private void resetAttackCooldown() {
        this.ticksUntilNextAttack = 10;
    }

    private void resetRageAttackCooldown() {
        this.ticksUntilNextRageAttack = (int)(20.0 * this.boss.getAttackReach());
    }

    private boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    private boolean isTimeToRageAttack() {
        return this.ticksUntilNextRageAttack <= 0 && this.boss.m_183503_().m_46467_() - 20L < this.boss.f_20930_ && !this.boss.m_183503_().m_45971_(LivingEntity.class, IMeleeAttack.ENTITIES_CLOSE_TARGETING_CONDITIONS, (LivingEntity)this.boss, this.boss.m_142469_().m_82400_(this.boss.getAttackReach())).isEmpty();
    }
}

