/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.attack;

import iskallia.vault.core.util.WeightedList;
import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.VaultBossEntity;
import iskallia.vault.entity.boss.attack.BossMeleeAttackGoal;
import iskallia.vault.entity.boss.trait.ITrait;
import iskallia.vault.entity.boss.trait.ModifierType;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class PersistentMeleeAttackGoal
extends BossMeleeAttackGoal
implements ITrait {
    public static final String TYPE = "melee_attack";
    private final WeightedList<VaultBossBaseEntity.AttackData> meleeAttacks = new WeightedList();

    public PersistentMeleeAttackGoal(VaultBossBaseEntity boss) {
        super(boss);
        this.addPunchDefault();
    }

    private void addPunchDefault() {
        this.meleeAttacks.add(new VaultBossBaseEntity.AttackData("punch", 1.0), 1);
    }

    public PersistentMeleeAttackGoal setAttributes(WeightedList<VaultBossBaseEntity.AttackData> attacks) {
        this.meleeAttacks.clear();
        attacks.forEach(this.meleeAttacks::add);
        return this;
    }

    @Override
    protected WeightedList<VaultBossBaseEntity.AttackData> getMeleeAttacks() {
        return this.meleeAttacks;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void apply(VaultBossEntity boss) {
        boss.addTraitGoal(this);
    }

    @Override
    public void addStack(@Nullable ITrait trait, ModifierType modifierType, VaultBossEntity boss) {
        if (modifierType == ModifierType.DAMAGE && trait instanceof PersistentMeleeAttackGoal) {
            PersistentMeleeAttackGoal other = (PersistentMeleeAttackGoal)trait;
            other.meleeAttacks.forEach(this.meleeAttacks::add);
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (!this.meleeAttacks.isEmpty()) {
            ListTag attacks = new ListTag();
            this.meleeAttacks.forEach((attack, weight) -> {
                CompoundTag attackNbt = new CompoundTag();
                attack.serializeTo(attackNbt);
                attackNbt.m_128347_("Weight", weight.doubleValue());
                attacks.add((Object)attackNbt);
            });
            nbt.m_128365_("Attacks", (Tag)attacks);
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, VaultBossBaseEntity boss) {
        this.meleeAttacks.clear();
        if (nbt.m_128441_("Attacks")) {
            ListTag attacks = nbt.m_128437_("Attacks", 10);
            attacks.forEach(tag -> {
                CompoundTag attackNbt = (CompoundTag)tag;
                VaultBossBaseEntity.AttackData attack = VaultBossBaseEntity.AttackData.from(attackNbt);
                if (boss.getMeleeAttackFactories().containsKey(attack.name())) {
                    double weight = attackNbt.m_128459_("Weight");
                    this.meleeAttacks.add(attack, weight);
                }
            });
        } else {
            this.addPunchDefault();
        }
    }
}

