/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.attack;

import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.attack.IMeleeAttack;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;

public class ThrowAttack
implements IMeleeAttack {
    private static final TargetingConditions TARGETING_CONDITIONS = TargetingConditions.m_148352_().m_26883_(2.0);
    private static final TargetingConditions TARGETING_CONDITIONS_WIDER = TargetingConditions.m_148352_().m_26883_(7.0);
    private final VaultBossBaseEntity artifactBossEntity;
    private final double damageMultiplier;
    private boolean hasThrown = false;
    private int throwCooldown = 0;
    private final Set<UUID> entitiesThrown = new HashSet<UUID>();

    public ThrowAttack(VaultBossBaseEntity artifactBossEntity, double damageMultiplier) {
        this.artifactBossEntity = artifactBossEntity;
        this.damageMultiplier = damageMultiplier;
    }

    @Override
    public boolean start(LivingEntity target, double distToTarget, double reach) {
        List entities = this.artifactBossEntity.m_183503_().m_45971_(LivingEntity.class, TARGETING_CONDITIONS, (LivingEntity)this.artifactBossEntity, this.artifactBossEntity.m_142469_().m_82400_(5.0));
        if (!entities.isEmpty()) {
            this.throwCooldown = 30;
            entities.forEach(player -> {
                player.f_19812_ = true;
                player.m_20242_(true);
                player.m_20256_(player.m_20182_().m_82546_(this.artifactBossEntity.m_20182_()).m_82541_().m_82542_(0.3, 0.0, 0.3).m_82520_(0.0, 0.1, 0.0));
                player.f_19864_ = true;
                this.entitiesThrown.add(player.m_142081_());
            });
            return true;
        }
        return false;
    }

    @Override
    public void stop() {
        this.hasThrown = false;
        this.entitiesThrown.forEach(playerId -> {
            Player player = this.artifactBossEntity.m_183503_().m_46003_(playerId);
            if (player != null) {
                player.m_20242_(false);
            }
        });
        this.entitiesThrown.clear();
    }

    @Override
    public void tick(double reach) {
        if (!this.hasThrown && --this.throwCooldown <= 0) {
            List entities = this.artifactBossEntity.m_183503_().m_45971_(LivingEntity.class, TARGETING_CONDITIONS_WIDER, (LivingEntity)this.artifactBossEntity, this.artifactBossEntity.m_142469_().m_82400_(7.0));
            entities.forEach(player -> {
                if (this.entitiesThrown.contains(player.m_142081_())) {
                    player.m_20242_(false);
                    player.f_19812_ = true;
                    player.m_20256_(player.m_20182_().m_82546_(this.artifactBossEntity.m_20182_()).m_82541_().m_82542_(10.0, 1.0, 10.0).m_82520_(0.0, 0.2, 0.0));
                    player.f_19864_ = true;
                    this.entitiesThrown.remove(player.m_142081_());
                }
            });
            this.entitiesThrown.forEach(playerId -> {
                Player player = this.artifactBossEntity.m_183503_().m_46003_(playerId);
                if (player != null) {
                    player.m_20242_(false);
                }
            });
            this.hasThrown = true;
        }
    }

    @Override
    public int getDuration() {
        return 50;
    }

    @Override
    public Optional<String> getAttackMove() {
        return Optional.of("summon");
    }
}

