/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.goal;

import iskallia.vault.entity.boss.BloodOrbEntity;
import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.VaultBossEntity;
import iskallia.vault.entity.boss.trait.ITrait;
import iskallia.vault.entity.boss.trait.ModifierType;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModEntities;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BloodOrbGoal
extends Goal
implements ITrait {
    private static final TargetingConditions PLAYERS_TARGETING_CONDITIONS = TargetingConditions.m_148352_().m_26883_(50.0);
    public static final String TYPE = "blood_orb";
    private final VaultBossBaseEntity boss;
    private static final int BLEED_EFFECT_APPLICATION_COOLDOWN = 20;
    private int bloodOrbSpawnIntervalMin = 40;
    private int bloodOrbSpawnIntervalMax = 100;
    private int bloodOrbSpawnRadius = 20;
    private int maxBloodOrbs = 4;
    private Set<UUID> bloodOrbs = new HashSet<UUID>();
    private int bloodOrbSpawnTimer = 0;
    private int bleedEffectTimer = 0;
    private int stackSize = 1;

    public BloodOrbGoal(VaultBossBaseEntity boss) {
        this.boss = boss;
    }

    public BloodOrbGoal setAttributes(int bloodOrbSpawnIntervalMin, int bloodOrbSpawnIntervalMax, int bloodOrbSpawnRadius, int maxBloodOrbs) {
        this.bloodOrbSpawnIntervalMin = bloodOrbSpawnIntervalMin;
        this.bloodOrbSpawnIntervalMax = bloodOrbSpawnIntervalMax;
        this.bloodOrbSpawnRadius = bloodOrbSpawnRadius;
        this.maxBloodOrbs = maxBloodOrbs;
        return this;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void apply(VaultBossEntity boss) {
        boss.addTraitGoal(this);
    }

    @Override
    public void addStack(@Nullable ITrait trait, ModifierType modifierType, VaultBossEntity boss) {
        if (modifierType == ModifierType.ABILITY_HASTE && trait instanceof BloodOrbGoal) {
            BloodOrbGoal bloodOrbGoal = (BloodOrbGoal)trait;
            ++this.stackSize;
            this.bloodOrbSpawnIntervalMin = bloodOrbGoal.bloodOrbSpawnIntervalMin * this.stackSize;
            this.bloodOrbSpawnIntervalMax = bloodOrbGoal.bloodOrbSpawnIntervalMax * this.stackSize;
        }
    }

    public boolean m_8036_() {
        return true;
    }

    public void m_8037_() {
        super.m_8037_();
        Level level = this.boss.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.bloodOrbs.removeIf(uuid -> serverLevel.m_8791_(uuid) == null);
            this.spawnBloodOrb(serverLevel);
            this.applyBleedEffect();
        }
    }

    private void spawnBloodOrb(ServerLevel serverLevel) {
        if (this.bloodOrbSpawnTimer > 0) {
            --this.bloodOrbSpawnTimer;
        }
        if (this.bloodOrbSpawnTimer <= 0) {
            if (this.bloodOrbs.size() < this.maxBloodOrbs) {
                int retries;
                Vec3 spawnPosition = this.boss.m_20182_();
                double x = spawnPosition.m_7096_() + (double)this.boss.f_19853_.f_46441_.nextInt(-this.bloodOrbSpawnRadius, this.bloodOrbSpawnRadius);
                double y = spawnPosition.m_7098_() + (double)this.boss.f_19853_.f_46441_.nextInt(-2, 2);
                double z = spawnPosition.m_7094_() + (double)this.boss.f_19853_.f_46441_.nextInt(-this.bloodOrbSpawnRadius, this.bloodOrbSpawnRadius);
                BlockPos below = new BlockPos(x, y - 1.0, z);
                for (retries = 15; !(retries <= 0 || this.boss.f_19853_.m_45772_(ModEntities.BLOOD_ORB.m_20585_(x, y, z)) && this.boss.f_19853_.m_8055_(below).m_60783_((BlockGetter)this.boss.f_19853_, below, Direction.UP)); --retries) {
                    x = spawnPosition.m_7096_() + (double)this.boss.f_19853_.f_46441_.nextInt(-this.bloodOrbSpawnRadius, this.bloodOrbSpawnRadius);
                    y = spawnPosition.m_7098_() + (double)this.boss.f_19853_.f_46441_.nextInt(-2, 2);
                    z = spawnPosition.m_7094_() + (double)this.boss.f_19853_.f_46441_.nextInt(-this.bloodOrbSpawnRadius, this.bloodOrbSpawnRadius);
                    below = new BlockPos(x, y - 1.0, z);
                }
                if (retries == 0) {
                    return;
                }
                Vec3 bloodOrbPos = new Vec3(x, y, z);
                BloodOrbEntity bloodOrbEntity = new BloodOrbEntity(this.boss.f_19853_);
                bloodOrbEntity.m_146884_(bloodOrbPos);
                bloodOrbEntity.m_20242_(false);
                serverLevel.m_7967_((Entity)bloodOrbEntity);
                this.bloodOrbs.add(bloodOrbEntity.m_142081_());
            }
            this.setBloodOrbSpawnCooldown();
        }
    }

    private void applyBleedEffect() {
        if (this.bleedEffectTimer > 0) {
            --this.bleedEffectTimer;
        }
        if (this.bleedEffectTimer <= 0 && !this.bloodOrbs.isEmpty()) {
            this.boss.f_19853_.m_45955_(PLAYERS_TARGETING_CONDITIONS, (LivingEntity)this.boss, this.boss.m_142469_().m_82400_(60.0)).forEach(player -> player.m_147207_(new MobEffectInstance(ModEffects.BLEED, 60, this.bloodOrbs.size() - 1), null));
            this.bleedEffectTimer = 20;
        }
    }

    private void setBloodOrbSpawnCooldown() {
        int playerCount = this.boss.getPlayerCount();
        int bloodOrbSpawnCooldown = this.bloodOrbSpawnIntervalMax <= this.bloodOrbSpawnIntervalMin ? this.bloodOrbSpawnIntervalMin : this.boss.f_19853_.m_5822_().nextInt(this.bloodOrbSpawnIntervalMin, this.bloodOrbSpawnIntervalMax);
        this.bloodOrbSpawnTimer = Math.max(20, (int)((double)bloodOrbSpawnCooldown - (double)bloodOrbSpawnCooldown * 0.2 * (double)playerCount));
    }

    public void m_8041_() {
        super.m_8041_();
        this.bloodOrbs.forEach(bloodOrb -> {
            ServerLevel serverLevel;
            Entity entity;
            Level patt6015$temp = this.boss.f_19853_;
            if (patt6015$temp instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)patt6015$temp).m_8791_(bloodOrb)) != null) {
                entity.m_6074_();
            }
        });
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("BloodOrbSpawnIntervalMin", this.bloodOrbSpawnIntervalMin);
        nbt.m_128405_("BloodOrbSpawnIntervalMax", this.bloodOrbSpawnIntervalMax);
        nbt.m_128405_("BloodOrbSpawnRadius", this.bloodOrbSpawnRadius);
        nbt.m_128405_("MaxBloodOrbs", this.maxBloodOrbs);
        nbt.m_128365_("BloodOrbs", (Tag)this.serializeBloodOrbs(this.bloodOrbs));
        nbt.m_128405_("StackSize", this.stackSize);
        return nbt;
    }

    private ListTag serializeBloodOrbs(Set<UUID> bloodOrbs) {
        ListTag bloodOrbList = new ListTag();
        for (UUID bloodOrb : bloodOrbs) {
            bloodOrbList.add((Object)NbtUtils.m_129226_((UUID)bloodOrb));
        }
        return bloodOrbList;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, VaultBossBaseEntity boss) {
        this.bloodOrbSpawnIntervalMin = nbt.m_128451_("BloodOrbSpawnIntervalMin");
        this.bloodOrbSpawnIntervalMax = nbt.m_128451_("BloodOrbSpawnIntervalMax");
        this.bloodOrbSpawnRadius = nbt.m_128451_("BloodOrbSpawnRadius");
        this.maxBloodOrbs = nbt.m_128451_("MaxBloodOrbs");
        if (nbt.m_128425_("BloodOrbs", 9)) {
            this.bloodOrbs = this.deserializeBloodOrbs(nbt.m_128437_("BloodOrbs", 11));
        }
        this.stackSize = nbt.m_128451_("StackSize");
    }

    private Set<UUID> deserializeBloodOrbs(ListTag bloodOrbList) {
        HashSet<UUID> bloodOrbs = new HashSet<UUID>();
        for (int i = 0; i < bloodOrbList.size(); ++i) {
            bloodOrbs.add(NbtUtils.m_129233_((Tag)bloodOrbList.get(i)));
        }
        return bloodOrbs;
    }
}

