/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.goal;

import iskallia.vault.entity.boss.ThrownCobwebEntity;
import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.goal.RangedAttackGoalBase;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;

public class CobwebRangedAttackGoal
extends RangedAttackGoalBase {
    public static final String TYPE = "cobweb_ranged_attack";
    private float inaccuracy = 12.0f;

    public CobwebRangedAttackGoal(VaultBossBaseEntity boss) {
        super(boss, 1.0, 60, 120, 25.0f, true);
    }

    public CobwebRangedAttackGoal setAttributes(double speedModifier, int attackIntervalMin, int attackIntervalMax, float attackRadius, float maxInaccuracy, boolean attackWhenInMeleeRange) {
        this.setAttackAttributes(speedModifier, attackIntervalMin, attackIntervalMax, attackRadius, attackWhenInMeleeRange);
        this.inaccuracy = maxInaccuracy;
        return this;
    }

    @Override
    public boolean m_8036_() {
        if (!super.m_8036_()) {
            return false;
        }
        return this.targetNotTouchingCobweb();
    }

    private boolean targetNotTouchingCobweb() {
        return BlockPos.m_121921_((AABB)this.target.m_142469_()).noneMatch(pos -> this.boss.m_183503_().m_8055_(pos).m_60734_() == Blocks.f_50033_);
    }

    @Override
    protected void performRangedAttack(LivingEntity target, float f1) {
        ThrownCobwebEntity cobweb = new ThrownCobwebEntity(this.boss.m_183503_(), (LivingEntity)this.boss);
        cobweb.m_6034_(cobweb.m_20185_(), this.boss.m_20227_(0.5) + 0.5, cobweb.m_20189_());
        double vectorX = target.m_20185_() - this.boss.m_20185_();
        double vectorY = target.m_20186_() - cobweb.m_20186_();
        double vectorZ = target.m_20189_() - this.boss.m_20189_();
        double gravityAdjustment = Math.sqrt(vectorX * vectorX + vectorZ * vectorZ) * (double)0.2f;
        cobweb.m_6686_(vectorX, vectorY + gravityAdjustment, vectorZ, 0.8f, this.inaccuracy);
        this.boss.m_183503_().m_7967_((Entity)cobweb);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128350_("Inaccuracy", this.inaccuracy);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, VaultBossBaseEntity boss) {
        super.deserializeNBT(nbt, boss);
        this.inaccuracy = nbt.m_128457_("Inaccuracy");
    }

    public void m_8056_() {
        super.m_8056_();
        if (this.boss.getActiveAttackMove().isEmpty()) {
            this.boss.setActiveAttackMove(TYPE);
        }
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        if (this.boss.getActiveAttackMove().map(attackMove -> attackMove.equals(TYPE)).orElse(false).booleanValue()) {
            this.boss.setActiveAttackMove("");
        }
    }
}

