/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.goal;

import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.VaultBossEntity;
import iskallia.vault.entity.boss.trait.ITrait;
import iskallia.vault.entity.boss.trait.ModifierType;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class EvokerFangsGoal
extends Goal
implements ITrait {
    public static final String TYPE = "evoker_fangs";
    private final VaultBossBaseEntity boss;
    private int attackCooldown;
    private int minAttackInterval = 100;
    private int maxAttackInterval = 200;
    private float inaccuracy = 1.3f;
    private int radius = 3;
    private int fangCount = 5;
    private float damageMultiplier = 0.7f;
    private int stackSize = 1;

    public EvokerFangsGoal(VaultBossBaseEntity boss) {
        this.boss = boss;
    }

    public EvokerFangsGoal setAttributes(int minAttackInterval, int maxAttackInterval, float inaccuracy, int radius, int fangCount, float meleeDamageMultiplier) {
        this.minAttackInterval = minAttackInterval;
        this.maxAttackInterval = maxAttackInterval;
        this.inaccuracy = inaccuracy;
        this.radius = radius;
        this.fangCount = fangCount;
        this.damageMultiplier = meleeDamageMultiplier;
        return this;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void apply(VaultBossEntity boss) {
        boss.addTraitGoal(this);
    }

    @Override
    public void addStack(@Nullable ITrait trait, ModifierType modifierType, VaultBossEntity boss) {
        if (modifierType == ModifierType.ABILITY_HASTE && trait instanceof EvokerFangsGoal) {
            EvokerFangsGoal evokerFangsGoal = (EvokerFangsGoal)trait;
            ++this.stackSize;
            this.minAttackInterval = evokerFangsGoal.minAttackInterval * this.stackSize;
            this.maxAttackInterval = evokerFangsGoal.maxAttackInterval * this.stackSize;
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("MinAttackInterval", this.minAttackInterval);
        nbt.m_128405_("MaxAttackInterval", this.maxAttackInterval);
        nbt.m_128350_("Inaccuracy", this.inaccuracy);
        nbt.m_128405_("Radius", this.radius);
        nbt.m_128405_("FangCount", this.fangCount);
        nbt.m_128350_("DamageMultiplier", this.damageMultiplier);
        nbt.m_128405_("StackSize", this.stackSize);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, VaultBossBaseEntity boss) {
        this.minAttackInterval = nbt.m_128451_("MinAttackInterval");
        this.maxAttackInterval = nbt.m_128451_("MaxAttackInterval");
        this.inaccuracy = nbt.m_128457_("Inaccuracy");
        this.radius = nbt.m_128451_("Radius");
        this.fangCount = nbt.m_128451_("FangCount");
        this.damageMultiplier = nbt.m_128457_("DamageMultiplier");
        this.stackSize = nbt.m_128451_("StackSize");
    }

    public void m_8056_() {
        super.m_8056_();
        this.attackCooldown = this.minAttackInterval + this.boss.m_21187_().nextInt(this.maxAttackInterval - this.minAttackInterval);
    }

    public void m_8037_() {
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
            return;
        }
        Vec3 position = this.boss.m_5448_().m_20182_();
        position = position.m_82520_(this.boss.m_21187_().nextGaussian() * (double)this.inaccuracy, 0.0, this.boss.m_21187_().nextGaussian() * (double)this.inaccuracy);
        this.spawnFangs(position, this.fangCount, this.radius);
        this.attackCooldown = this.minAttackInterval + this.boss.m_21187_().nextInt(this.maxAttackInterval - this.minAttackInterval);
    }

    private void spawnFangs(Vec3 position, int numberOfFangs, int fangRadius) {
        for (int i = 0; i < numberOfFangs; ++i) {
            this.getGroundPos(new BlockPos(position)).ifPresent(y -> {
                double x = position.f_82479_ + (double)this.boss.m_21187_().nextInt(fangRadius * 2) - (double)fangRadius;
                double z = position.f_82481_ + (double)this.boss.m_21187_().nextInt(fangRadius * 2) - (double)fangRadius;
                this.boss.f_19853_.m_7967_((Entity)new BossFangs(this.boss.f_19853_, x, (double)y, z, this.boss.m_21133_(Attributes.f_22281_) * (double)this.damageMultiplier));
            });
        }
    }

    private Optional<Double> getGroundPos(BlockPos pos) {
        while (pos.m_123342_() >= Mth.m_14107_((double)this.boss.m_20182_().m_7098_()) - 1) {
            BlockPos posBelow = pos.m_7495_();
            BlockState stateBelow = this.boss.f_19853_.m_8055_(posBelow);
            if (stateBelow.m_60783_((BlockGetter)this.boss.f_19853_, posBelow, Direction.UP)) {
                BlockState state;
                VoxelShape collisionShape;
                if (!this.boss.f_19853_.m_46859_(pos) && !(collisionShape = (state = this.boss.f_19853_.m_8055_(pos)).m_60812_((BlockGetter)this.boss.f_19853_, pos)).m_83281_()) {
                    return Optional.of((double)pos.m_123342_() + collisionShape.m_83297_(Direction.Axis.Y));
                }
                return Optional.of(Double.valueOf(pos.m_123342_()));
            }
            pos = pos.m_7495_();
        }
        return Optional.empty();
    }

    public boolean m_8036_() {
        return this.boss.m_5448_() != null;
    }

    private static class BossFangs
    extends EvokerFangs {
        private final double attackDamage;

        public BossFangs(Level level, double x, double y, double z, double attackDamage) {
            super(level, x, y, z, level.f_46441_.nextFloat((float)Math.PI), level.f_46441_.nextInt(10), null);
            this.attackDamage = attackDamage;
        }

        public void m_8119_() {
            super.m_6075_();
            if (this.f_19853_.f_46443_) {
                if (this.f_36919_) {
                    --this.f_36918_;
                    if (this.f_36918_ == 14) {
                        for (int i = 0; i < 12; ++i) {
                            double d0 = this.m_20185_() + (this.f_19796_.nextDouble() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                            double d1 = this.m_20186_() + 0.05 + this.f_19796_.nextDouble();
                            double d2 = this.m_20189_() + (this.f_19796_.nextDouble() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                            double d3 = (this.f_19796_.nextDouble() * 2.0 - 1.0) * 0.3;
                            double d4 = 0.3 + this.f_19796_.nextDouble() * 0.3;
                            double d5 = (this.f_19796_.nextDouble() * 2.0 - 1.0) * 0.3;
                            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123797_, d0, d1 + 1.0, d2, d3, d4, d5);
                        }
                    }
                }
            } else if (--this.f_36916_ < 0) {
                if (this.f_36916_ == -8) {
                    for (LivingEntity livingentity : this.f_19853_.m_45976_(Player.class, this.m_142469_().m_82377_(0.2, 0.0, 0.2))) {
                        this.m_36944_(livingentity);
                    }
                }
                if (!this.f_36917_) {
                    this.f_19853_.m_7605_((Entity)this, (byte)4);
                    this.f_36917_ = true;
                }
                if (--this.f_36918_ < 0) {
                    this.m_146870_();
                }
            }
        }

        public void m_36944_(LivingEntity livingEntity) {
            LivingEntity owner = this.m_36947_();
            float damage = (float)this.attackDamage;
            if (livingEntity.m_6084_() && !livingEntity.m_20147_() && livingEntity != owner) {
                if (owner == null) {
                    livingEntity.m_6469_(DamageSource.f_19319_, damage);
                } else {
                    if (owner.m_7307_((Entity)livingEntity)) {
                        return;
                    }
                    livingEntity.m_6469_(DamageSource.m_19367_((Entity)this, (Entity)owner), damage);
                }
            }
        }
    }
}

