/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.goal;

import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.VaultBossEntity;
import iskallia.vault.entity.boss.goal.RangedAttackGoalBase;
import iskallia.vault.entity.boss.trait.ITrait;
import iskallia.vault.entity.boss.trait.ModifierType;
import iskallia.vault.entity.entity.VaultFireball;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class FireballRangedAttackGoal
extends RangedAttackGoalBase {
    public static final String TYPE = "fireball_ranged_attack";
    private double maxInaccuracy = 0.5;
    private float damageMultiplier = 1.0f;

    public FireballRangedAttackGoal(VaultBossBaseEntity boss) {
        super(boss, 1.0, 20, 25.0f, true);
    }

    public FireballRangedAttackGoal setAttributes(double speedModifier, int attackIntervalMin, int attackIntervalMax, float attackRadius, double maxInaccuracy, boolean attackWhenInMeleeRange) {
        this.setAttackAttributes(speedModifier, attackIntervalMin, attackIntervalMax, attackRadius, attackWhenInMeleeRange);
        this.maxInaccuracy = maxInaccuracy;
        return this;
    }

    @Override
    public void addStack(@Nullable ITrait trait, ModifierType modifierType, VaultBossEntity boss) {
        super.addStack(trait, modifierType, boss);
        if (modifierType == ModifierType.DAMAGE && trait instanceof FireballRangedAttackGoal) {
            FireballRangedAttackGoal fireball = (FireballRangedAttackGoal)trait;
            this.damageMultiplier *= 1.05f;
        }
    }

    @Override
    protected void performRangedAttack(LivingEntity target, float f1) {
        double distanceToSqr = this.boss.m_20280_((Entity)target);
        double vectorX = target.m_20185_() - this.boss.m_20185_();
        double vectorY = target.m_20227_(0.5) - this.boss.m_20227_(0.5);
        double vectorZ = target.m_20189_() - this.boss.m_20189_();
        double inaccuracy = Math.sqrt(Math.sqrt(distanceToSqr)) * this.maxInaccuracy;
        VaultFireball vaultFireball = new VaultFireball(this.boss.m_183503_(), (LivingEntity)this.boss, 5.0f * this.damageMultiplier);
        vaultFireball.m_6034_(this.boss.m_20185_(), this.boss.m_20227_(0.5) + 0.5, this.boss.m_20189_());
        vaultFireball.m_6686_(vectorX + this.boss.m_21187_().nextGaussian() * inaccuracy, vectorY, vectorZ + this.boss.m_21187_().nextGaussian() * inaccuracy, 1.6f, 0.0f);
        this.boss.m_183503_().m_7967_((Entity)vaultFireball);
        this.boss.m_183503_().m_6263_(null, this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), SoundEvents.f_11874_, SoundSource.HOSTILE, 1.0f, 1.0f);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128347_("MaxInaccuracy", this.maxInaccuracy);
        nbt.m_128350_("DamageMultiplier", this.damageMultiplier);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, VaultBossBaseEntity boss) {
        super.deserializeNBT(nbt, boss);
        this.maxInaccuracy = nbt.m_128459_("MaxInaccuracy");
        this.damageMultiplier = nbt.m_128457_("DamageMultiplier");
    }
}

