/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.goal;

import iskallia.vault.entity.boss.GolemBossEntity;
import iskallia.vault.entity.boss.GolemHandProjectileEntity;
import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.goal.RangedAttackGoalBase;
import iskallia.vault.init.ModSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.Vec3;

public class GolemDoubleHandRangedAttackGoal
extends RangedAttackGoalBase {
    public static final String TYPE = "golem_double_hand_ranged_attack";
    private float damageMultiplier = 0.5f;

    public GolemDoubleHandRangedAttackGoal(VaultBossBaseEntity boss) {
        super(boss, 1.0, 20, 25.0f, false);
        this.setPreAttackAnimationCooldown(13);
    }

    public GolemDoubleHandRangedAttackGoal setAttributes(double speedModifier, int attackIntervalMin, int attackIntervalMax, float attackRadius, float maxInaccuracy, float damageMultiplier, boolean attackWhenInMeleeRange) {
        this.setAttackAttributes(speedModifier, attackIntervalMin, attackIntervalMax, attackRadius, attackWhenInMeleeRange);
        this.damageMultiplier = damageMultiplier;
        return this;
    }

    @Override
    protected void playPreAttackAnimation() {
        VaultBossBaseEntity vaultBossBaseEntity = this.boss;
        if (vaultBossBaseEntity instanceof GolemBossEntity) {
            GolemBossEntity golem = (GolemBossEntity)vaultBossBaseEntity;
            golem.setLaunchingLeftHand(true);
            golem.setLaunchingRightHand(true);
        }
    }

    @Override
    protected void performRangedAttack(LivingEntity target, float f1) {
        this.boss.f_19853_.m_5594_(null, this.boss.m_142538_(), ModSounds.ARTIFACT_BOSS_MAGIC_ATTACK, SoundSource.HOSTILE, 1.0f, 1.0f);
        float radiansHeadRot = (float)((double)this.boss.m_6080_() * Math.PI / 180.0);
        double rightHandOffset = 1.0;
        double rightShotPosX = this.boss.m_20185_() - rightHandOffset * (double)Mth.m_14089_((float)radiansHeadRot) - (double)Mth.m_14031_((float)radiansHeadRot) * 1.5;
        double rightShotPosY = this.boss.m_20227_(0.8);
        double rightShotPosZ = this.boss.m_20189_() - rightHandOffset * (double)Mth.m_14031_((float)radiansHeadRot) + (double)Mth.m_14089_((float)radiansHeadRot) * 1.5;
        double rightVectorX = target.m_20185_() - rightShotPosX;
        double rightVectorY = target.m_20227_(0.5) - rightShotPosY;
        double rightVectorZ = target.m_20189_() - rightShotPosZ;
        GolemHandProjectileEntity rightHandProjectile = new GolemHandProjectileEntity(this.boss.m_183503_(), this.boss, rightVectorX, rightVectorY, rightVectorZ, target, (float)(this.boss.m_21133_(Attributes.f_22281_) * (double)this.damageMultiplier), true);
        rightHandProjectile.m_6034_(rightShotPosX, rightShotPosY, rightShotPosZ);
        rightHandProjectile.m_20256_(Vec3.f_82478_.m_82520_(rightHandProjectile.f_36813_, rightHandProjectile.f_36814_, rightHandProjectile.f_36815_).m_82490_(0.95));
        this.boss.m_183503_().m_7967_((Entity)rightHandProjectile);
        double leftHandOffset = -1.0;
        double leftShotPosX = this.boss.m_20185_() - leftHandOffset * (double)Mth.m_14089_((float)radiansHeadRot) - (double)Mth.m_14031_((float)radiansHeadRot) * 1.5;
        double leftShotPosY = this.boss.m_20227_(0.8);
        double leftShotPosZ = this.boss.m_20189_() - leftHandOffset * (double)Mth.m_14031_((float)radiansHeadRot) + (double)Mth.m_14089_((float)radiansHeadRot) * 1.5;
        double leftVectorX = target.m_20185_() - leftShotPosX;
        double leftVectorY = target.m_20227_(0.5) - leftShotPosY;
        double leftVectorZ = target.m_20189_() - leftShotPosZ;
        GolemHandProjectileEntity leftHandProjectile = new GolemHandProjectileEntity(this.boss.m_183503_(), this.boss, leftVectorX, leftVectorY, leftVectorZ, target, (float)(this.boss.m_21133_(Attributes.f_22281_) * (double)this.damageMultiplier), false);
        leftHandProjectile.m_6034_(leftShotPosX, leftShotPosY, leftShotPosZ);
        leftHandProjectile.m_20256_(Vec3.f_82478_.m_82520_(leftHandProjectile.f_36813_, leftHandProjectile.f_36814_, leftHandProjectile.f_36815_).m_82490_(0.95));
        this.boss.m_183503_().m_7967_((Entity)leftHandProjectile);
        VaultBossBaseEntity vaultBossBaseEntity = this.boss;
        if (vaultBossBaseEntity instanceof GolemBossEntity) {
            GolemBossEntity golem = (GolemBossEntity)vaultBossBaseEntity;
            golem.setLaunchingRightHand(false);
            golem.setShowRightHand(false);
            golem.setLaunchingLeftHand(false);
            golem.setShowLeftHand(false);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128350_("DamageMultiplier", this.damageMultiplier);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, VaultBossBaseEntity boss) {
        super.deserializeNBT(nbt, boss);
        this.damageMultiplier = nbt.m_128457_("DamageMultiplier");
    }

    public void m_8056_() {
        super.m_8056_();
        if (this.boss.getActiveAttackMove().isEmpty()) {
            this.boss.setActiveAttackMove(TYPE);
        }
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        if (this.boss.getActiveAttackMove().map(attackMove -> attackMove.equals(TYPE)).orElse(false).booleanValue()) {
            this.boss.setActiveAttackMove("");
        }
    }
}

