/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.goal;

import iskallia.vault.entity.boss.GolemBossEntity;
import iskallia.vault.entity.boss.GolemHandProjectileEntity;
import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.goal.RangedAttackGoalBase;
import iskallia.vault.init.ModSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.Vec3;

public class GolemHandRangedAttackGoal
extends RangedAttackGoalBase {
    public static final String TYPE = "golem_hand_ranged_attack";
    private float damageMultiplier = 0.5f;

    public GolemHandRangedAttackGoal(VaultBossBaseEntity boss) {
        super(boss, 1.0, 20, 25.0f, false);
        this.setPreAttackAnimationCooldown(13);
    }

    public GolemHandRangedAttackGoal setAttributes(double speedModifier, int attackIntervalMin, int attackIntervalMax, float attackRadius, float maxInaccuracy, float damageMultiplier, boolean attackWhenInMeleeRange) {
        this.setAttackAttributes(speedModifier, attackIntervalMin, attackIntervalMax, attackRadius, attackWhenInMeleeRange);
        this.damageMultiplier = damageMultiplier;
        return this;
    }

    @Override
    protected void playPreAttackAnimation() {
        VaultBossBaseEntity vaultBossBaseEntity = this.boss;
        if (vaultBossBaseEntity instanceof GolemBossEntity) {
            GolemBossEntity golem = (GolemBossEntity)vaultBossBaseEntity;
            if (golem.m_21187_().nextFloat() > 0.5f) {
                golem.setLaunchingLeftHand(true);
            } else {
                golem.setLaunchingRightHand(true);
            }
        }
    }

    @Override
    protected void performRangedAttack(LivingEntity target, float f1) {
        GolemBossEntity golem;
        GolemBossEntity golem2;
        this.boss.f_19853_.m_5594_(null, this.boss.m_142538_(), ModSounds.ARTIFACT_BOSS_MAGIC_ATTACK, SoundSource.HOSTILE, 1.0f, 1.0f);
        VaultBossBaseEntity vaultBossBaseEntity = this.boss;
        float handOffset = vaultBossBaseEntity instanceof GolemBossEntity ? ((golem2 = (GolemBossEntity)vaultBossBaseEntity).isLaunchingRightHand() ? 1.0f : -1.0f) : 0.0f;
        float radiansHeadRot = (float)((double)this.boss.m_6080_() * Math.PI / 180.0);
        double shotPosX = this.boss.m_20185_() - (double)(handOffset * Mth.m_14089_((float)radiansHeadRot)) - (double)Mth.m_14031_((float)radiansHeadRot) * 1.5;
        double shotPosY = this.boss.m_20227_(0.8);
        double shotPosZ = this.boss.m_20189_() - (double)(handOffset * Mth.m_14031_((float)radiansHeadRot)) + (double)Mth.m_14089_((float)radiansHeadRot) * 1.5;
        double vectorX = target.m_20185_() - shotPosX;
        double vectorY = target.m_20227_(0.5) - shotPosY;
        double vectorZ = target.m_20189_() - shotPosZ;
        VaultBossBaseEntity vaultBossBaseEntity2 = this.boss;
        boolean isRightHand = vaultBossBaseEntity2 instanceof GolemBossEntity && (golem = (GolemBossEntity)vaultBossBaseEntity2).isLaunchingRightHand();
        GolemHandProjectileEntity handProjectile = new GolemHandProjectileEntity(this.boss.m_183503_(), this.boss, vectorX, vectorY, vectorZ, target, (float)(this.boss.m_21133_(Attributes.f_22281_) * (double)this.damageMultiplier), isRightHand);
        handProjectile.m_6034_(shotPosX, shotPosY, shotPosZ);
        handProjectile.m_20256_(Vec3.f_82478_.m_82520_(handProjectile.f_36813_, handProjectile.f_36814_, handProjectile.f_36815_).m_82490_(0.95));
        this.boss.m_183503_().m_7967_((Entity)handProjectile);
        VaultBossBaseEntity vaultBossBaseEntity3 = this.boss;
        if (vaultBossBaseEntity3 instanceof GolemBossEntity) {
            GolemBossEntity golem3 = (GolemBossEntity)vaultBossBaseEntity3;
            if (golem3.isLaunchingRightHand()) {
                golem3.setLaunchingRightHand(false);
                golem3.setShowRightHand(false);
            } else {
                golem3.setLaunchingLeftHand(false);
                golem3.setShowLeftHand(false);
            }
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128350_("DamageMultiplier", this.damageMultiplier);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, VaultBossBaseEntity boss) {
        super.deserializeNBT(nbt, boss);
        this.damageMultiplier = nbt.m_128457_("DamageMultiplier");
    }

    public void m_8056_() {
        super.m_8056_();
        if (this.boss.getActiveAttackMove().isEmpty()) {
            this.boss.setActiveAttackMove(TYPE);
        }
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        if (this.boss.getActiveAttackMove().map(attackMove -> attackMove.equals(TYPE)).orElse(false).booleanValue()) {
            this.boss.setActiveAttackMove("");
        }
    }
}

