/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.goal;

import iskallia.vault.entity.EarthSurgeEntity;
import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.VaultBossEntity;
import iskallia.vault.entity.boss.trait.ITrait;
import iskallia.vault.entity.boss.trait.ModifierType;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;

public class GroundSlamGoal
extends Goal
implements ITrait {
    public static final String TYPE = "ground_slam";
    public static final int SLAM_ANIMATION_COOLDOWN = 8;
    private final VaultBossBaseEntity boss;
    private int attackCooldown;
    private int minAttackInterval = 100;
    private int maxAttackInterval = 200;
    private int minRadius = 3;
    private int maxRadius = 5;
    private float minDamageMultiplier = 0.1f;
    private float maxDamageMultiplier = 1.0f;
    private int stackSize = 1;
    private boolean attacking = false;
    private int animationCoolodown = 0;
    private int baseMinAttackInterval = this.minAttackInterval;
    private int baseMaxAttackInterval = this.maxAttackInterval;
    private float baseMinDamageMultiplier = this.minDamageMultiplier;
    private float baseMaxDamageMultiplier = this.maxDamageMultiplier;

    public GroundSlamGoal(VaultBossBaseEntity boss) {
        this.boss = boss;
    }

    public GroundSlamGoal setAttributes(int minAttackInterval, int maxAttackInterval, int minRadius, int maxRadius, float minDamageMultiplier, float maxDamageMultiplier) {
        this.minAttackInterval = minAttackInterval;
        this.maxAttackInterval = maxAttackInterval;
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
        this.minDamageMultiplier = minDamageMultiplier;
        this.maxDamageMultiplier = maxDamageMultiplier;
        return this;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void apply(VaultBossEntity boss) {
        boss.addTraitGoal(this);
    }

    @Override
    public void addStack(@Nullable ITrait trait, ModifierType modifierType, VaultBossEntity boss) {
        if (modifierType == ModifierType.NONE && trait instanceof GroundSlamGoal) {
            GroundSlamGoal groundSlamGoal = (GroundSlamGoal)trait;
            this.stackSize = groundSlamGoal.stackSize;
            this.minAttackInterval = groundSlamGoal.minAttackInterval;
            this.maxAttackInterval = groundSlamGoal.maxAttackInterval;
            this.minDamageMultiplier = groundSlamGoal.minDamageMultiplier;
            this.maxDamageMultiplier = groundSlamGoal.maxDamageMultiplier;
            this.baseMinAttackInterval = groundSlamGoal.baseMinAttackInterval;
            this.baseMaxAttackInterval = groundSlamGoal.baseMaxAttackInterval;
            this.baseMinDamageMultiplier = groundSlamGoal.baseMinDamageMultiplier;
            this.baseMaxDamageMultiplier = groundSlamGoal.baseMaxDamageMultiplier;
            return;
        }
        if (modifierType == ModifierType.ABILITY_HASTE) {
            ++this.stackSize;
            this.recalculateAttackIntervals();
        }
        if (modifierType == ModifierType.DAMAGE) {
            this.minDamageMultiplier *= 1.05f;
            this.maxDamageMultiplier *= 1.05f;
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("MinAttackInterval", this.minAttackInterval);
        nbt.m_128405_("MaxAttackInterval", this.maxAttackInterval);
        nbt.m_128405_("MinRadius", this.minRadius);
        nbt.m_128405_("MaxRadius", this.maxRadius);
        nbt.m_128350_("MinDamageMultiplier", this.minDamageMultiplier);
        nbt.m_128350_("MaxDamageMultiplier", this.maxDamageMultiplier);
        nbt.m_128405_("StackSize", this.stackSize);
        nbt.m_128405_("BaseMinAttackInterval", this.baseMinAttackInterval);
        nbt.m_128405_("BaseMaxAttackInterval", this.baseMaxAttackInterval);
        nbt.m_128350_("BaseMinDamageMultiplier", this.baseMinDamageMultiplier);
        nbt.m_128350_("BaseMaxDamageMultiplier", this.baseMaxDamageMultiplier);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, VaultBossBaseEntity boss) {
        this.minAttackInterval = nbt.m_128451_("MinAttackInterval");
        this.maxAttackInterval = nbt.m_128451_("MaxAttackInterval");
        this.minRadius = nbt.m_128451_("MinRadius");
        this.maxRadius = nbt.m_128451_("MaxRadius");
        this.minDamageMultiplier = nbt.m_128457_("MinDamageMultiplier");
        this.maxDamageMultiplier = nbt.m_128457_("MaxDamageMultiplier");
        this.stackSize = nbt.m_128451_("StackSize");
        this.baseMinAttackInterval = nbt.m_128441_("BaseMinAttackInterval") ? nbt.m_128451_("BaseMinAttackInterval") : this.minAttackInterval;
        this.baseMaxAttackInterval = nbt.m_128441_("BaseMaxAttackInterval") ? nbt.m_128451_("BaseMaxAttackInterval") : this.maxAttackInterval;
        this.baseMinDamageMultiplier = nbt.m_128441_("BaseMinDamageMultiplier") ? nbt.m_128457_("BaseMinDamageMultiplier") : this.minDamageMultiplier;
        this.baseMaxDamageMultiplier = nbt.m_128441_("BaseMaxDamageMultiplier") ? nbt.m_128457_("BaseMaxDamageMultiplier") : this.maxDamageMultiplier;
    }

    private void recalculateAttackIntervals() {
        this.minAttackInterval = Math.max(1, this.baseMinAttackInterval / this.stackSize);
        this.maxAttackInterval = Math.max(this.minAttackInterval, this.baseMaxAttackInterval / this.stackSize);
    }

    public void m_8056_() {
        super.m_8056_();
        this.attackCooldown = this.maxAttackInterval <= this.minAttackInterval ? this.minAttackInterval : this.minAttackInterval + this.boss.m_21187_().nextInt(this.maxAttackInterval - this.minAttackInterval);
    }

    public void m_8037_() {
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
            return;
        }
        if (!this.attacking) {
            this.attacking = true;
            this.boss.setActiveAttackMove(TYPE);
            this.animationCoolodown = 8;
            return;
        }
        if (this.animationCoolodown > 0) {
            --this.animationCoolodown;
            return;
        }
        for (int i = 0; i < 3; ++i) {
            this.boss.m_183503_().m_6269_(null, (Entity)this.boss, SoundEvents.f_11908_, this.boss.m_5720_(), 1.0f, 0.15f + this.boss.m_183503_().f_46441_.nextFloat() * 0.2f);
        }
        float attackDamage = (float)this.boss.m_21133_(Attributes.f_22281_);
        EarthSurgeEntity earthSurge = new EarthSurgeEntity(this.boss.f_19853_, this.boss.m_142081_(), this.minRadius, this.maxRadius, this.minDamageMultiplier * attackDamage, this.maxDamageMultiplier * attackDamage, 1.05f);
        earthSurge.m_146884_(this.boss.m_20182_());
        this.boss.m_183503_().m_7967_((Entity)earthSurge);
        this.attacking = false;
        this.attackCooldown = this.minAttackInterval + this.boss.m_21187_().nextInt(Math.max(1, Math.max(this.minAttackInterval, this.maxAttackInterval - this.minAttackInterval)));
        this.stopAnimation();
    }

    public void m_8041_() {
        this.stopAnimation();
    }

    private void stopAnimation() {
        super.m_8041_();
        if (this.boss.getActiveAttackMove().map(attackMove -> attackMove.equals(TYPE)).orElse(false).booleanValue()) {
            this.boss.setActiveAttackMove("");
        }
    }

    public boolean m_8036_() {
        return this.boss.m_5448_() != null;
    }
}

