/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.goal;

import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.VaultBossEntity;
import iskallia.vault.entity.boss.trait.ITrait;
import iskallia.vault.entity.boss.trait.ModifierType;
import iskallia.vault.init.ModParticles;
import iskallia.vault.init.ModSounds;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;

public class HealGoal
extends Goal
implements ITrait {
    public static final String TYPE = "heal";
    private final VaultBossBaseEntity boss;
    private int healCooldown = 0;
    private int healInterval = 20;
    private float healPercentage = 0.1f;
    private int baseHealInterval = this.healInterval;
    private float baseHealPercentage = this.healPercentage;
    private int stackSize;

    public HealGoal(VaultBossBaseEntity boss) {
        this.boss = boss;
    }

    public HealGoal setAttributes(int healInterval, float healPercentage) {
        this.healInterval = healInterval;
        this.healPercentage = healPercentage;
        this.healPercentage = healPercentage;
        this.baseHealInterval = healInterval;
        this.baseHealPercentage = healPercentage;
        return this;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void apply(VaultBossEntity boss) {
        boss.addTraitGoal(this);
    }

    @Override
    public void addStack(@Nullable ITrait trait, ModifierType modifierType, VaultBossEntity boss) {
        if (modifierType == ModifierType.NONE && trait instanceof HealGoal) {
            HealGoal healGoal = (HealGoal)trait;
            this.stackSize = healGoal.stackSize;
            this.healInterval = healGoal.healInterval;
            this.healPercentage = healGoal.healPercentage;
            this.baseHealInterval = healGoal.baseHealInterval;
            this.baseHealPercentage = healGoal.baseHealPercentage;
            return;
        }
        if (modifierType == ModifierType.ABILITY_HASTE) {
            ++this.stackSize;
            this.healInterval = Math.max(40, this.baseHealInterval / this.stackSize);
        }
    }

    public boolean m_8036_() {
        return this.boss.m_21223_() < this.boss.m_21233_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.healCooldown = this.healInterval;
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.healCooldown > 0) {
            --this.healCooldown;
            return;
        }
        this.boss.m_5634_(this.boss.m_21233_() * this.healPercentage);
        Level level = this.boss.m_183503_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.HEAL.get()), this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), 10, 0.5, 0.5, 0.5, 0.0);
            serverLevel.m_6263_(null, this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), ModSounds.HEAL, SoundSource.HOSTILE, 0.5f, 0.95f);
        }
        this.healCooldown = this.healInterval;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("HealCooldown", this.healCooldown);
        nbt.m_128405_("HealInterval", this.healInterval);
        nbt.m_128350_("HealPercentage", this.healPercentage);
        nbt.m_128405_("StackSize", this.stackSize);
        nbt.m_128405_("BaseHealInterval", this.baseHealInterval);
        nbt.m_128350_("BaseHealPercentage", this.baseHealPercentage);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, VaultBossBaseEntity boss) {
        if (nbt.m_128441_("HealCooldown")) {
            this.healCooldown = nbt.m_128451_("HealCooldown");
        }
        if (nbt.m_128441_("HealInterval")) {
            this.healInterval = nbt.m_128451_("HealInterval");
        }
        if (nbt.m_128441_("HealPercentage")) {
            this.healPercentage = nbt.m_128457_("HealPercentage");
        }
        if (nbt.m_128441_("StackSize")) {
            this.stackSize = nbt.m_128451_("StackSize");
        }
        this.baseHealInterval = nbt.m_128441_("BaseHealInterval") ? nbt.m_128451_("BaseHealInterval") : this.healInterval;
        this.baseHealPercentage = nbt.m_128441_("BaseHealPercentage") ? nbt.m_128457_("BaseHealPercentage") : this.healPercentage;
    }
}

