/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.goal;

import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.VaultBossEntity;
import iskallia.vault.entity.boss.trait.ITrait;
import iskallia.vault.entity.boss.trait.ModifierType;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.NovaParticleMessage;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.network.PacketDistributor;

public class NovaAttackGoal
extends Goal
implements ITrait {
    public static final String TYPE = "nova_attack";
    protected final VaultBossBaseEntity boss;
    private int attackDelay = 100;
    private float radius = 5.0f;
    private float damageMultiplier = 1.5f;
    private float knockbackStrength = 0.4f;
    private int cooldownAfterNova = 400;
    private long lastSuccessfulAttackTime = 0L;
    private boolean hasTakenDamage = false;
    private long lastNovaTime = 0L;
    private Consumer<LivingHurtEvent> onHurtListener;
    private int stackSize = 1;

    public NovaAttackGoal(VaultBossBaseEntity boss) {
        this.boss = boss;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void apply(VaultBossEntity boss) {
        boss.addTraitGoal(this);
    }

    @Override
    public void addStack(@Nullable ITrait trait, ModifierType modifierType, VaultBossEntity boss) {
        if (modifierType == ModifierType.ABILITY_HASTE && trait instanceof NovaAttackGoal) {
            NovaAttackGoal novaGoal = (NovaAttackGoal)trait;
            ++this.stackSize;
            this.radius += novaGoal.radius * 0.2f;
            this.cooldownAfterNova = novaGoal.cooldownAfterNova / this.stackSize;
        }
    }

    public void m_8037_() {
        if (this.boss.getActiveAttackMove().isPresent()) {
            this.lastSuccessfulAttackTime = this.boss.m_183503_().m_46467_();
            this.hasTakenDamage = false;
        }
        if (this.canNovaAttack()) {
            this.performNovaAttack();
        }
    }

    private boolean canNovaAttack() {
        long currentTime = this.boss.m_183503_().m_46467_();
        if (currentTime - this.lastNovaTime < (long)this.cooldownAfterNova) {
            return false;
        }
        boolean hasntAttackedRecently = currentTime - this.lastSuccessfulAttackTime > (long)this.attackDelay;
        return hasntAttackedRecently && this.hasTakenDamage;
    }

    private void performNovaAttack() {
        Vec3 pos = this.boss.m_20182_();
        AABB aabb = new AABB(pos.f_82479_ - (double)this.radius, pos.f_82480_ - (double)this.radius, pos.f_82481_ - (double)this.radius, pos.f_82479_ + (double)this.radius, pos.f_82480_ + (double)this.radius, pos.f_82481_ + (double)this.radius);
        List targetEntities = this.boss.m_183503_().m_6443_(LivingEntity.class, aabb, entity -> entity != this.boss && entity.m_20270_((Entity)this.boss) <= this.radius);
        float attackDamage = (float)this.boss.m_21133_(Attributes.f_22281_);
        DamageSource damageSource = DamageSource.m_19370_((LivingEntity)this.boss);
        for (LivingEntity entity2 : targetEntities) {
            double dz;
            float distance;
            float damageModifier;
            if (entity2.m_6673_(damageSource) || !entity2.m_6469_(damageSource, attackDamage * this.damageMultiplier * (damageModifier = this.getDamageModifier(this.radius, distance = entity2.m_20270_((Entity)this.boss)))) || Mth.m_14033_((float)this.knockbackStrength, (float)0.0f)) continue;
            double dx = pos.f_82479_ - entity2.m_20185_();
            if (dx * dx + (dz = pos.f_82481_ - entity2.m_20189_()) * dz < 1.0E-4) {
                dx = (Math.random() - Math.random()) * 0.01;
                dz = (Math.random() - Math.random()) * 0.01;
            }
            entity2.m_147240_((double)this.knockbackStrength, dx, dz);
        }
        this.boss.m_183503_().m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11913_, SoundSource.HOSTILE, 1.0f, 1.0f);
        if (this.boss.m_183503_() instanceof ServerLevel) {
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new NovaParticleMessage(new Vec3(pos.f_82479_, pos.f_82480_ + (double)0.15f, pos.f_82481_), this.radius));
        }
        this.lastNovaTime = this.boss.m_183503_().m_46467_();
        this.hasTakenDamage = false;
    }

    protected float getDamageModifier(float radius, float dist) {
        if (dist >= 0.0f && dist < radius / 5.0f * 1.0f) {
            return 1.0f;
        }
        if (dist >= radius / 5.0f * 1.0f && dist < radius / 5.0f * 2.0f) {
            return 0.8f;
        }
        if (dist >= radius / 5.0f * 2.0f && dist < radius / 5.0f * 3.0f) {
            return 0.6f;
        }
        if (dist >= radius / 5.0f * 3.0f && dist < radius / 5.0f * 4.0f) {
            return 0.4f;
        }
        if (dist >= radius / 5.0f * 4.0f) {
            return 0.2f;
        }
        return 0.2f;
    }

    public void m_8056_() {
        this.onHurtListener = this::onBossHurt;
        MinecraftForge.EVENT_BUS.addListener(this.onHurtListener);
        this.lastSuccessfulAttackTime = this.boss.m_183503_().m_46467_();
    }

    private void onBossHurt(LivingHurtEvent event) {
        if (event.getEntity().m_142049_() == this.boss.m_142049_()) {
            this.hasTakenDamage = true;
        }
    }

    public void m_8041_() {
        if (this.onHurtListener != null) {
            MinecraftForge.EVENT_BUS.unregister(this.onHurtListener);
        }
    }

    public boolean m_8036_() {
        return true;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("AttackDelay", this.attackDelay);
        nbt.m_128350_("Radius", this.radius);
        nbt.m_128350_("DamageMultiplier", this.damageMultiplier);
        nbt.m_128350_("KnockbackStrength", this.knockbackStrength);
        nbt.m_128405_("CooldownAfterNova", this.cooldownAfterNova);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, VaultBossBaseEntity boss) {
        this.setAttributes(nbt.m_128451_("AttackDelay"), nbt.m_128457_("Radius"), nbt.m_128457_("DamageMultiplier"), nbt.m_128457_("KnockbackStrength"), nbt.m_128451_("CooldownAfterNova"));
    }

    public NovaAttackGoal setAttributes(int attackDelay, float radius, float damageMultiplier, float knockbackStrength, int cooldownAfterNova) {
        this.attackDelay = attackDelay;
        this.radius = radius;
        this.damageMultiplier = damageMultiplier;
        this.knockbackStrength = knockbackStrength;
        this.cooldownAfterNova = cooldownAfterNova;
        return this;
    }
}

