/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.goal;

import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.world.data.tile.PartialBlockState;
import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.VaultBossEntity;
import iskallia.vault.entity.boss.trait.ITrait;
import iskallia.vault.entity.boss.trait.ModifierType;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.block.Blocks;

public class PlaceBlockAroundGoal
extends Goal
implements ITrait {
    public static final String TYPE = "place_block_around";
    private final VaultBossEntity boss;
    private int placeTime = -1;
    private int radius;
    private int maxYOffset;
    private int placeIntervalMin;
    private int placeIntervalMax;
    private PartialBlockState blockState;
    private int stackSize = 1;
    private int basePlaceIntervalMin;
    private int basePlaceIntervalMax;

    public PlaceBlockAroundGoal(VaultBossEntity boss) {
        this.boss = boss;
    }

    public PlaceBlockAroundGoal setAttributes(int radius, int maxYOffset, int placeIntervalMin, int placeIntervalMax, PartialBlockState blockState) {
        this.radius = radius;
        this.maxYOffset = maxYOffset;
        this.placeIntervalMin = placeIntervalMin;
        this.placeIntervalMax = placeIntervalMax;
        this.blockState = blockState;
        this.basePlaceIntervalMin = placeIntervalMin;
        this.basePlaceIntervalMax = placeIntervalMax;
        return this;
    }

    public boolean m_8036_() {
        return true;
    }

    public void m_8037_() {
        if (--this.placeTime == 0) {
            this.placeBlock();
            this.placeTime = this.placeIntervalMin + this.boss.m_21187_().nextInt(this.placeIntervalMax - this.placeIntervalMin + 1);
        } else if (this.placeTime < 0) {
            this.placeTime = this.placeIntervalMin + this.boss.m_21187_().nextInt(this.placeIntervalMax - this.placeIntervalMin + 1);
        }
    }

    private void placeBlock() {
        for (int tries = 0; tries < 10; ++tries) {
            int z;
            int y;
            int x = Mth.m_14107_((double)(this.boss.m_20185_() + (double)(this.boss.m_21187_().nextInt(this.radius + 1) * 2) - (double)this.radius));
            BlockPos pos = new BlockPos(x, y = Mth.m_14107_((double)(this.boss.m_20186_() + (double)(this.boss.m_21187_().nextInt(this.maxYOffset + 1) * 2) - (double)this.maxYOffset)), z = Mth.m_14107_((double)(this.boss.m_20189_() + (double)(this.boss.m_21187_().nextInt(this.radius + 1) * 2) - (double)this.radius)));
            if (!this.boss.f_19853_.m_8055_(pos).m_60795_() || this.boss.m_142469_().m_82393_((double)x, (double)y, (double)z)) continue;
            this.blockState.place((CommonLevelAccessor)this.boss.f_19853_, pos, 3);
            return;
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("radius", this.radius);
        tag.m_128405_("maxYOffset", this.maxYOffset);
        tag.m_128405_("placeIntervalMin", this.placeIntervalMin);
        tag.m_128405_("placeIntervalMax", this.placeIntervalMax);
        Adapters.PARTIAL_BLOCK_STATE.writeNbt(this.blockState, tag).ifPresent(nbt -> tag.m_128365_("blockState", nbt));
        tag.m_128405_("stackSize", this.stackSize);
        tag.m_128405_("basePlaceIntervalMin", this.basePlaceIntervalMin);
        tag.m_128405_("basePlaceIntervalMax", this.basePlaceIntervalMax);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, VaultBossBaseEntity boss) {
        this.radius = nbt.m_128451_("radius");
        this.maxYOffset = nbt.m_128451_("maxYOffset");
        this.placeIntervalMin = nbt.m_128451_("placeIntervalMin");
        this.placeIntervalMax = nbt.m_128451_("placeIntervalMax");
        this.blockState = Adapters.PARTIAL_BLOCK_STATE.readNbt((Tag)nbt.m_128469_("blockState")).orElseGet(() -> PartialBlockState.of(Blocks.f_50016_.m_49966_()));
        this.stackSize = nbt.m_128451_("stackSize");
        this.basePlaceIntervalMin = nbt.m_128441_("basePlaceIntervalMin") ? nbt.m_128451_("basePlaceIntervalMin") : this.placeIntervalMin;
        this.basePlaceIntervalMax = nbt.m_128441_("basePlaceIntervalMax") ? nbt.m_128451_("basePlaceIntervalMax") : this.placeIntervalMax;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void apply(VaultBossEntity boss) {
        boss.addTraitGoal(this);
    }

    @Override
    public void addStack(@Nullable ITrait trait, ModifierType modifierType, VaultBossEntity boss) {
        if (modifierType == ModifierType.NONE && trait instanceof PlaceBlockAroundGoal) {
            PlaceBlockAroundGoal other = (PlaceBlockAroundGoal)trait;
            this.radius = other.radius;
            this.maxYOffset = other.maxYOffset;
            this.placeIntervalMin = other.placeIntervalMin;
            this.placeIntervalMax = other.placeIntervalMax;
            this.basePlaceIntervalMin = other.basePlaceIntervalMin;
            this.basePlaceIntervalMax = other.basePlaceIntervalMax;
            return;
        }
        if (modifierType == ModifierType.ABILITY_HASTE) {
            ++this.stackSize;
            this.placeIntervalMin = Math.max(1, this.basePlaceIntervalMin / this.stackSize);
            this.placeIntervalMax = Math.max(this.placeIntervalMin, this.basePlaceIntervalMax / this.stackSize);
        }
    }
}

