/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.goal;

import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.VaultBossEntity;
import iskallia.vault.entity.boss.trait.ITrait;
import iskallia.vault.entity.boss.trait.ModifierType;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionAuraGoal
extends Goal
implements ITrait {
    public static final int MAX_DISTANCE = 64;
    private static final TargetingConditions TARGETING_CONDITIONS = TargetingConditions.m_148352_().m_26883_(64.0);
    public static String TYPE = "potion_aura";
    private static final int CHECK_COOLDOWN = 5;
    @Nullable
    private MobEffect mobEffect;
    private int duration;
    private int amplifier;
    private int range;
    private boolean invertEffectRange;
    private final VaultBossBaseEntity boss;
    private long cooldownTime = -1L;
    private int baseDuration = this.duration;
    private int baseAmplifier = this.amplifier;

    public PotionAuraGoal(VaultBossBaseEntity boss) {
        this.boss = boss;
    }

    public PotionAuraGoal setAttributes(MobEffect mobEffect, int duration, int amplifier, int range, boolean invertEffectRange) {
        this.mobEffect = mobEffect;
        this.duration = duration;
        this.amplifier = amplifier;
        this.range = range;
        this.invertEffectRange = invertEffectRange;
        this.baseDuration = duration;
        this.baseAmplifier = amplifier;
        return this;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void apply(VaultBossEntity boss) {
        boss.addTraitGoal(this);
    }

    @Override
    public void addStack(@Nullable ITrait trait, ModifierType modifierType, VaultBossEntity boss) {
        if (modifierType == ModifierType.NONE && trait instanceof PotionAuraGoal) {
            PotionAuraGoal potionAuraGoal = (PotionAuraGoal)trait;
            this.amplifier = potionAuraGoal.amplifier;
            this.duration = potionAuraGoal.duration;
            this.baseAmplifier = potionAuraGoal.baseAmplifier;
            this.baseDuration = potionAuraGoal.baseDuration;
            return;
        }
        if (modifierType == ModifierType.DAMAGE) {
            this.amplifier += Math.max(1, this.baseAmplifier);
        }
        if (modifierType == ModifierType.HEALTH) {
            this.duration += this.baseDuration / 2;
        }
    }

    public boolean m_8036_() {
        return true;
    }

    public void m_8037_() {
        if (this.mobEffect == null || this.boss.m_183503_().m_5776_() || this.cooldownTime > this.boss.m_183503_().m_46467_()) {
            return;
        }
        this.cooldownTime = this.boss.m_183503_().m_46467_() + 5L;
        if (this.effectOutsideOfRange()) {
            this.boss.m_183503_().m_45955_(TARGETING_CONDITIONS, (LivingEntity)this.boss, this.boss.m_142469_().m_82400_(64.0)).forEach(player -> {
                if (player.m_20270_((Entity)this.boss) < (float)this.range) {
                    return;
                }
                this.applyEffectTo((Player)player);
            });
        } else {
            this.boss.m_183503_().m_45955_(TARGETING_CONDITIONS, (LivingEntity)this.boss, this.boss.m_142469_().m_82400_((double)this.range)).forEach(this::applyEffectTo);
        }
    }

    private void applyEffectTo(Player player) {
        if (player.m_21023_(this.mobEffect)) {
            if (player.m_21124_(this.mobEffect).m_19564_() < this.amplifier) {
                player.m_21195_(this.mobEffect);
            } else {
                return;
            }
        }
        player.m_7292_(new MobEffectInstance(this.mobEffect, this.duration, this.amplifier));
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("MobEffect", this.mobEffect.getRegistryName().toString());
        nbt.m_128405_("Duration", this.duration);
        nbt.m_128405_("Amplifier", this.amplifier);
        nbt.m_128405_("Range", this.range);
        nbt.m_128379_("InvertEffectRange", this.invertEffectRange);
        nbt.m_128405_("BaseDuration", this.baseDuration);
        nbt.m_128405_("BaseAmplifier", this.baseAmplifier);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, VaultBossBaseEntity boss) {
        this.mobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(nbt.m_128461_("MobEffect")));
        this.duration = nbt.m_128451_("Duration");
        this.amplifier = nbt.m_128451_("Amplifier");
        this.range = nbt.m_128451_("Range");
        this.invertEffectRange = nbt.m_128471_("InvertEffectRange");
        this.baseDuration = nbt.m_128441_("BaseDuration") ? nbt.m_128451_("BaseDuration") : this.duration;
        this.baseAmplifier = nbt.m_128441_("BaseAmplifier") ? nbt.m_128451_("BaseAmplifier") : this.amplifier;
    }

    public int getRange() {
        return this.range;
    }

    public MobEffect getMobEffect() {
        return this.mobEffect;
    }

    public boolean effectOutsideOfRange() {
        return this.invertEffectRange;
    }
}

