/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.goal;

import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.VaultBossEntity;
import iskallia.vault.entity.boss.trait.ITrait;
import iskallia.vault.entity.boss.trait.ModifierType;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public abstract class RangedAttackGoalBase
extends Goal
implements ITrait {
    protected final VaultBossBaseEntity boss;
    @Nullable
    protected LivingEntity target;
    private int attackTime = -1;
    private int preAttackAnimationCooldown = -1;
    private double speedModifier;
    private int seeTime;
    private int attackIntervalMin;
    private int attackIntervalMax;
    private int preAttackAnimationDuration = 0;
    private float attackRadius;
    private boolean attackWhenInMeleeReach;
    private int baseAttackIntervalMin;
    private int baseAttackIntervalMax;
    private boolean hasRunningNavigation = false;
    private int stackSize = 1;

    public RangedAttackGoalBase(VaultBossBaseEntity boss, double speedModifier, int attackInterval, float attackRadius, boolean attackWhenInMeleeReach) {
        this(boss, speedModifier, attackInterval, attackInterval, attackRadius, attackWhenInMeleeReach);
    }

    public RangedAttackGoalBase(VaultBossBaseEntity boss, double speedModifier, int attackIntervalMin, int attackIntervalMax, float attackRadius, boolean attackWhenInMeleeReach) {
        this.boss = boss;
        this.setAttackAttributes(speedModifier, attackIntervalMin, attackIntervalMax, attackRadius, attackWhenInMeleeReach);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    protected void setPreAttackAnimationCooldown(int preAttackAnimationDuration) {
        this.preAttackAnimationDuration = preAttackAnimationDuration;
    }

    protected void setAttackAttributes(double speedModifier, int attackIntervalMin, int attackIntervalMax, float attackRadius, boolean attackWhenInMeleeReach) {
        this.speedModifier = speedModifier;
        this.attackIntervalMin = attackIntervalMin;
        this.attackIntervalMax = attackIntervalMax;
        this.attackRadius = attackRadius;
        this.attackWhenInMeleeReach = attackWhenInMeleeReach;
        if (this.baseAttackIntervalMin == 0 || this.baseAttackIntervalMax == 0) {
            this.baseAttackIntervalMin = attackIntervalMin;
            this.baseAttackIntervalMax = attackIntervalMax;
        }
    }

    public boolean m_8036_() {
        LivingEntity potentialTarget = this.boss.m_5448_();
        if (potentialTarget != null && potentialTarget.m_6084_() && this.shouldAttackInOrIsOutOfMeleeRange(potentialTarget)) {
            this.target = potentialTarget;
            return true;
        }
        return false;
    }

    private boolean shouldAttackInOrIsOutOfMeleeRange(LivingEntity target) {
        return this.attackWhenInMeleeReach || (double)this.boss.m_20270_((Entity)target) > this.boss.getAttackReach();
    }

    public boolean m_8045_() {
        return this.m_8036_() || !this.boss.m_21573_().m_26571_();
    }

    public void m_8041_() {
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
        this.preAttackAnimationCooldown = -1;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        double distanceSqr = this.boss.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        boolean hasLineOfSight = this.boss.m_21574_().m_148306_((Entity)this.target);
        this.seeTime = hasLineOfSight ? ++this.seeTime : 0;
        if (this.hasRunningNavigation && !(distanceSqr > (double)this.attackRadius * (double)this.attackRadius) && this.seeTime >= 5) {
            this.boss.m_21573_().m_26573_();
            this.hasRunningNavigation = false;
        } else {
            this.boss.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
            this.hasRunningNavigation = true;
        }
        this.boss.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        if (--this.attackTime == 0) {
            this.preAttackAnimationCooldown = this.preAttackAnimationDuration;
            this.playPreAttackAnimation();
        } else if (this.attackTime > 0) {
            return;
        }
        if (this.preAttackAnimationCooldown-- == 0) {
            if (!hasLineOfSight) {
                return;
            }
            float normalizedDistance = (float)Math.sqrt(distanceSqr) / this.attackRadius;
            this.performRangedAttack(this.target, Mth.m_14036_((float)normalizedDistance, (float)0.1f, (float)1.0f));
            this.attackTime = Mth.m_14143_((float)(normalizedDistance * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
            this.preAttackAnimationCooldown = this.preAttackAnimationDuration;
        } else if (this.preAttackAnimationCooldown < 0) {
            this.attackTime = Mth.m_14107_((double)Mth.m_14139_((double)(Math.sqrt(distanceSqr) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.attackIntervalMax));
            this.preAttackAnimationCooldown = this.preAttackAnimationDuration;
        }
    }

    protected void playPreAttackAnimation() {
    }

    protected abstract void performRangedAttack(LivingEntity var1, float var2);

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128350_("SpeedModifier", (float)this.speedModifier);
        nbt.m_128405_("AttackIntervalMin", this.attackIntervalMin);
        nbt.m_128405_("AttackIntervalMax", this.attackIntervalMax);
        nbt.m_128350_("AttackRadius", this.attackRadius);
        nbt.m_128379_("AttackWhenInMeleeReach", this.attackWhenInMeleeReach);
        nbt.m_128405_("StackSize", this.stackSize);
        nbt.m_128405_("BaseAttackIntervalMin", this.baseAttackIntervalMin);
        nbt.m_128405_("BaseAttackIntervalMax", this.baseAttackIntervalMax);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, VaultBossBaseEntity boss) {
        this.setAttackAttributes(nbt.m_128457_("SpeedModifier"), nbt.m_128451_("AttackIntervalMin"), nbt.m_128451_("AttackIntervalMax"), nbt.m_128457_("AttackRadius"), nbt.m_128471_("AttackWhenInMeleeReach"));
        this.stackSize = nbt.m_128451_("StackSize");
        this.baseAttackIntervalMin = nbt.m_128441_("BaseAttackIntervalMin") ? nbt.m_128451_("BaseAttackIntervalMin") : this.attackIntervalMin;
        this.baseAttackIntervalMax = nbt.m_128441_("BaseAttackIntervalMax") ? nbt.m_128451_("BaseAttackIntervalMax") : this.attackIntervalMax;
    }

    @Override
    public void apply(VaultBossEntity boss) {
        boss.addTraitGoal(this);
    }

    @Override
    public void addStack(@Nullable ITrait trait, ModifierType modifierType, VaultBossEntity boss) {
        if (modifierType == ModifierType.NONE && trait instanceof RangedAttackGoalBase) {
            RangedAttackGoalBase rangedAttackGoal = (RangedAttackGoalBase)trait;
            this.stackSize = rangedAttackGoal.stackSize;
            this.baseAttackIntervalMin = rangedAttackGoal.baseAttackIntervalMin;
            this.baseAttackIntervalMax = rangedAttackGoal.baseAttackIntervalMax;
            this.attackIntervalMin = rangedAttackGoal.attackIntervalMin;
            this.attackIntervalMax = rangedAttackGoal.attackIntervalMax;
            return;
        }
        if (modifierType == ModifierType.ABILITY_HASTE) {
            ++this.stackSize;
            this.recalculateAttackIntervals();
        }
    }

    private void recalculateAttackIntervals() {
        if (this.baseAttackIntervalMin <= 0 || this.baseAttackIntervalMax <= 0) {
            return;
        }
        this.attackIntervalMin = Math.max(1, this.baseAttackIntervalMin / this.stackSize);
        this.attackIntervalMax = Math.max(this.attackIntervalMin, this.baseAttackIntervalMax / this.stackSize);
    }
}

