/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.goal;

import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.VaultBossEntity;
import iskallia.vault.entity.boss.trait.ITrait;
import iskallia.vault.entity.boss.trait.ModifierType;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class RetaliationGoal
extends Goal
implements ITrait {
    public static final String TYPE = "retaliation";
    protected final VaultBossBaseEntity boss;
    private int attackDelay = 80;
    private String retaliationAttack = "ground_slam";
    private float damageMultiplier = 1.5f;
    private int cooldownAfterRetaliation = 300;
    private long lastSuccessfulAttackTime = 0L;
    private boolean hasTakenDamage = false;
    private long lastRetaliationTime = 0L;
    private Consumer<LivingHurtEvent> onHurtListener;
    private int stackSize = 1;

    public RetaliationGoal(VaultBossBaseEntity boss) {
        this.boss = boss;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void apply(VaultBossEntity boss) {
        boss.addTraitGoal(this);
    }

    @Override
    public void addStack(@Nullable ITrait trait, ModifierType modifierType, VaultBossEntity boss) {
        if (modifierType == ModifierType.ABILITY_HASTE && trait instanceof RetaliationGoal) {
            RetaliationGoal retaliationGoal = (RetaliationGoal)trait;
            ++this.stackSize;
            this.cooldownAfterRetaliation = retaliationGoal.cooldownAfterRetaliation / this.stackSize;
        }
    }

    public void m_8037_() {
        if (this.boss.getActiveAttackMove().isPresent()) {
            this.lastSuccessfulAttackTime = this.boss.m_183503_().m_46467_();
        }
        if (this.canRetaliate()) {
            this.performRetaliation();
        }
    }

    private boolean canRetaliate() {
        long currentTime = this.boss.m_183503_().m_46467_();
        if (currentTime - this.lastRetaliationTime < (long)this.cooldownAfterRetaliation) {
            return false;
        }
        boolean hasntAttackedRecently = currentTime - this.lastSuccessfulAttackTime > (long)this.attackDelay;
        return hasntAttackedRecently && this.hasTakenDamage;
    }

    private void performRetaliation() {
        this.boss.setActiveAttackMove("nova_attack");
        this.lastRetaliationTime = this.boss.m_183503_().m_46467_();
        this.hasTakenDamage = false;
    }

    public void m_8056_() {
        this.onHurtListener = this::onBossHurt;
        MinecraftForge.EVENT_BUS.addListener(this.onHurtListener);
        this.lastSuccessfulAttackTime = this.boss.m_183503_().m_46467_();
    }

    private void onBossHurt(LivingHurtEvent event) {
        if (event.getEntity().m_142049_() == this.boss.m_142049_()) {
            this.hasTakenDamage = true;
        }
    }

    public void m_8041_() {
        if (this.onHurtListener != null) {
            MinecraftForge.EVENT_BUS.unregister(this.onHurtListener);
        }
    }

    public boolean m_8036_() {
        return true;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("AttackDelay", this.attackDelay);
        nbt.m_128359_("RetaliationAttack", this.retaliationAttack);
        nbt.m_128350_("DamageMultiplier", this.damageMultiplier);
        nbt.m_128405_("CooldownAfterRetaliation", this.cooldownAfterRetaliation);
        nbt.m_128356_("LastSuccessfulAttackTime", this.lastSuccessfulAttackTime);
        nbt.m_128379_("HasTakenDamage", this.hasTakenDamage);
        nbt.m_128356_("LastRetaliationTime", this.lastRetaliationTime);
        nbt.m_128405_("StackSize", this.stackSize);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, VaultBossBaseEntity boss) {
        this.setAttributes(nbt.m_128451_("AttackDelay"), nbt.m_128461_("RetaliationAttack"), nbt.m_128457_("DamageMultiplier"), nbt.m_128451_("CooldownAfterRetaliation"));
        this.lastSuccessfulAttackTime = nbt.m_128454_("LastSuccessfulAttackTime");
        this.hasTakenDamage = nbt.m_128471_("HasTakenDamage");
        this.lastRetaliationTime = nbt.m_128454_("LastRetaliationTime");
        this.stackSize = nbt.m_128451_("StackSize");
    }

    public RetaliationGoal setAttributes(int attackDelay, String retaliationAttack, float damageMultiplier, int cooldownAfterRetaliation) {
        this.attackDelay = attackDelay;
        this.retaliationAttack = retaliationAttack;
        this.damageMultiplier = damageMultiplier;
        this.cooldownAfterRetaliation = cooldownAfterRetaliation;
        return this;
    }
}

