/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.goal;

import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.VaultBossEntity;
import iskallia.vault.entity.boss.trait.ITrait;
import iskallia.vault.entity.boss.trait.ModifierType;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.ShulkerBullet;

public class ShulkerAttackGoal
extends Goal
implements ITrait {
    public static final String TYPE = "shulker_bullet";
    private final VaultBossBaseEntity boss;
    private int attackIntervalMax;
    private int attackIntervalMin;
    private int attackTime;
    private int stackSize;

    public ShulkerAttackGoal(VaultBossBaseEntity boss) {
        this.boss = boss;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public ShulkerAttackGoal setAttributes(int attackIntervalMin, int attackIntervalMax) {
        this.attackIntervalMin = attackIntervalMin;
        this.attackIntervalMax = attackIntervalMax;
        return this;
    }

    public boolean m_8036_() {
        LivingEntity livingEntity = this.boss.m_5448_();
        return livingEntity != null && livingEntity.m_6084_();
    }

    public void m_8056_() {
        this.attackTime = this.boss.m_183503_().m_5822_().nextInt(this.attackIntervalMin, this.attackIntervalMax);
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        --this.attackTime;
        LivingEntity livingentity = this.boss.m_5448_();
        if (livingentity != null) {
            this.boss.m_21563_().m_24960_((Entity)livingentity, 180.0f, 180.0f);
            double distanceSqr = this.boss.m_20280_((Entity)livingentity);
            if (distanceSqr < 400.0) {
                if (this.attackTime <= 0) {
                    this.attackTime = 20 + this.boss.m_21187_().nextInt(10) * 20 / 2;
                    this.boss.f_19853_.m_7967_((Entity)new ShulkerBullet(this.boss.f_19853_, (LivingEntity)this.boss, (Entity)livingentity, Direction.Axis.Y));
                    this.boss.m_5496_(SoundEvents.f_12417_, 2.0f, (this.boss.m_21187_().nextFloat() - this.boss.m_21187_().nextFloat()) * 0.2f + 1.0f);
                }
            } else {
                this.boss.m_6710_(null);
            }
            super.m_8037_();
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void apply(VaultBossEntity boss) {
        boss.addTraitGoal(this);
    }

    @Override
    public void addStack(@Nullable ITrait trait, ModifierType modifierType, VaultBossEntity boss) {
        if (modifierType == ModifierType.ABILITY_HASTE && trait instanceof ShulkerAttackGoal) {
            ShulkerAttackGoal shulkerAttackGoal = (ShulkerAttackGoal)trait;
            ++this.stackSize;
            this.attackIntervalMin = shulkerAttackGoal.attackIntervalMin * this.stackSize;
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("AttackIntervalMin", this.attackIntervalMin);
        nbt.m_128405_("AttackIntervalMax", this.attackIntervalMax);
        nbt.m_128405_("StackSize", this.stackSize);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, VaultBossBaseEntity boss) {
        this.attackIntervalMin = nbt.m_128451_("AttackIntervalMin");
        this.attackIntervalMax = nbt.m_128451_("AttackIntervalMax");
        this.stackSize = nbt.m_128451_("StackSize");
    }
}

