/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.goal;

import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.VaultBossEntity;
import iskallia.vault.entity.boss.goal.RangedAttackGoalBase;
import iskallia.vault.entity.boss.trait.ITrait;
import iskallia.vault.entity.boss.trait.ModifierType;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.phys.EntityHitResult;

public class SnowballRangedAttackGoal
extends RangedAttackGoalBase {
    public static final String TYPE = "snowball_ranged_attack";
    private float inaccuracy = 12.0f;
    private float damageMultiplier = 0.5f;
    private float baseDamageMultiplier = 0.5f;

    public SnowballRangedAttackGoal(VaultBossBaseEntity boss) {
        super(boss, 1.0, 20, 25.0f, false);
    }

    public SnowballRangedAttackGoal setAttributes(double speedModifier, int attackIntervalMin, int attackIntervalMax, float attackRadius, float maxInaccuracy, float damageMultiplier, boolean attackWhenInMeleeRange) {
        this.setAttackAttributes(speedModifier, attackIntervalMin, attackIntervalMax, attackRadius, attackWhenInMeleeRange);
        this.inaccuracy = maxInaccuracy;
        this.damageMultiplier = damageMultiplier;
        this.baseDamageMultiplier = damageMultiplier;
        return this;
    }

    @Override
    public void addStack(@Nullable ITrait trait, ModifierType modifierType, VaultBossEntity boss) {
        super.addStack(trait, modifierType, boss);
        if (modifierType == ModifierType.NONE && trait instanceof SnowballRangedAttackGoal) {
            SnowballRangedAttackGoal other = (SnowballRangedAttackGoal)trait;
            this.damageMultiplier = other.damageMultiplier;
            this.baseDamageMultiplier = other.baseDamageMultiplier;
        }
        if (modifierType == ModifierType.DAMAGE) {
            this.damageMultiplier *= 1.05f;
        }
    }

    @Override
    protected void performRangedAttack(LivingEntity target, float f1) {
        Snowball snowball = new Snowball(this.boss.m_183503_(), (LivingEntity)this.boss){

            protected void m_5790_(EntityHitResult pResult) {
                Entity entity = pResult.m_82443_();
                entity.m_6469_(DamageSource.m_19361_((Entity)this, (Entity)this.m_37282_()), (float)(SnowballRangedAttackGoal.this.boss.m_21133_(Attributes.f_22281_) * (double)SnowballRangedAttackGoal.this.damageMultiplier));
            }
        };
        snowball.m_6034_(snowball.m_20185_(), this.boss.m_20227_(0.5) + 0.5, snowball.m_20189_());
        double targetY = target.m_20188_() - (double)1.1f;
        double vectorX = target.m_20185_() - this.boss.m_20185_();
        double vectorY = targetY - snowball.m_20186_();
        double vectorZ = target.m_20189_() - this.boss.m_20189_();
        double gravityAdjustment = Math.sqrt(vectorX * vectorX + vectorZ * vectorZ) * (double)0.2f;
        snowball.m_6686_(vectorX, vectorY + gravityAdjustment, vectorZ, 1.6f, this.inaccuracy);
        this.boss.m_183503_().m_7967_((Entity)snowball);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128350_("DamageMultiplier", this.damageMultiplier);
        nbt.m_128350_("Inaccuracy", this.inaccuracy);
        nbt.m_128350_("BaseDamageMultiplier", this.baseDamageMultiplier);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, VaultBossBaseEntity boss) {
        super.deserializeNBT(nbt, boss);
        this.damageMultiplier = nbt.m_128457_("DamageMultiplier");
        this.inaccuracy = nbt.m_128457_("Inaccuracy");
        this.baseDamageMultiplier = nbt.m_128441_("BaseDamageMultiplier") ? nbt.m_128457_("BaseDamageMultiplier") : this.damageMultiplier;
    }

    public void m_8056_() {
        super.m_8056_();
        if (this.boss.getActiveAttackMove().isEmpty()) {
            this.boss.setActiveAttackMove(TYPE);
        }
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        if (this.boss.getActiveAttackMove().map(attackMove -> attackMove.equals(TYPE)).orElse(false).booleanValue()) {
            this.boss.setActiveAttackMove("");
        }
    }
}

