/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.goal;

import iskallia.vault.VaultMod;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.entity.boss.MobSpawningUtils;
import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.VaultBossEntity;
import iskallia.vault.entity.boss.trait.AttributeModifierTrait;
import iskallia.vault.entity.boss.trait.ITrait;
import iskallia.vault.entity.boss.trait.ModifierType;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class SummonGoal
extends Goal
implements ITrait {
    public static final String TYPE = "summon";
    protected final VaultBossBaseEntity boss;
    private int maxMobsAliveBeforeNextSpawn = 5;
    private int minMobSpawnCount = 1;
    private int maxMobSpawnCount = 5;
    private WeightedList<MobSpawningUtils.EntitySpawnData> entityTypes = (WeightedList)WeightedList.empty();
    private int minDistanceFromCenter = 2;
    private int radius = 10;
    private int spawnInterval;
    private int baseSpawnInterval = this.spawnInterval = 20;
    private long lastSpawnCheckTime = 0L;
    private final Set<UUID> spawnedMobs = new HashSet<UUID>();
    private long lastMobDeathCheckTime = 0L;
    private Consumer<LivingDeathEvent> onLivingDeath;
    private int stackSize = 1;

    public SummonGoal(VaultBossBaseEntity boss) {
        this.boss = boss;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void apply(VaultBossEntity boss) {
        boss.addTraitGoal(this);
    }

    @Override
    public void addStack(@Nullable ITrait trait, ModifierType modifierType, VaultBossEntity boss) {
        if (modifierType == ModifierType.NONE && trait instanceof SummonGoal) {
            SummonGoal summoningGoal = (SummonGoal)trait;
            this.stackSize = summoningGoal.stackSize;
            this.spawnInterval = summoningGoal.spawnInterval;
            this.baseSpawnInterval = summoningGoal.baseSpawnInterval;
            return;
        }
        if (modifierType == ModifierType.ABILITY_HASTE) {
            ++this.stackSize;
            this.spawnInterval = Math.max(1, this.baseSpawnInterval / this.stackSize);
        }
    }

    public void m_8037_() {
        int mobsToSpawn;
        ServerLevel serverLevel;
        Level level = this.boss.m_183503_();
        if (level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            if (this.lastMobDeathCheckTime + 20L < this.boss.m_183503_().m_46467_()) {
                this.lastMobDeathCheckTime = this.boss.m_183503_().m_46467_();
                this.spawnedMobs.removeIf(uuid -> serverLevel.m_8791_(uuid) == null);
            }
        }
        if (!((level = this.boss.m_183503_()) instanceof ServerLevel)) {
            return;
        }
        serverLevel = (ServerLevel)level;
        if (this.lastSpawnCheckTime + (long)this.spawnInterval > this.boss.m_183503_().m_46467_()) {
            return;
        }
        this.lastSpawnCheckTime = this.boss.m_183503_().m_46467_();
        if (this.spawnedMobs.size() > this.maxMobsAliveBeforeNextSpawn * this.boss.getPlayerCount()) {
            return;
        }
        if (this.minMobSpawnCount > this.maxMobSpawnCount) {
            mobsToSpawn = this.boss.getPlayerAdjustedRandomCount(this.minMobSpawnCount, this.minMobSpawnCount, 0.4f);
            VaultMod.LOGGER.error("minMobCount is greater than maxMobCount in summoning stage attributes, defaulting to minMobCount");
        } else {
            mobsToSpawn = this.boss.getPlayerAdjustedRandomCount(this.minMobSpawnCount, this.maxMobSpawnCount, 0.4f);
        }
        for (int i = 0; i < mobsToSpawn; ++i) {
            this.entityTypes.getRandom(serverLevel.m_5822_()).ifPresent(entityType -> {
                Entity mob = MobSpawningUtils.spawnMob(serverLevel, this.minDistanceFromCenter, this.radius, 2, entityType.entityType(), entityType.entityNbt(), this.getSummonCenter(), true);
                if (mob != null) {
                    String name;
                    this.spawnedMobs.add(mob.m_142081_());
                    String string = name = Attributes.f_22281_.getRegistryName() != null ? Attributes.f_22281_.getRegistryName().toString() : null;
                    if (name != null) {
                        UUID modifierId = AttributeModifierTrait.getModifierId(name);
                        if (this.boss.m_21204_().m_22154_(Attributes.f_22281_, modifierId)) {
                            LivingEntity livingEntity;
                            AttributeInstance instance;
                            double modifier = this.boss.m_21204_().m_22173_(Attributes.f_22281_, modifierId);
                            if (mob instanceof LivingEntity && (instance = (livingEntity = (LivingEntity)mob).m_21051_(Attributes.f_22281_)) != null) {
                                instance.m_22120_(modifierId);
                                instance.m_22125_(new AttributeModifier(modifierId, "Trait Modifier | " + name, modifier * 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
                            }
                        }
                    }
                }
            });
        }
    }

    protected Vec3 getSummonCenter() {
        return this.boss.m_20182_();
    }

    public void m_8056_() {
        this.onLivingDeath = this::onSummonedMobDeath;
        MinecraftForge.EVENT_BUS.addListener(this.onLivingDeath);
    }

    private void onSummonedMobDeath(LivingDeathEvent event) {
        Entity entity = event.getEntity();
        if (entity.m_19880_().contains("boss_summoned")) {
            this.spawnedMobs.remove(entity.m_142081_());
        }
    }

    public void m_8041_() {
        MinecraftForge.EVENT_BUS.unregister(this.onLivingDeath);
    }

    public boolean m_8036_() {
        return true;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("MaxMobsAliveBeforeNextSpawn", this.maxMobsAliveBeforeNextSpawn);
        nbt.m_128405_("MinMobSpawnCount", this.minMobSpawnCount);
        nbt.m_128405_("MaxMobSpawnCount", this.maxMobSpawnCount);
        nbt.m_128405_("SpawnInterval", this.spawnInterval);
        nbt.m_128405_("MinDistanceFromCenter", this.minDistanceFromCenter);
        nbt.m_128405_("Radius", this.radius);
        nbt.m_128365_("EntityTypes", (Tag)this.serializeEntityTypes());
        if (!this.spawnedMobs.isEmpty()) {
            ListTag listTag = new ListTag();
            this.spawnedMobs.forEach(uuid -> listTag.add((Object)NbtUtils.m_129226_((UUID)uuid)));
            nbt.m_128365_("SpawnedMobs", (Tag)listTag);
        }
        nbt.m_128405_("StackSize", this.stackSize);
        nbt.m_128405_("BaseSpawnInterval", this.baseSpawnInterval);
        return nbt;
    }

    private ListTag serializeEntityTypes() {
        ListTag tag = new ListTag();
        this.entityTypes.forEach((entityType, weight) -> {
            CompoundTag compoundTag = new CompoundTag();
            entityType.serializeTo(compoundTag);
            compoundTag.m_128347_("Weight", weight.doubleValue());
            tag.add((Object)compoundTag);
        });
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, VaultBossBaseEntity boss) {
        this.setAttributes(nbt.m_128451_("MaxMobsAliveBeforeNextSpawn"), nbt.m_128451_("MinMobSpawnCount"), nbt.m_128451_("MaxMobSpawnCount"), nbt.m_128451_("SpawnInterval"), nbt.m_128451_("MinDistanceFromCenter"), nbt.m_128451_("Radius"), this.deserializeEntityTypes(nbt.m_128437_("EntityTypes", 10)));
        if (nbt.m_128441_("SpawnedMobs")) {
            this.spawnedMobs.clear();
            ListTag listTag = nbt.m_128437_("SpawnedMobs", 11);
            listTag.forEach(tag -> this.spawnedMobs.add(NbtUtils.m_129233_((Tag)tag)));
        }
        this.stackSize = nbt.m_128451_("StackSize");
        this.baseSpawnInterval = nbt.m_128441_("BaseSpawnInterval") ? nbt.m_128451_("BaseSpawnInterval") : this.spawnInterval;
    }

    public SummonGoal setAttributes(int maxMobsAliveBeforeNextSpawn, int minMobSpawnCount, int maxMobSpawnCount, int spawnInterval, int minDistanceFromCenter, int radius, WeightedList<MobSpawningUtils.EntitySpawnData> entityTypes) {
        this.maxMobsAliveBeforeNextSpawn = maxMobsAliveBeforeNextSpawn;
        this.minMobSpawnCount = minMobSpawnCount;
        this.maxMobSpawnCount = maxMobSpawnCount;
        this.spawnInterval = spawnInterval;
        this.baseSpawnInterval = spawnInterval;
        this.minDistanceFromCenter = minDistanceFromCenter;
        this.radius = radius;
        this.entityTypes = entityTypes;
        return this;
    }

    private WeightedList<MobSpawningUtils.EntitySpawnData> deserializeEntityTypes(ListTag tag) {
        WeightedList<MobSpawningUtils.EntitySpawnData> weightedList = new WeightedList<MobSpawningUtils.EntitySpawnData>();
        for (Tag element : tag) {
            CompoundTag compoundTag = (CompoundTag)element;
            MobSpawningUtils.EntitySpawnData.from(compoundTag).ifPresent(entitySpawnData -> weightedList.put((MobSpawningUtils.EntitySpawnData)entitySpawnData, compoundTag.m_128459_("Weight")));
        }
        return weightedList;
    }
}

