/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.goal;

import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.goal.RangedAttackGoalBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class ThrowPotionGoal
extends RangedAttackGoalBase {
    public static final String TYPE = "throw_potion";
    private final VaultBossBaseEntity boss;
    @Nullable
    private MobEffect mobEffect = null;
    private int duration;
    private int amplifier;
    private boolean lingering;

    public ThrowPotionGoal(VaultBossBaseEntity boss) {
        super(boss, 1.0, 100, 200, 10.0f, true);
        this.boss = boss;
    }

    public ThrowPotionGoal setAttributes(double speedModifier, int throwIntervalMin, int throwIntervalMax, float attackRadius, MobEffect mobEffect, int duration, int amplifier, boolean lingering, boolean attackWhenInMeleeRange) {
        this.setAttackAttributes(speedModifier, throwIntervalMin, throwIntervalMax, attackRadius, attackWhenInMeleeRange);
        this.mobEffect = mobEffect;
        this.duration = duration;
        this.amplifier = amplifier;
        this.lingering = lingering;
        return this;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected void performRangedAttack(LivingEntity target, float normalizedDistance) {
        Vec3 targetDeltaMovement = target.m_20184_();
        ThrownPotion thrownpotion = new ThrownPotion(this.boss.f_19853_, (LivingEntity)this.boss);
        double xDiff = target.m_20185_() + targetDeltaMovement.f_82479_ - this.boss.m_20185_();
        double yDiff = target.m_20188_() - thrownpotion.m_20186_();
        double zDiff = target.m_20189_() + targetDeltaMovement.f_82481_ - this.boss.m_20189_();
        double distance = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
        ItemStack potionStack = new ItemStack((ItemLike)(this.lingering ? Items.f_42739_ : Items.f_42736_));
        thrownpotion.m_37446_(PotionUtils.m_43552_((ItemStack)potionStack, List.of(new MobEffectInstance(this.mobEffect, this.duration, this.amplifier))));
        thrownpotion.m_146926_(thrownpotion.m_146909_() - -20.0f);
        thrownpotion.m_6686_(xDiff, yDiff + distance * 0.2, zDiff, (float)(0.75 * (Math.min(distance, 4.0) / 4.0)), 4.0f);
        this.boss.m_5496_(SoundEvents.f_12553_, 1.0f, 0.8f + this.boss.m_21187_().nextFloat() * 0.4f);
        this.boss.m_183503_().m_7967_((Entity)thrownpotion);
    }

    @Override
    public boolean m_8036_() {
        return super.m_8036_() && this.mobEffect != null;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        if (this.mobEffect == null) {
            return nbt;
        }
        nbt.m_128359_("MobEffect", this.mobEffect.getRegistryName().toString());
        nbt.m_128405_("Duration", this.duration);
        nbt.m_128405_("Amplifier", this.amplifier);
        nbt.m_128379_("Lingering", this.lingering);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, VaultBossBaseEntity boss) {
        super.deserializeNBT(nbt, boss);
        if (!nbt.m_128441_("MobEffect")) {
            return;
        }
        this.mobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(nbt.m_128461_("MobEffect")));
        this.duration = nbt.m_128451_("Duration");
        this.amplifier = nbt.m_128451_("Amplifier");
        this.lingering = nbt.m_128471_("Lingering");
    }
}

