/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.stage;

import iskallia.vault.entity.boss.ArtifactBossEntity;
import iskallia.vault.entity.boss.BloodOrbEntity;
import iskallia.vault.entity.boss.stage.BerserkStageAttributes;
import iskallia.vault.entity.boss.stage.MeleeStage;
import iskallia.vault.init.ModAttributes;
import iskallia.vault.init.ModEffects;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BerserkStage
extends MeleeStage<BerserkStageAttributes> {
    private static final ResourceLocation BOSS_TEXTURE = new ResourceLocation("the_vault", "textures/entity/boss/artifact_boss_idona.png");
    private static final TargetingConditions PLAYERS_TARGETING_CONDITIONS = TargetingConditions.m_148352_().m_26883_(50.0);
    public static final String NAME = "berserk";
    private static final UUID BERSERK_ATTACK_DAMAGE_MODIFIER_UUID = UUID.fromString("cecf6bd8-612b-11ee-869d-325096b39f47");
    private static final UUID CRIT_CHANCE_MODIFIER_UUID = UUID.fromString("8b0e4506-6e41-4e14-b543-58fc79c8d3a3");
    private static final UUID CRIT_MULTIPLIER_MODIFIER_UUID = UUID.fromString("175a1074-7ef8-4d8a-afc7-e8dd1848259c");
    private static final UUID BERSERK_SPEED_MODIFIER_UUID = UUID.fromString("d4b6c97e-612b-11ee-82a2-325096b39f47");
    private static final int BLEED_EFFECT_APPLICATION_COOLDOWN = 20;
    private static final int BLOOD_ORB_SPAWN_RADIUS = 34;
    private Set<UUID> bloodOrbs = new HashSet<UUID>();
    private int bloodOrbSpawnTimer = 0;
    private int bleedEffectTimer = 0;

    public BerserkStage(ArtifactBossEntity artifactBossEntity, BerserkStageAttributes meleeStageAttributes) {
        super(artifactBossEntity, meleeStageAttributes);
        this.setBloodOrbSpawnCooldown();
    }

    private void setBloodOrbSpawnCooldown() {
        int playerCount = this.boss.getPlayerCount();
        this.bloodOrbSpawnTimer = Math.max(20, (int)((double)((BerserkStageAttributes)this.meleeStageAttributes).getBloodOrbSpawnCooldown() - (double)((BerserkStageAttributes)this.meleeStageAttributes).getBloodOrbSpawnCooldown() * 0.2 * (double)playerCount));
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = super.serialize();
        tag.m_128365_("BloodOrbs", (Tag)this.serializeBloodOrbs());
        return tag;
    }

    private ListTag serializeBloodOrbs() {
        ListTag bloodOrbList = new ListTag();
        this.bloodOrbs.forEach(uuid -> bloodOrbList.add((Object)NbtUtils.m_129226_((UUID)uuid)));
        return bloodOrbList;
    }

    public static BerserkStage fromAttributes(ArtifactBossEntity artifactBossEntity, CompoundTag attributesTag) {
        return new BerserkStage(artifactBossEntity, BerserkStageAttributes.from(attributesTag));
    }

    public static BerserkStage from(ArtifactBossEntity artifactBossEntity, CompoundTag tag) {
        BerserkStage berserkStage = BerserkStage.fromAttributes(artifactBossEntity, tag.m_128469_("MeleeStageAttributes"));
        berserkStage.bloodOrbs = BerserkStage.deserializeBloodOrbs(tag.m_128437_("BloodOrbs", 11));
        return berserkStage;
    }

    private static Set<UUID> deserializeBloodOrbs(ListTag bloodOrbs) {
        HashSet<UUID> bloodOrbSet = new HashSet<UUID>();
        bloodOrbs.forEach(uuidTag -> bloodOrbSet.add(NbtUtils.m_129233_((Tag)uuidTag)));
        return bloodOrbSet;
    }

    @Override
    public Optional<ResourceLocation> getTextureLocation() {
        return Optional.of(BOSS_TEXTURE);
    }

    @Override
    public void onHurt() {
        super.onHurt();
        float healthBasedMultiplier = 1.0f - this.boss.m_21223_() / this.boss.m_21233_();
        double damageMultiplier = (double)healthBasedMultiplier * (((BerserkStageAttributes)this.meleeStageAttributes).getMaxBaseDamageMultiplier() - 1.0);
        this.updateModifier(Attributes.f_22281_, BERSERK_ATTACK_DAMAGE_MODIFIER_UUID, "BerserkAttackDamageAdjustment", damageMultiplier);
        double speedMultiplier = (double)healthBasedMultiplier * (((BerserkStageAttributes)this.meleeStageAttributes).getMaxSpeedMultiplier() - 1.0);
        this.updateModifier(Attributes.f_22279_, BERSERK_SPEED_MODIFIER_UUID, "BerserkSpeedAdjustment", speedMultiplier);
    }

    @Override
    public void tick() {
        super.tick();
        Level level = this.boss.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.bloodOrbs.removeIf(uuid -> serverLevel.m_8791_(uuid) == null);
            if (this.bloodOrbSpawnTimer > 0) {
                --this.bloodOrbSpawnTimer;
            }
            if (this.bloodOrbSpawnTimer <= 0) {
                if (this.bloodOrbs.size() < ((BerserkStageAttributes)this.meleeStageAttributes).getMaxBloodOrbs()) {
                    Vec3 spawnPosition = this.boss.getSpawnPosition();
                    double x = spawnPosition.m_7096_() + (double)this.boss.f_19853_.f_46441_.nextInt(-34, 34);
                    double y = spawnPosition.m_7098_();
                    double z = spawnPosition.m_7094_() + (double)this.boss.f_19853_.f_46441_.nextInt(-34, 34);
                    Vec3 bloodOrbPos = new Vec3(x, y, z);
                    BloodOrbEntity bloodOrbEntity = new BloodOrbEntity(this.boss.f_19853_);
                    bloodOrbEntity.m_146884_(bloodOrbPos);
                    bloodOrbEntity.m_20242_(false);
                    serverLevel.m_7967_((Entity)bloodOrbEntity);
                    this.bloodOrbs.add(bloodOrbEntity.m_142081_());
                }
                this.setBloodOrbSpawnCooldown();
            }
            if (this.bleedEffectTimer > 0) {
                --this.bleedEffectTimer;
            }
            if (this.bleedEffectTimer <= 0 && !this.bloodOrbs.isEmpty()) {
                this.boss.f_19853_.m_45955_(PLAYERS_TARGETING_CONDITIONS, (LivingEntity)this.boss, this.boss.m_142469_().m_82400_(60.0)).forEach(player -> player.m_147207_(new MobEffectInstance(ModEffects.BLEED, 60, this.bloodOrbs.size() - 1), null));
                this.bleedEffectTimer = 20;
            }
        }
    }

    private void updateModifier(Attribute attribute, UUID modifierUuid, String modifierName, double amount) {
        AttributeInstance attributeInstance = this.boss.m_21051_(attribute);
        if (attributeInstance == null) {
            return;
        }
        if (attributeInstance.m_22111_(modifierUuid) != null) {
            attributeInstance.m_22120_(modifierUuid);
        }
        attributeInstance.m_22118_(new AttributeModifier(modifierUuid, modifierName, amount, AttributeModifier.Operation.MULTIPLY_BASE));
    }

    @Override
    public void init() {
        super.init();
        this.boss.m_21051_(ModAttributes.CRIT_CHANCE).m_22118_(new AttributeModifier(CRIT_CHANCE_MODIFIER_UUID, "BerserkCritChance", 1.0, AttributeModifier.Operation.ADDITION));
        this.boss.m_21051_(ModAttributes.CRIT_MULTIPLIER).m_22118_(new AttributeModifier(CRIT_MULTIPLIER_MODIFIER_UUID, "BerserkCritMultiplier", 1.5, AttributeModifier.Operation.ADDITION));
    }

    @Override
    public void finish() {
        super.finish();
        this.removeModifier(ModAttributes.CRIT_CHANCE, CRIT_CHANCE_MODIFIER_UUID);
        this.removeModifier(ModAttributes.CRIT_MULTIPLIER, CRIT_MULTIPLIER_MODIFIER_UUID);
        this.removeModifier(Attributes.f_22281_, BERSERK_ATTACK_DAMAGE_MODIFIER_UUID);
        this.removeModifier(Attributes.f_22279_, BERSERK_SPEED_MODIFIER_UUID);
        this.bloodOrbs.forEach(bloodOrb -> {
            ServerLevel serverLevel;
            Entity entity;
            Level patt7873$temp = this.boss.f_19853_;
            if (patt7873$temp instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)patt7873$temp).m_8791_(bloodOrb)) != null) {
                entity.m_6074_();
            }
        });
    }

    private void removeModifier(Attribute attribute, UUID modifierUUID) {
        AttributeInstance ai = this.boss.m_21051_(attribute);
        if (ai != null) {
            ai.m_22120_(modifierUUID);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Tuple<Integer, Integer> getBossBarTextureVs() {
        return new Tuple((Object)186, (Object)363);
    }
}

