/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.stage;

import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.stat.VaultChestType;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.registries.ForgeRegistries;

public class CatalystStageAttributes {
    private final List<CatalystWave> catalystWaves;
    private final float projectileDamage;
    private final float chestChance;
    private final float fangsChance;
    private final float fangsDamage;
    private final float explosionDamageMultiplier;
    private final WeightedList<EffectAttributes> effects;
    private final Map<VaultChestType, ResourceLocation> chestLootTables;

    public CatalystStageAttributes(List<CatalystWave> catalystWaves, float projectileDamage, float chestChance, float fangsChance, float fangsDamage, float explosionDamageMultiplier, WeightedList<EffectAttributes> effects, Map<VaultChestType, ResourceLocation> chestLootTables) {
        this.catalystWaves = catalystWaves;
        this.projectileDamage = projectileDamage;
        this.chestChance = chestChance;
        this.fangsChance = fangsChance;
        this.fangsDamage = fangsDamage;
        this.explosionDamageMultiplier = explosionDamageMultiplier;
        this.effects = effects;
        this.chestLootTables = chestLootTables;
    }

    public float getProjectileDamage() {
        return this.projectileDamage;
    }

    public List<CatalystWave> getCatalystWaves() {
        return this.catalystWaves;
    }

    public static CatalystStageAttributes from(CompoundTag tag) {
        return new CatalystStageAttributes(CatalystStageAttributes.deserializeCatalystWaves(tag.m_128437_("CatalystWaves", 10)), tag.m_128457_("ProjectileDamage"), tag.m_128457_("ChestChance"), tag.m_128457_("FangsChance"), tag.m_128457_("FangsDamage"), tag.m_128457_("ExplosionDamageMultiplier"), CatalystStageAttributes.deserializeEffects(tag.m_128437_("Effects", 10)), CatalystStageAttributes.deserializeChestLootTables(tag.m_128469_("ChestLootTables")));
    }

    public static WeightedList<EffectAttributes> deserializeEffects(ListTag tag) {
        WeightedList<EffectAttributes> effects = new WeightedList<EffectAttributes>();
        for (Tag element : tag) {
            CompoundTag compoundTag = (CompoundTag)element;
            EffectAttributes.from(compoundTag).ifPresent(effectAttributes -> effects.add((EffectAttributes)effectAttributes, compoundTag.m_128459_("Weight")));
        }
        return effects;
    }

    public static Map<VaultChestType, ResourceLocation> deserializeChestLootTables(CompoundTag tag) {
        EnumMap<VaultChestType, ResourceLocation> chestLootTables = new EnumMap<VaultChestType, ResourceLocation>(VaultChestType.class);
        for (String key : tag.m_128431_()) {
            chestLootTables.put(VaultChestType.valueOf(key), new ResourceLocation(tag.m_128461_(key)));
        }
        return chestLootTables;
    }

    private static List<CatalystWave> deserializeCatalystWaves(ListTag tag) {
        ArrayList<CatalystWave> catalystWaves = new ArrayList<CatalystWave>();
        for (Tag element : tag) {
            CompoundTag compoundTag = (CompoundTag)element;
            catalystWaves.add(CatalystWave.from(compoundTag));
        }
        return catalystWaves;
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("CatalystWaves", (Tag)this.serializeCatalystWaves(this.catalystWaves));
        tag.m_128350_("ProjectileDamage", this.projectileDamage);
        tag.m_128350_("ChestChance", this.chestChance);
        tag.m_128350_("FangsChance", this.fangsChance);
        tag.m_128350_("FangsDamage", this.fangsDamage);
        tag.m_128350_("ExplosionDamageMultiplier", this.explosionDamageMultiplier);
        tag.m_128365_("Effects", (Tag)CatalystStageAttributes.serializeEffects(this.effects));
        tag.m_128365_("ChestLootTables", (Tag)CatalystStageAttributes.serializeChestLootTables(this.chestLootTables));
        return tag;
    }

    public static CompoundTag serializeChestLootTables(Map<VaultChestType, ResourceLocation> chestLootTables) {
        CompoundTag tag = new CompoundTag();
        chestLootTables.forEach((vaultChestType, resourceLocation) -> tag.m_128359_(vaultChestType.name(), resourceLocation.toString()));
        return tag;
    }

    public static ListTag serializeEffects(WeightedList<EffectAttributes> effects) {
        ListTag tag = new ListTag();
        effects.forEach((effectAttributes, weight) -> {
            CompoundTag compoundTag = effectAttributes.serialize();
            compoundTag.m_128347_("Weight", weight.doubleValue());
            tag.add((Object)compoundTag);
        });
        return tag;
    }

    private ListTag serializeCatalystWaves(List<CatalystWave> catalystWaves) {
        ListTag tag = new ListTag();
        catalystWaves.forEach(catalystWave -> tag.add((Object)catalystWave.serialize()));
        return tag;
    }

    public float getChestChance() {
        return this.chestChance;
    }

    public float getFangsChance() {
        return this.fangsChance;
    }

    public WeightedList<EffectAttributes> getEffects() {
        return this.effects;
    }

    public Map<VaultChestType, ResourceLocation> getChestLootTables() {
        return this.chestLootTables;
    }

    public float getFangsDamage() {
        return this.fangsDamage;
    }

    public float getExplosionDamageMultiplier() {
        return this.explosionDamageMultiplier;
    }

    public record EffectAttributes(MobEffect effect, int duration, int amplifier) {
        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Effect", this.effect.getRegistryName().toString());
            tag.m_128405_("Duration", this.duration);
            tag.m_128405_("Amplifier", this.amplifier);
            return tag;
        }

        public static Optional<EffectAttributes> from(CompoundTag tag) {
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(tag.m_128461_("Effect")));
            if (effect == null) {
                return Optional.empty();
            }
            return Optional.of(new EffectAttributes(effect, tag.m_128451_("Duration"), tag.m_128451_("Amplifier")));
        }
    }

    public record CatalystWave(int minCatalysts, int maxCatalysts) {
        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("MinCatalysts", this.minCatalysts);
            tag.m_128405_("MaxCatalysts", this.maxCatalysts);
            return tag;
        }

        public static CatalystWave from(CompoundTag tag) {
            return new CatalystWave(tag.m_128451_("MinCatalysts"), tag.m_128451_("MaxCatalysts"));
        }
    }
}

