/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.stage;

import com.google.common.util.concurrent.AtomicDouble;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.entity.boss.ArtifactBossEntity;
import iskallia.vault.entity.boss.MagicProjectileEntity;
import iskallia.vault.entity.boss.stage.IBossStage;
import iskallia.vault.entity.boss.stage.SparkStageAttributes;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.mixin.AccessorChunkMap;
import iskallia.vault.network.message.AbsorbingParticleMessage;
import iskallia.vault.network.message.ClientboundArtifactBossWendarrExplodeMessage;
import iskallia.vault.network.message.ClientboundSafePointPlaceParticleMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableObject;
import software.bernie.geckolib3.core.builder.AnimationBuilder;

public class SparkStage
implements IBossStage {
    private static final TargetingConditions PLAYERS_TARGETING_CONDITIONS = TargetingConditions.m_148352_().m_26883_(50.0);
    private static final ResourceLocation BOSS_TEXTURE = new ResourceLocation("the_vault", "textures/entity/boss/artifact_boss_wendarr.png");
    private static final int PROJECTILE_CHARGE_NEEDED = 30;
    private static final int SPARK_REMOVAL_DELAY = 20;
    private static final int DAMAGE_DEALT_DELAY = 60;
    private static final Set<Goal.Flag> FLAGS = Set.of(Goal.Flag.MOVE, Goal.Flag.TARGET);
    public static final String NAME = "spark";
    public static final int SAFE_POINT_RADIUS = 4;
    private final ArtifactBossEntity boss;
    private final SparkStageAttributes attributes;
    private int sparkCount;
    private final Set<BlockPos> sparkPositions = new HashSet<BlockPos>();
    private long lastSparkSpawnTime = 0L;
    private int projectileCharge = 0;
    private long currentSparksExpiration = Long.MAX_VALUE;
    private int sparkRemovalTimer = -1;
    private int stunTimer = 2;
    private int damageDealTimer = 0;
    private final List<BlockPos> safePointCenters = new ArrayList<BlockPos>();
    private final Map<BlockState, Set<BlockPos>> safePointOriginalBlocks = new HashMap<BlockState, Set<BlockPos>>();

    public SparkStage(ArtifactBossEntity boss, SparkStageAttributes attributes) {
        this.boss = boss;
        this.attributes = attributes;
        this.sparkCount = boss.getPlayerAdjustedRandomCount(attributes.minSparkCount, attributes.maxSparkCount, 1.0f);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void tick() {
        Level level = this.boss.m_183503_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.currentSparksExpiration <= serverLevel.m_46467_()) {
            this.projectileCharge = 0;
            this.currentSparksExpiration = Long.MAX_VALUE;
            this.damageDealTimer = 60;
            this.placeSafePoints(serverLevel);
        } else if (this.damageDealTimer > 0) {
            if (this.damageDealTimer == 60) {
                this.sparkPositions.forEach(sparkPosition -> {
                    if (serverLevel.m_8055_(sparkPosition).m_60734_() == ModBlocks.SPARK) {
                        this.boss.f_19853_.m_5594_(null, sparkPosition, ModSounds.SPARK_EXPUNGE, SoundSource.BLOCKS, 1.0f, 1.0f);
                        ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new AbsorbingParticleMessage(new Vec3((double)sparkPosition.m_123341_(), (double)sparkPosition.m_123342_(), (double)sparkPosition.m_123343_()), (Entity)this.boss, 16769280));
                    }
                });
                this.boss.f_19853_.m_5594_(null, this.boss.m_142538_(), SoundEvents.f_11736_, SoundSource.HOSTILE, 1.0f, 0.75f);
            }
            --this.damageDealTimer;
            if (this.damageDealTimer == 0) {
                this.dealDamageToPlayers(serverLevel);
                this.removeSafePoints(serverLevel);
            }
        } else if (this.stunTimer > 0) {
            --this.stunTimer;
            this.doStunnedLogic(serverLevel);
        } else {
            this.placeSparksAndShootProjectiles(serverLevel);
        }
    }

    private void dealDamageToPlayers(ServerLevel serverLevel) {
        this.sparkRemovalTimer = 20;
        AtomicDouble playerDamage = new AtomicDouble(0.0);
        this.stunTimer = 0;
        this.sparkPositions.forEach(sparkPosition -> {
            if (serverLevel.m_8055_(sparkPosition).m_60734_() == ModBlocks.CONVERTED_SPARK) {
                this.stunTimer += this.attributes.stunTimePerSpark;
            } else {
                playerDamage.addAndGet(this.attributes.damagePerSpark);
            }
        });
        if (this.stunTimer > 0) {
            this.boss.setStunned(true);
        } else {
            this.endStun(serverLevel);
        }
        serverLevel.m_45955_(PLAYERS_TARGETING_CONDITIONS, (LivingEntity)this.boss, this.boss.m_142469_().m_82400_(60.0)).forEach(player -> {
            if (this.playerIsInSafePoint((Player)player)) {
                player.m_6469_(DamageSource.f_19306_, (float)this.attributes.damagePerSpark);
            } else {
                player.m_6469_(DamageSource.f_19306_, playerDamage.floatValue());
            }
        });
        this.boss.f_19853_.m_5594_(null, this.boss.m_142538_(), SoundEvents.f_12090_, SoundSource.HOSTILE, 1.0f, 2.0f);
        ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundArtifactBossWendarrExplodeMessage(this.boss.m_20182_().f_82479_, this.boss.m_20182_().f_82480_, this.boss.m_20182_().f_82481_, 60.0, 0.0, 0.0));
    }

    private boolean playerIsInSafePoint(Player player) {
        for (BlockPos safePointCenter : this.safePointCenters) {
            if (!(safePointCenter.m_203198_(player.m_20185_(), player.m_20186_(), player.m_20189_()) <= 25.0)) continue;
            return true;
        }
        return false;
    }

    private void removeSafePoints(ServerLevel serverLevel) {
        if (this.safePointCenters.isEmpty()) {
            return;
        }
        this.safePointOriginalBlocks.forEach((blockState, blockPositions) -> blockPositions.forEach(blockPosition -> {
            this.boss.m_183503_().m_7731_(blockPosition, blockState, 3);
            SparkStage.sendBlockUpdatesToClient(serverLevel, blockPosition);
        }));
        this.safePointCenters.clear();
        this.safePointOriginalBlocks.clear();
    }

    private void endStun(ServerLevel serverLevel) {
        if (!this.boss.isCloseToDeath()) {
            this.sparkCount = this.boss.getPlayerAdjustedRandomCount(this.attributes.minSparkCount, this.attributes.maxSparkCount, 1.0f);
        }
        this.removeSparks(serverLevel);
    }

    private void placeSparksAndShootProjectiles(ServerLevel serverLevel) {
        ++this.projectileCharge;
        if (this.projectileCharge >= 30) {
            this.shootAtPlayers();
            this.projectileCharge = 0;
        }
        while (this.needsToSpawnSpark() && this.lastSparkSpawnTime + (long)this.attributes.sparkSpawnInterval <= this.boss.m_183503_().m_46467_()) {
            this.placeSpark(serverLevel);
        }
    }

    private void placeSafePoints(ServerLevel serverLevel) {
        if (!this.safePointCenters.isEmpty()) {
            return;
        }
        this.determineSafePointCenters();
        this.placeSafePointBlocks(serverLevel);
        this.spawnSafePointParticles(serverLevel);
    }

    private void spawnSafePointParticles(ServerLevel serverLevel) {
        this.safePointCenters.forEach(safePointCenter -> ModNetwork.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.boss.m_183503_().m_46745_(safePointCenter)), (Object)new ClientboundSafePointPlaceParticleMessage((BlockPos)safePointCenter)));
    }

    private void placeSafePointBlocks(ServerLevel serverLevel) {
        this.safePointCenters.forEach(safePointCenter -> {
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
            for (int x = -4; x <= 4; ++x) {
                for (int z = -4; z <= 4; ++z) {
                    blockPos.m_122178_(safePointCenter.m_123341_() + x, safePointCenter.m_123342_(), safePointCenter.m_123343_() + z);
                    long roundedDistance = Math.round(Math.sqrt(safePointCenter.m_123331_((Vec3i)blockPos)));
                    if (roundedDistance > 4L) continue;
                    if (roundedDistance == 4L) {
                        this.safePointOriginalBlocks.computeIfAbsent(this.boss.m_183503_().m_8055_((BlockPos)blockPos), blockState -> new HashSet()).add(blockPos.m_7949_());
                        this.boss.m_183503_().m_7731_((BlockPos)blockPos, ModBlocks.WENDARR_JEWEL_BLOCK.m_49966_(), 3);
                        SparkStage.sendBlockUpdatesToClient(serverLevel, (BlockPos)blockPos);
                        continue;
                    }
                    this.safePointOriginalBlocks.computeIfAbsent(this.boss.m_183503_().m_8055_((BlockPos)blockPos), blockState -> new HashSet()).add(blockPos.m_7949_());
                    this.boss.m_183503_().m_7731_((BlockPos)blockPos, ModBlocks.WENDARR_LIGHT_SMOOTH_BLOCK.m_49966_(), 3);
                    SparkStage.sendBlockUpdatesToClient(serverLevel, (BlockPos)blockPos);
                }
            }
        });
    }

    private void determineSafePointCenters() {
        float minDifference = 1.0471976f;
        int safePointsCount = 3;
        float firstAngle = this.boss.m_183503_().f_46441_.nextFloat() * 2.0f * (float)Math.PI;
        float slice = (float)((Math.PI * 2 - (double)minDifference) / (double)safePointsCount);
        float okPartOfSlice = slice - minDifference;
        Vec3 centerPos = this.boss.getSpawnPosition();
        for (int i = 0; i < safePointsCount; ++i) {
            float angle = i == 0 ? firstAngle : firstAngle + (float)(i - 1) * slice + minDifference + this.boss.m_183503_().f_46441_.nextFloat() * okPartOfSlice;
            float dist = this.attributes.radius - 10 + this.boss.m_183503_().f_46441_.nextInt(10);
            double x = centerPos.f_82479_ + (double)dist * Math.cos(angle);
            double z = centerPos.f_82481_ + (double)dist * Math.sin(angle);
            this.safePointCenters.add(new BlockPos(x, centerPos.f_82480_ - 1.0, z));
        }
    }

    private void doStunnedLogic(ServerLevel serverLevel) {
        if (this.sparkRemovalTimer > 0) {
            --this.sparkRemovalTimer;
        } else if (this.sparkRemovalTimer == 0) {
            this.sparkRemovalTimer = -1;
            this.removeSparks(serverLevel);
        }
        if (this.stunTimer <= 0) {
            this.boss.setStunned(false);
            this.endStun(serverLevel);
        }
    }

    private void removeSparks(ServerLevel serverLevel) {
        for (BlockPos sparkPosition : this.sparkPositions) {
            serverLevel.m_46961_(sparkPosition, false);
        }
        this.sparkPositions.clear();
    }

    private void shootAtPlayers() {
        this.boss.m_183503_().m_45955_(PLAYERS_TARGETING_CONDITIONS, (LivingEntity)this.boss, this.boss.m_142469_().m_82400_(60.0)).forEach(player -> {
            double x = player.m_20185_() - this.boss.m_20185_();
            double y = player.m_20227_(0.5) - this.boss.m_20227_(0.5);
            double z = player.m_20189_() - this.boss.m_20189_();
            this.boss.f_19853_.m_5594_(null, this.boss.m_142538_(), ModSounds.ARTIFACT_BOSS_MAGIC_ATTACK, SoundSource.HOSTILE, 1.0f, 1.0f);
            MagicProjectileEntity magicProjectile = new MagicProjectileEntity(this.boss.m_183503_(), this.boss, x, y, z, (Player)player, 10.0f);
            magicProjectile.setColor(VaultGod.WENDARR.getColor());
            Vec3 vec3 = new Vec3(x, y, z);
            double d0 = vec3.m_165924_();
            magicProjectile.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
            magicProjectile.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
            magicProjectile.m_6034_(magicProjectile.m_20185_(), this.boss.m_20227_(0.5) + 0.5, magicProjectile.m_20189_());
            this.boss.m_183503_().m_7967_((Entity)magicProjectile);
        });
    }

    public boolean needsToSpawnSpark() {
        return this.sparkPositions.size() < this.sparkCount;
    }

    @Override
    public boolean isFinished() {
        return this.boss.isCloseToDeath();
    }

    @Override
    public boolean makesBossInvulnerable() {
        return !this.boss.isStunned();
    }

    @Override
    public Set<Goal.Flag> getControlFlags() {
        return FLAGS;
    }

    @Override
    public void init() {
        this.boss.setScaledHealth(this.attributes.health);
    }

    @Override
    public void start() {
    }

    private void placeSpark(ServerLevel serverLevel) {
        int maxRetries = 10;
        for (int i = 0; i < maxRetries; ++i) {
            int z;
            int y;
            BlockPos bossPos = this.boss.m_20097_();
            int x = bossPos.m_123341_() + serverLevel.f_46441_.nextInt(this.attributes.radius) - this.attributes.radius / 2;
            BlockPos placePos = new BlockPos(x, y = bossPos.m_123342_() + 2, z = bossPos.m_123343_() + serverLevel.f_46441_.nextInt(this.attributes.radius) - this.attributes.radius / 2);
            if (!serverLevel.m_8055_(placePos).m_60795_()) continue;
            serverLevel.m_46597_(placePos, ModBlocks.SPARK.m_49966_());
            serverLevel.m_141902_(placePos, ModBlocks.SPARK_TILE_ENTITY).ifPresent(spark -> spark.setLifetime(this.attributes.sparkLifespan));
            SparkStage.sendBlockUpdatesToClient(serverLevel, placePos);
            this.lastSparkSpawnTime = serverLevel.m_46467_();
            this.currentSparksExpiration = serverLevel.m_46467_() + (long)this.attributes.sparkLifespan;
            this.sparkPositions.add(placePos);
            return;
        }
    }

    private static void sendBlockUpdatesToClient(ServerLevel serverLevel, BlockPos placePos) {
        ChunkPos chunkPos = new ChunkPos(placePos);
        serverLevel.m_142572_().m_6937_((Runnable)new TickTask(serverLevel.m_142572_().m_129921_() + 1, () -> {
            serverLevel.m_7726_().f_8325_.m_183262_(chunkPos, false).forEach(player -> {
                serverLevel.m_6522_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62326_, true);
                ((AccessorChunkMap)serverLevel.m_7726_().f_8325_).callUpdateChunkTracking((ServerPlayer)player, chunkPos, (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), false, true);
            });
            serverLevel.m_7726_().m_8450_(placePos);
        }));
    }

    @Override
    public void stop() {
    }

    @Override
    public void finish() {
        Level level = this.boss.m_183503_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.removeSparks(serverLevel);
        }
        this.boss.setStunned(false);
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = IBossStage.super.serialize();
        tag.m_128365_("Attributes", (Tag)this.attributes.serialize());
        tag.m_128405_("SparkCount", this.sparkCount);
        ListTag sparkPositionsTag = new ListTag();
        for (BlockPos blockPos : this.sparkPositions) {
            sparkPositionsTag.add((Object)LongTag.m_128882_((long)blockPos.m_121878_()));
        }
        tag.m_128365_("SparkPositions", (Tag)sparkPositionsTag);
        tag.m_128356_("CurrentSparksExpiration", this.currentSparksExpiration);
        tag.m_128405_("SparkRemovalTimer", this.sparkRemovalTimer);
        tag.m_128405_("DamageDealTimer", this.damageDealTimer);
        tag.m_128405_("StunTimer", this.stunTimer);
        ListTag safePointCentersTag = new ListTag();
        for (BlockPos safePointCenter : this.safePointCenters) {
            safePointCentersTag.add((Object)LongTag.m_128882_((long)safePointCenter.m_121878_()));
        }
        tag.m_128365_("SafePointCenters", (Tag)safePointCentersTag);
        ListTag listTag = new ListTag();
        for (Map.Entry<BlockState, Set<BlockPos>> entry : this.safePointOriginalBlocks.entrySet()) {
            CompoundTag safePointOriginalBlockTag = new CompoundTag();
            safePointOriginalBlockTag.m_128359_("BlockState", entry.getKey().m_60734_().getRegistryName().toString());
            ListTag positions = new ListTag();
            for (BlockPos safePointOriginalBlockPosition : entry.getValue()) {
                positions.add((Object)LongTag.m_128882_((long)safePointOriginalBlockPosition.m_121878_()));
            }
            safePointOriginalBlockTag.m_128365_("BlockPositions", (Tag)positions);
            listTag.add((Object)safePointOriginalBlockTag);
        }
        tag.m_128365_("SafePointOriginalBlocks", (Tag)listTag);
        return tag;
    }

    @Override
    public Optional<AnimationBuilder> getAnimation() {
        return Optional.of(ArtifactBossEntity.SUMMON_CONTINUOUS_ANIM);
    }

    @Override
    public Optional<ResourceLocation> getTextureLocation() {
        return Optional.of(BOSS_TEXTURE);
    }

    @Override
    public Tuple<Integer, Integer> getBossBarTextureVs() {
        return new Tuple((Object)62, (Object)330);
    }

    @Override
    public float getProgress() {
        return this.boss.m_21223_() / (float)this.attributes.health;
    }

    public static SparkStage fromAttributes(ArtifactBossEntity artifactBossEntity, CompoundTag attributesTag) {
        return new SparkStage(artifactBossEntity, SparkStageAttributes.from(attributesTag));
    }

    public static SparkStage from(ArtifactBossEntity artifactBossEntity, CompoundTag tag) {
        SparkStage stage = SparkStage.fromAttributes(artifactBossEntity, tag.m_128469_("Attributes"));
        stage.sparkCount = tag.m_128451_("SparkCount");
        for (Tag sparkPositionTag : tag.m_128437_("SparkPositions", 4)) {
            stage.sparkPositions.add(BlockPos.m_122022_((long)((LongTag)sparkPositionTag).m_7046_()));
        }
        stage.currentSparksExpiration = tag.m_128454_("CurrentSparksExpiration");
        stage.sparkRemovalTimer = tag.m_128451_("SparkRemovalTimer");
        stage.damageDealTimer = tag.m_128451_("DamageDealTimer");
        stage.stunTimer = tag.m_128451_("StunTimer");
        for (Tag safePointCenterTag : tag.m_128437_("SafePointCenters", 4)) {
            stage.safePointCenters.add(BlockPos.m_122022_((long)((LongTag)safePointCenterTag).m_7046_()));
        }
        for (Tag safePointOriginalBlockTag : tag.m_128437_("SafePointOriginalBlocks", 10)) {
            CompoundTag safePointOriginalBlockCompoundTag = (CompoundTag)safePointOriginalBlockTag;
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(safePointOriginalBlockCompoundTag.m_128461_("BlockState")));
            if (block == null) continue;
            BlockState blockState = block.m_49966_();
            HashSet<BlockPos> blockPositions = new HashSet<BlockPos>();
            for (Tag blockPositionTag : safePointOriginalBlockCompoundTag.m_128437_("BlockPositions", 4)) {
                blockPositions.add(BlockPos.m_122022_((long)((LongTag)blockPositionTag).m_7046_()));
            }
            stage.safePointOriginalBlocks.put(blockState, blockPositions);
        }
        return stage;
    }
}

