/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.stage;

import iskallia.vault.VaultMod;
import iskallia.vault.entity.boss.ArtifactBossEntity;
import iskallia.vault.entity.boss.MobSpawningUtils;
import iskallia.vault.entity.boss.stage.IBossStage;
import iskallia.vault.entity.boss.stage.SummoningStageAttributes;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import software.bernie.geckolib3.core.builder.AnimationBuilder;

public class SummoningStage
implements IBossStage {
    private static final ResourceLocation BOSS_TEXTURE = new ResourceLocation("the_vault", "textures/entity/boss/artifact_boss_velara.png");
    public static final String NAME = "summoning";
    private static final Set<Goal.Flag> FLAGS = Set.of(Goal.Flag.MOVE, Goal.Flag.TARGET);
    private final ArtifactBossEntity boss;
    private final SummoningStageAttributes summoningStageAttributes;
    private long lastSpawnCheckTime = 0L;
    private int totalMobGroupsToSummon;
    private int mobGroupsSummoned;
    private int totalMobsSpawned = 0;
    private final Set<UUID> spawnedMobs = new HashSet<UUID>();
    private long stageStartTime = Long.MAX_VALUE;
    private long lastMobDeathCheckTime = 0L;
    private Consumer<LivingDeathEvent> onLivingDeath;
    boolean spawningFinished = false;

    public SummoningStage(ArtifactBossEntity boss, SummoningStageAttributes summoningStageAttributes) {
        this.boss = boss;
        this.summoningStageAttributes = summoningStageAttributes;
        this.totalMobGroupsToSummon = boss.m_183503_().m_5822_().nextInt(summoningStageAttributes.minGroupCount, summoningStageAttributes.maxGroupCount + 1);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void tick() {
        int mobsToSpawn;
        ServerLevel serverLevel;
        Level level = this.boss.m_183503_();
        if (level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            if (this.lastMobDeathCheckTime + 20L < this.boss.m_183503_().m_46467_()) {
                this.lastMobDeathCheckTime = this.boss.m_183503_().m_46467_();
                this.spawnedMobs.removeIf(uuid -> serverLevel.m_8791_(uuid) == null);
            }
        }
        if (this.mobGroupsSummoned >= this.totalMobGroupsToSummon) {
            this.spawningFinished = true;
            return;
        }
        level = this.boss.m_183503_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        serverLevel = (ServerLevel)level;
        if (this.lastSpawnCheckTime + 20L > this.boss.m_183503_().m_46467_()) {
            return;
        }
        this.lastSpawnCheckTime = this.boss.m_183503_().m_46467_();
        if (this.spawnedMobs.size() > this.summoningStageAttributes.maxMobsAliveBeforeNextSpawn * this.boss.getPlayerCount()) {
            return;
        }
        if (this.summoningStageAttributes.minMobCount > this.summoningStageAttributes.maxMobCount) {
            mobsToSpawn = this.boss.getPlayerAdjustedRandomCount(this.summoningStageAttributes.minMobCount, this.summoningStageAttributes.minMobCount, 0.4f);
            VaultMod.LOGGER.error("minMobCount is greater than maxMobCount in summoning stage attributes, defaulting to minMobCount");
        } else {
            mobsToSpawn = this.boss.getPlayerAdjustedRandomCount(this.summoningStageAttributes.minMobCount, this.summoningStageAttributes.maxMobCount, 0.4f);
        }
        for (int i = 0; i < mobsToSpawn; ++i) {
            this.summoningStageAttributes.entityTypes.getRandom(serverLevel.m_5822_()).ifPresent(entityType -> this.spawnEntity(this.boss, serverLevel, this.summoningStageAttributes.radius, entityType.entityType(), entityType.entityNbt()));
            this.lastSpawnCheckTime = serverLevel.m_46467_();
        }
        ++this.mobGroupsSummoned;
    }

    private void spawnEntity(ArtifactBossEntity artifactBossEntity, ServerLevel serverLevel, double radius, EntityType<?> entityType, CompoundTag entityNbt) {
        Vec3 spawnCenter = artifactBossEntity.getSpawnPosition();
        Entity entity = MobSpawningUtils.spawnMob(serverLevel, radius, entityType, entityNbt, spawnCenter);
        if (entity != null) {
            this.spawnedMobs.add(entity.m_142081_());
            ++this.totalMobsSpawned;
        }
    }

    @Override
    public boolean isFinished() {
        return this.spawningFinished && this.spawnedMobs.isEmpty();
    }

    @Override
    public boolean makesBossInvulnerable() {
        return true;
    }

    @Override
    public Set<Goal.Flag> getControlFlags() {
        return FLAGS;
    }

    @Override
    public void init() {
    }

    @Override
    public void start() {
        this.onLivingDeath = this::onSummonedMobDeath;
        MinecraftForge.EVENT_BUS.addListener(this.onLivingDeath);
        this.stageStartTime = this.boss.m_183503_().m_46467_();
    }

    private void onSummonedMobDeath(LivingDeathEvent event) {
        Entity entity = event.getEntity();
        if (entity.m_19880_().contains("boss_summoned")) {
            this.spawnedMobs.remove(entity.m_142081_());
        }
    }

    @Override
    public void stop() {
        MinecraftForge.EVENT_BUS.unregister(this.onLivingDeath);
    }

    @Override
    public void finish() {
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = IBossStage.super.serialize();
        tag.m_128365_("SummoningStageAttributes", (Tag)this.summoningStageAttributes.serialize());
        tag.m_128356_("StageStartTime", this.stageStartTime);
        tag.m_128405_("TotalMobGroupsToSummon", this.totalMobGroupsToSummon);
        tag.m_128405_("MobGroupsSummoned", this.mobGroupsSummoned);
        tag.m_128405_("TotalMobsSpawned", this.totalMobsSpawned);
        tag.m_128356_("LastSpawnTime", this.lastSpawnCheckTime);
        tag.m_128379_("SpawningFinished", this.spawningFinished);
        tag.m_128365_("SpawnedMobs", (Tag)this.serializeSpawnedMobs());
        return tag;
    }

    @Override
    public Optional<AnimationBuilder> getAnimation() {
        return Optional.of(ArtifactBossEntity.SUMMON_CONTINUOUS_ANIM);
    }

    @Override
    public Optional<ResourceLocation> getTextureLocation() {
        return Optional.of(BOSS_TEXTURE);
    }

    @Override
    public Tuple<Integer, Integer> getBossBarTextureVs() {
        return new Tuple((Object)248, (Object)352);
    }

    @Override
    public float getProgress() {
        float partial = (float)this.mobGroupsSummoned / (float)this.totalMobGroupsToSummon;
        return 1.0f - partial + partial * (float)this.spawnedMobs.size() / (float)this.totalMobsSpawned;
    }

    public static SummoningStage fromAttributes(ArtifactBossEntity artifactBossEntity, CompoundTag attributesTag) {
        return new SummoningStage(artifactBossEntity, SummoningStageAttributes.from(attributesTag));
    }

    public static SummoningStage from(ArtifactBossEntity artifactBossEntity, CompoundTag tag) {
        SummoningStage summoningStage = SummoningStage.fromAttributes(artifactBossEntity, tag.m_128469_("SummoningStageAttributes"));
        summoningStage.stageStartTime = tag.m_128454_("StageStartTime");
        summoningStage.totalMobGroupsToSummon = tag.m_128451_("TotalMobGroupsToSummon");
        summoningStage.mobGroupsSummoned = tag.m_128451_("MobGroupsSummoned");
        summoningStage.totalMobsSpawned = tag.m_128451_("TotalMobsSpawned");
        summoningStage.lastSpawnCheckTime = tag.m_128454_("LastSpawnTime");
        summoningStage.spawningFinished = tag.m_128471_("SpawningFinished");
        summoningStage.spawnedMobs.addAll(SummoningStage.deserializeSpawnedMobs(tag.m_128437_("SpawnedMobs", 11)));
        return summoningStage;
    }

    private ListTag serializeSpawnedMobs() {
        ListTag listTag = new ListTag();
        this.spawnedMobs.forEach(uuid -> listTag.add((Object)NbtUtils.m_129226_((UUID)uuid)));
        return listTag;
    }

    private static Set<UUID> deserializeSpawnedMobs(ListTag listTag) {
        HashSet<UUID> mobUuids = new HashSet<UUID>();
        listTag.forEach(tag -> mobUuids.add(NbtUtils.m_129233_((Tag)tag)));
        return mobUuids;
    }
}

