/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.stage;

import iskallia.vault.core.util.WeightedList;
import iskallia.vault.entity.boss.MobSpawningUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class SummoningStageAttributes {
    WeightedList<MobSpawningUtils.EntitySpawnData> entityTypes;
    int maxMobsAliveBeforeNextSpawn;
    int radius;
    int minMobCount;
    int maxMobCount;
    int minGroupCount;
    int maxGroupCount;

    public SummoningStageAttributes(WeightedList<MobSpawningUtils.EntitySpawnData> entityTypes, int maxMobsAliveBeforeNextSpawn, int radius, int minMobCount, int maxMobCount, int minGroupCount, int maxGroupCount) {
        this.entityTypes = entityTypes;
        this.maxMobsAliveBeforeNextSpawn = maxMobsAliveBeforeNextSpawn;
        this.radius = radius;
        this.minMobCount = minMobCount;
        this.maxMobCount = maxMobCount;
        this.minGroupCount = minGroupCount;
        this.maxGroupCount = maxGroupCount;
    }

    public static SummoningStageAttributes from(CompoundTag tag) {
        return new SummoningStageAttributes(SummoningStageAttributes.deserializeEntityTypes(tag.m_128437_("EntityTypes", 10)), tag.m_128451_("MaxMobsAliveBeforeNextSpawn"), tag.m_128451_("Radius"), tag.m_128451_("MinMobCount"), tag.m_128451_("MaxMobCount"), tag.m_128451_("MinGroupCount"), tag.m_128451_("MaxGroupCount"));
    }

    private static WeightedList<MobSpawningUtils.EntitySpawnData> deserializeEntityTypes(ListTag tag) {
        WeightedList<MobSpawningUtils.EntitySpawnData> weightedList = new WeightedList<MobSpawningUtils.EntitySpawnData>();
        for (Tag element : tag) {
            CompoundTag compoundTag = (CompoundTag)element;
            MobSpawningUtils.EntitySpawnData.from(compoundTag).ifPresent(entitySpawnData -> weightedList.put((MobSpawningUtils.EntitySpawnData)entitySpawnData, compoundTag.m_128459_("Weight")));
        }
        return weightedList;
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("EntityTypes", (Tag)this.serializeEntityTypes());
        tag.m_128405_("MaxMobsAliveBeforeNextSpawn", this.maxMobsAliveBeforeNextSpawn);
        tag.m_128405_("Radius", this.radius);
        tag.m_128405_("MinMobCount", this.minMobCount);
        tag.m_128405_("MaxMobCount", this.maxMobCount);
        tag.m_128405_("MinGroupCount", this.minGroupCount);
        tag.m_128405_("MaxGroupCount", this.maxGroupCount);
        return tag;
    }

    private ListTag serializeEntityTypes() {
        ListTag tag = new ListTag();
        this.entityTypes.forEach((entityType, weight) -> {
            CompoundTag compoundTag = new CompoundTag();
            entityType.serializeTo(compoundTag);
            compoundTag.m_128347_("Weight", weight.doubleValue());
            tag.add((Object)compoundTag);
        });
        return tag;
    }
}

