/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.trait;

import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.VaultBossEntity;
import iskallia.vault.entity.boss.trait.IOnHitEffect;
import iskallia.vault.entity.boss.trait.ITrait;
import iskallia.vault.entity.boss.trait.ModifierType;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;

public class ApplyPotionOnHitEffect
implements IOnHitEffect,
ITrait {
    public static final String TYPE = "apply_potion_on_hit";
    @Nullable
    private MobEffect mobEffect = null;
    private int duration;
    private int amplifier;
    private float chance;

    public ApplyPotionOnHitEffect setAttributes(MobEffect mobEffect, int duration, int amplifier, float chance) {
        this.mobEffect = mobEffect;
        this.duration = duration;
        this.amplifier = amplifier;
        this.chance = chance;
        return this;
    }

    @Override
    public void onHit(VaultBossEntity boss, Player playerHit, float damage) {
        if (this.mobEffect == null || playerHit.f_19853_.f_46441_.nextFloat() > this.chance) {
            return;
        }
        playerHit.m_7292_(new MobEffectInstance(this.mobEffect, this.duration, this.amplifier));
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void apply(VaultBossEntity boss) {
        boss.addOnHitEffect(this);
    }

    @Override
    public void addStack(ITrait trait, ModifierType type, VaultBossEntity boss) {
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("MobEffect", this.mobEffect.getRegistryName().toString());
        nbt.m_128405_("Duration", this.duration);
        nbt.m_128405_("Amplifier", this.amplifier);
        nbt.m_128350_("Chance", this.chance);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, VaultBossBaseEntity boss) {
        this.mobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(nbt.m_128461_("MobEffect")));
        this.duration = nbt.m_128451_("Duration");
        this.amplifier = nbt.m_128451_("Amplifier");
        this.chance = nbt.m_128457_("Chance");
    }
}

