/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.trait;

import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.VaultBossEntity;
import iskallia.vault.entity.boss.trait.ITrait;
import iskallia.vault.entity.boss.trait.ModifierType;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class AttributeModifierTrait
implements ITrait {
    public static final String TYPE = "attribute_modifier";
    private String name;
    private double value;
    private String operator;
    private boolean applied = false;
    private double baseValue;
    private double bonusValue = 0.0;

    public AttributeModifierTrait setAttributes(String name, double value, String operator) {
        this.name = name;
        this.value = value;
        this.operator = operator;
        this.baseValue = value;
        this.bonusValue = 0.0;
        this.applied = false;
        return this;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, VaultBossBaseEntity boss) {
        this.name = nbt.m_128461_("Name");
        this.value = nbt.m_128459_("Value");
        this.operator = nbt.m_128461_("Operator");
        this.applied = nbt.m_128471_("Applied");
        double d = this.baseValue = nbt.m_128441_("BaseValue") ? nbt.m_128459_("BaseValue") : this.value;
        if (nbt.m_128441_("BonusValue")) {
            this.bonusValue = nbt.m_128459_("BonusValue");
        } else {
            int stacks = Math.max(1, nbt.m_128451_("ModifierStacks"));
            this.bonusValue = Math.max(0.0, this.baseValue * (double)(stacks - 1));
        }
        this.recalculateValue();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void apply(VaultBossEntity boss) {
        this.refreshAttribute(boss);
        this.applied = true;
    }

    public void applyModifier(AttributeInstance instance, String operator, double value) {
        if (operator.equalsIgnoreCase("set")) {
            instance.m_22100_(value);
            return;
        }
        UUID modifierId = this.getModifierId();
        instance.m_22120_(modifierId);
        instance.m_22125_(new AttributeModifier(modifierId, "Trait Modifier | " + this.name, value, this.convertOperator(operator)));
    }

    private AttributeModifier.Operation convertOperator(String operator) {
        return switch (operator) {
            case "multiply" -> AttributeModifier.Operation.MULTIPLY_BASE;
            case "multiply_total" -> AttributeModifier.Operation.MULTIPLY_TOTAL;
            default -> AttributeModifier.Operation.ADDITION;
        };
    }

    @Override
    public void addStack(@Nullable ITrait trait, ModifierType modifierType, VaultBossEntity boss) {
        this.addStack(trait, modifierType, boss, 1.0);
    }

    @Override
    public void addStack(@Nullable ITrait trait, ModifierType modifierType, VaultBossEntity boss, double amount) {
        boolean isDamage;
        if (modifierType == ModifierType.NONE && trait instanceof AttributeModifierTrait) {
            AttributeModifierTrait other = (AttributeModifierTrait)trait;
            this.name = other.name;
            this.operator = other.operator;
            this.baseValue = other.baseValue;
            this.bonusValue = other.bonusValue;
            this.recalculateValue();
            if (this.applied) {
                this.refreshAttribute(boss);
            }
            return;
        }
        if (this.operator.equalsIgnoreCase("set") || amount <= 0.0) {
            return;
        }
        boolean isHealth = modifierType == ModifierType.HEALTH && this.isHealthModifier();
        boolean bl = isDamage = modifierType == ModifierType.DAMAGE && this.isDamageModifier();
        if (!isHealth && !isDamage) {
            return;
        }
        this.bonusValue += amount;
        this.recalculateValue();
        if (this.applied) {
            this.refreshAttribute(boss);
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("Name", this.name);
        nbt.m_128347_("Value", this.value);
        nbt.m_128359_("Operator", this.operator);
        if (this.applied) {
            nbt.m_128379_("Applied", true);
        }
        nbt.m_128347_("BaseValue", this.baseValue);
        nbt.m_128347_("BonusValue", this.bonusValue);
        return nbt;
    }

    private void recalculateValue() {
        this.value = this.baseValue + this.bonusValue;
    }

    private boolean isHealthModifier() {
        ResourceLocation maxHealth = Attributes.f_22276_.getRegistryName();
        return maxHealth != null && maxHealth.toString().equalsIgnoreCase(this.name);
    }

    private boolean isDamageModifier() {
        ResourceLocation attackDamage = Attributes.f_22281_.getRegistryName();
        return attackDamage != null && attackDamage.toString().equalsIgnoreCase(this.name);
    }

    private void refreshAttribute(VaultBossEntity boss) {
        if (this.name == null || this.name.isEmpty()) {
            return;
        }
        Registry.f_122866_.m_6612_(new ResourceLocation(this.name)).ifPresent(attribute -> {
            AttributeInstance attributeInstance = boss.m_21051_((Attribute)attribute);
            if (attributeInstance != null) {
                this.applyModifier(attributeInstance, this.operator, this.value);
            }
        });
    }

    private UUID getModifierId() {
        return UUID.nameUUIDFromBytes(("Trait Modifier | " + this.name).getBytes(StandardCharsets.UTF_8));
    }

    public static UUID getModifierId(String name) {
        return UUID.nameUUIDFromBytes(("Trait Modifier | " + name).getBytes(StandardCharsets.UTF_8));
    }
}

