/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.trait;

import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.VaultBossEntity;
import iskallia.vault.entity.boss.trait.IOnHitEffect;
import iskallia.vault.entity.boss.trait.ITrait;
import iskallia.vault.entity.boss.trait.ModifierType;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;

public class LifeLeechOnHitEffect
implements IOnHitEffect,
ITrait {
    public static final String TYPE = "life_leech_on_hit";
    private float leechPercentage;
    private float baseLeechPercentage;

    public LifeLeechOnHitEffect() {
        this.baseLeechPercentage = this.leechPercentage = 0.1f;
    }

    public LifeLeechOnHitEffect setAttributes(float leechPercentage) {
        this.leechPercentage = leechPercentage;
        this.baseLeechPercentage = leechPercentage;
        return this;
    }

    @Override
    public void onHit(VaultBossEntity boss, Player playerHit, float damage) {
        boss.m_5634_(damage * this.leechPercentage);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void apply(VaultBossEntity boss) {
        boss.addOnHitEffect(this);
    }

    @Override
    public void addStack(@Nullable ITrait trait, ModifierType modifierType, VaultBossEntity boss) {
        if (modifierType == ModifierType.NONE && trait instanceof LifeLeechOnHitEffect) {
            LifeLeechOnHitEffect addedLifeLeech = (LifeLeechOnHitEffect)trait;
            this.leechPercentage = addedLifeLeech.leechPercentage;
            this.baseLeechPercentage = addedLifeLeech.baseLeechPercentage;
            return;
        }
        if (modifierType == ModifierType.DAMAGE) {
            this.leechPercentage += this.baseLeechPercentage;
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128350_("LeechPercentage", this.leechPercentage);
        nbt.m_128350_("BaseLeechPercentage", this.baseLeechPercentage);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, VaultBossBaseEntity boss) {
        this.leechPercentage = nbt.m_128457_("LeechPercentage");
        this.baseLeechPercentage = nbt.m_128441_("BaseLeechPercentage") ? nbt.m_128457_("BaseLeechPercentage") : this.leechPercentage;
    }
}

