/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.trait;

import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.VaultBossEntity;
import iskallia.vault.entity.boss.trait.ITrait;
import iskallia.vault.entity.boss.trait.ModifierType;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;

public class RuneReviveTrait
implements ITrait {
    public static final String TYPE = "rune_revive";
    private int reviveCount;
    private float healthPercent;
    private int invulnerabilityTicks;

    public RuneReviveTrait() {
        this(0, 1.0f, 40);
    }

    public RuneReviveTrait(int reviveCount, float healthPercent, int invulnerabilityTicks) {
        this.reviveCount = Math.max(0, reviveCount);
        this.healthPercent = Math.max(0.0f, healthPercent);
        this.invulnerabilityTicks = Math.max(0, invulnerabilityTicks);
    }

    public RuneReviveTrait setAttributes(int reviveCount, float healthPercent, int invulnerabilityTicks) {
        this.reviveCount = Math.min(Math.max(0, reviveCount), 30);
        this.healthPercent = Math.max(0.0f, healthPercent);
        this.invulnerabilityTicks = Math.max(0, invulnerabilityTicks);
        return this;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Revives", Math.min(this.reviveCount, 30));
        tag.m_128350_("HealthPercent", this.healthPercent);
        tag.m_128405_("Invulnerability", this.invulnerabilityTicks);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, VaultBossBaseEntity boss) {
        this.reviveCount = Math.min(Math.max(0, nbt.m_128451_("Revives")), 30);
        this.healthPercent = Math.max(0.0f, nbt.m_128441_("HealthPercent") ? nbt.m_128457_("HealthPercent") : 1.0f);
        this.invulnerabilityTicks = Math.max(0, nbt.m_128441_("Invulnerability") ? nbt.m_128451_("Invulnerability") : 0);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void apply(VaultBossEntity boss) {
        boss.enableRuneReviveAbility(this);
    }

    @Override
    public void addStack(@Nullable ITrait trait, ModifierType modifierType, VaultBossEntity boss) {
        if (modifierType == ModifierType.NONE && trait instanceof RuneReviveTrait) {
            RuneReviveTrait other = (RuneReviveTrait)trait;
            this.reviveCount = Math.min(other.reviveCount, 30);
            this.healthPercent = other.healthPercent;
            this.invulnerabilityTicks = other.invulnerabilityTicks;
            boss.enableRuneReviveAbility(this);
            return;
        }
    }

    public int getReviveCount() {
        return this.reviveCount;
    }

    public float getHealthPercent() {
        return this.healthPercent;
    }

    public int getInvulnerabilityTicks() {
        return this.invulnerabilityTicks;
    }
}

