/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.trait;

import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.VaultBossEntity;
import iskallia.vault.entity.boss.trait.ITrait;
import iskallia.vault.entity.boss.trait.ModifierType;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.BossEvent;

public class RuneShieldTrait
implements ITrait {
    public static final String TYPE = "rune_shield";
    private int cooldownTicks;
    private int durationTicks;
    private String colorName;
    private float particleRadius;
    private double cooldownReductionPerHaste;
    private int abilityHasteStacks;

    public RuneShieldTrait() {
        this(200, 100, BossEvent.BossBarColor.WHITE, 2.0f, 0.1);
    }

    public RuneShieldTrait(int cooldownTicks, int durationTicks, BossEvent.BossBarColor color, float particleRadius, double cooldownReductionPerHaste) {
        this.cooldownTicks = Math.max(1, cooldownTicks);
        this.durationTicks = Math.max(1, durationTicks);
        this.colorName = color.m_18886_();
        this.particleRadius = particleRadius;
        this.cooldownReductionPerHaste = cooldownReductionPerHaste;
        this.abilityHasteStacks = 0;
    }

    public RuneShieldTrait setAttributes(int cooldownTicks, int durationTicks, BossEvent.BossBarColor color, float particleRadius, double cooldownReductionPerHaste) {
        this.cooldownTicks = Math.max(1, cooldownTicks);
        this.durationTicks = Math.max(1, durationTicks);
        this.colorName = color.m_18886_();
        this.particleRadius = particleRadius;
        this.cooldownReductionPerHaste = cooldownReductionPerHaste;
        return this;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Cooldown", this.cooldownTicks);
        tag.m_128405_("Duration", this.durationTicks);
        tag.m_128359_("Color", this.colorName);
        tag.m_128350_("ParticleRadius", this.particleRadius);
        tag.m_128347_("CooldownReduction", this.cooldownReductionPerHaste);
        tag.m_128405_("AbilityHasteStacks", this.abilityHasteStacks);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, VaultBossBaseEntity boss) {
        this.cooldownTicks = Math.max(1, nbt.m_128451_("Cooldown"));
        this.durationTicks = Math.max(1, nbt.m_128451_("Duration"));
        this.colorName = nbt.m_128461_("Color");
        this.particleRadius = nbt.m_128441_("ParticleRadius") ? nbt.m_128457_("ParticleRadius") : 0.0f;
        this.cooldownReductionPerHaste = nbt.m_128441_("CooldownReduction") ? nbt.m_128459_("CooldownReduction") : 0.0;
        this.abilityHasteStacks = Math.max(0, nbt.m_128451_("AbilityHasteStacks"));
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void apply(VaultBossEntity boss) {
        boss.enableRuneShieldAbility(this);
    }

    @Override
    public void addStack(@Nullable ITrait trait, ModifierType modifierType, VaultBossEntity boss) {
        if (modifierType == ModifierType.NONE && trait instanceof RuneShieldTrait) {
            RuneShieldTrait other = (RuneShieldTrait)trait;
            this.cooldownTicks = other.cooldownTicks;
            this.durationTicks = other.durationTicks;
            this.colorName = other.colorName;
            this.particleRadius = other.particleRadius;
            this.cooldownReductionPerHaste = other.cooldownReductionPerHaste;
            this.abilityHasteStacks = other.abilityHasteStacks;
            boss.enableRuneShieldAbility(this);
            return;
        }
        if (modifierType == ModifierType.ABILITY_HASTE) {
            ++this.abilityHasteStacks;
            boss.enableRuneShieldAbility(this);
        }
    }

    public int getCooldownTicks() {
        return this.cooldownTicks;
    }

    public int getDurationTicks() {
        return this.durationTicks;
    }

    public BossEvent.BossBarColor getColor() {
        try {
            return BossEvent.BossBarColor.valueOf((String)this.colorName.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return BossEvent.BossBarColor.WHITE;
        }
    }

    public float getParticleRadius() {
        return this.particleRadius;
    }

    public double getCooldownReductionPerHaste() {
        return this.cooldownReductionPerHaste;
    }

    public int getAbilityHasteStacks() {
        return this.abilityHasteStacks;
    }
}

