/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.trait;

import iskallia.vault.entity.boss.VaultBossBaseEntity;
import iskallia.vault.entity.boss.VaultBossEntity;
import iskallia.vault.entity.boss.trait.ITrait;
import iskallia.vault.entity.boss.trait.ModifierType;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;

public class RuneWaveBlastTrait
implements ITrait {
    public static final String TYPE = "rune_wave_blast";
    private int cooldownTicks;
    private float radius;
    private float damageMultiplier;
    private double cooldownReductionPerHaste;
    private float knockbackStrength;
    private int abilityHasteStacks;

    public RuneWaveBlastTrait() {
        this(220, 30.0f, 1.0f, 0.1, 0.4f);
    }

    public RuneWaveBlastTrait(int cooldownTicks, float radius, float damageMultiplier, double cooldownReductionPerHaste, float knockbackStrength) {
        this.cooldownTicks = Math.max(1, cooldownTicks);
        this.radius = Math.max(0.0f, radius);
        this.damageMultiplier = Math.max(0.0f, damageMultiplier);
        this.cooldownReductionPerHaste = cooldownReductionPerHaste;
        this.knockbackStrength = Math.max(0.0f, knockbackStrength);
        this.abilityHasteStacks = 0;
    }

    public RuneWaveBlastTrait setAttributes(int cooldownTicks, float radius, float damageMultiplier, double cooldownReductionPerHaste, float knockbackStrength) {
        this.cooldownTicks = Math.max(1, cooldownTicks);
        this.radius = Math.max(0.0f, radius);
        this.damageMultiplier = Math.max(0.0f, damageMultiplier);
        this.cooldownReductionPerHaste = cooldownReductionPerHaste;
        this.knockbackStrength = Math.max(0.0f, knockbackStrength);
        return this;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Cooldown", this.cooldownTicks);
        tag.m_128350_("Radius", this.radius);
        tag.m_128350_("DamageMultiplier", this.damageMultiplier);
        tag.m_128347_("CooldownReduction", this.cooldownReductionPerHaste);
        tag.m_128350_("Knockback", this.knockbackStrength);
        tag.m_128405_("AbilityHasteStacks", this.abilityHasteStacks);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, VaultBossBaseEntity boss) {
        this.cooldownTicks = Math.max(1, nbt.m_128451_("Cooldown"));
        this.radius = Math.max(0.0f, nbt.m_128457_("Radius"));
        this.damageMultiplier = Math.max(0.0f, nbt.m_128457_("DamageMultiplier"));
        this.cooldownReductionPerHaste = nbt.m_128441_("CooldownReduction") ? nbt.m_128459_("CooldownReduction") : 0.0;
        this.knockbackStrength = nbt.m_128441_("Knockback") ? nbt.m_128457_("Knockback") : 0.0f;
        this.abilityHasteStacks = Math.max(0, nbt.m_128451_("AbilityHasteStacks"));
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void apply(VaultBossEntity boss) {
        boss.enableRuneWaveBlastAbility(this);
    }

    @Override
    public void addStack(@Nullable ITrait trait, ModifierType modifierType, VaultBossEntity boss) {
        if (modifierType == ModifierType.NONE && trait instanceof RuneWaveBlastTrait) {
            RuneWaveBlastTrait other = (RuneWaveBlastTrait)trait;
            this.cooldownTicks = other.cooldownTicks;
            this.radius = other.radius;
            this.damageMultiplier = other.damageMultiplier;
            this.cooldownReductionPerHaste = other.cooldownReductionPerHaste;
            this.knockbackStrength = other.knockbackStrength;
            this.abilityHasteStacks = other.abilityHasteStacks;
            boss.enableRuneWaveBlastAbility(this);
            return;
        }
        if (modifierType == ModifierType.ABILITY_HASTE) {
            ++this.abilityHasteStacks;
            boss.enableRuneWaveBlastAbility(this);
        }
    }

    public int getCooldownTicks() {
        return this.cooldownTicks;
    }

    public float getRadius() {
        return this.radius;
    }

    public float getDamageMultiplier() {
        return this.damageMultiplier;
    }

    public double getCooldownReductionPerHaste() {
        return this.cooldownReductionPerHaste;
    }

    public float getKnockbackStrength() {
        return this.knockbackStrength;
    }

    public int getAbilityHasteStacks() {
        return this.abilityHasteStacks;
    }
}

