/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.boss.trait;

import com.google.common.collect.ImmutableMap;
import iskallia.vault.entity.boss.VaultBossEntity;
import iskallia.vault.entity.boss.attack.PersistentMeleeAttackGoal;
import iskallia.vault.entity.boss.goal.BloodOrbGoal;
import iskallia.vault.entity.boss.goal.CobwebRangedAttackGoal;
import iskallia.vault.entity.boss.goal.EvokerFangsGoal;
import iskallia.vault.entity.boss.goal.FireballRangedAttackGoal;
import iskallia.vault.entity.boss.goal.GolemDoubleHandRangedAttackGoal;
import iskallia.vault.entity.boss.goal.GolemHandRangedAttackGoal;
import iskallia.vault.entity.boss.goal.GroundSlamGoal;
import iskallia.vault.entity.boss.goal.HealGoal;
import iskallia.vault.entity.boss.goal.NovaAttackGoal;
import iskallia.vault.entity.boss.goal.PlaceBlockAroundGoal;
import iskallia.vault.entity.boss.goal.PotionAuraGoal;
import iskallia.vault.entity.boss.goal.ShulkerAttackGoal;
import iskallia.vault.entity.boss.goal.SnowballRangedAttackGoal;
import iskallia.vault.entity.boss.goal.SummonAtTargetGoal;
import iskallia.vault.entity.boss.goal.SummonGoal;
import iskallia.vault.entity.boss.goal.ThrowPotionGoal;
import iskallia.vault.entity.boss.trait.ApplyPotionOnHitEffect;
import iskallia.vault.entity.boss.trait.AttributeModifierTrait;
import iskallia.vault.entity.boss.trait.ITrait;
import iskallia.vault.entity.boss.trait.LifeLeechOnHitEffect;
import iskallia.vault.entity.boss.trait.RuneReviveTrait;
import iskallia.vault.entity.boss.trait.RuneShieldTrait;
import iskallia.vault.entity.boss.trait.RuneWaveBlastTrait;
import iskallia.vault.entity.boss.trait.SimpleTrait;
import iskallia.vault.entity.entity.VaultSpiderEntity;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;

public class VaultBossTraitRegistry {
    public static final String LEAP_AT_TARGET_TYPE = "leap_at_target";
    public static final String SPIDER_ATTACK_TYPE = "spider_attack";
    private static final Map<String, ITraitFactory> TRAIT_FACTORIES = new ImmutableMap.Builder().put((Object)"melee_attack", PersistentMeleeAttackGoal::new).put((Object)"fireball_ranged_attack", FireballRangedAttackGoal::new).put((Object)"snowball_ranged_attack", SnowballRangedAttackGoal::new).put((Object)"golem_hand_ranged_attack", GolemHandRangedAttackGoal::new).put((Object)"golem_double_hand_ranged_attack", GolemDoubleHandRangedAttackGoal::new).put((Object)"cobweb_ranged_attack", CobwebRangedAttackGoal::new).put((Object)"summon", SummonGoal::new).put((Object)"summon_at_target", SummonAtTargetGoal::new).put((Object)"shulker_bullet", ShulkerAttackGoal::new).put((Object)"heal", HealGoal::new).put((Object)"blood_orb", BloodOrbGoal::new).put((Object)"evoker_fangs", EvokerFangsGoal::new).put((Object)"attribute_modifier", boss -> new AttributeModifierTrait()).put((Object)"life_leech_on_hit", boss -> new LifeLeechOnHitEffect()).put((Object)"apply_potion_on_hit", boss -> new ApplyPotionOnHitEffect()).put((Object)"throw_potion", ThrowPotionGoal::new).put((Object)PotionAuraGoal.TYPE, boss -> {
        boss.f_19811_ = true;
        return new PotionAuraGoal(boss);
    }).put((Object)"leap_at_target", boss -> new SimpleTrait(LEAP_AT_TARGET_TYPE, b -> b.addTraitGoal((Goal)new LeapAtTargetGoal((Mob)boss, 0.4f)))).put((Object)"spider_attack", boss -> new SimpleTrait(SPIDER_ATTACK_TYPE, b -> b.addTraitGoal((Goal)new VaultSpiderEntity.SpiderAttackGoal((PathfinderMob)boss)))).put((Object)"place_block_around", PlaceBlockAroundGoal::new).put((Object)"ground_slam", GroundSlamGoal::new).put((Object)"nova_attack", NovaAttackGoal::new).put((Object)"rune_shield", boss -> new RuneShieldTrait()).put((Object)"rune_wave_blast", boss -> new RuneWaveBlastTrait()).put((Object)"rune_revive", boss -> new RuneReviveTrait()).build();

    public static Optional<ITrait> createTrait(String type, VaultBossEntity boss, CompoundTag attributesNbt) {
        if (!TRAIT_FACTORIES.containsKey(type)) {
            return Optional.empty();
        }
        ITrait trait = TRAIT_FACTORIES.get(type).create(boss);
        trait.deserializeNBT(attributesNbt, boss);
        return Optional.of(trait);
    }

    public static interface ITraitFactory {
        public ITrait create(VaultBossEntity var1);
    }
}

