/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.champion;

import iskallia.vault.VaultMod;
import iskallia.vault.entity.champion.ChampionAffixBase;
import iskallia.vault.entity.champion.IChampionAffix;
import iskallia.vault.entity.champion.LeechOnHitAffix;
import iskallia.vault.entity.champion.OnHitApplyPotionAffix;
import iskallia.vault.entity.champion.PotionAuraAffix;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;

public class ChampionAffixRegistry {
    private static final Map<String, Function<CompoundTag, IChampionAffix>> DESERIALIZERS = new HashMap<String, Function<CompoundTag, IChampionAffix>>();

    public static void register(String type, Function<CompoundTag, IChampionAffix> deserializer) {
        DESERIALIZERS.put(type, deserializer);
    }

    public static Optional<IChampionAffix> deserialize(CompoundTag tag) {
        String type = ChampionAffixBase.deserializeType(tag);
        if (DESERIALIZERS.containsKey(type)) {
            return Optional.of(DESERIALIZERS.get(type).apply(tag));
        }
        VaultMod.LOGGER.warn("Unknown champion affix type: {}", (Object)type);
        return Optional.empty();
    }

    static {
        ChampionAffixRegistry.register("on_hit_apply_potion", OnHitApplyPotionAffix::deserialize);
        ChampionAffixRegistry.register("potion_aura", PotionAuraAffix::deserialize);
        ChampionAffixRegistry.register("leech_on_hit", LeechOnHitAffix::deserialize);
    }
}

