/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.champion;

import iskallia.vault.config.LegacyLootTablesConfig;
import iskallia.vault.core.Version;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.world.loot.generator.LootTableGenerator;
import iskallia.vault.entity.champion.ChampionAffixRegistry;
import iskallia.vault.entity.champion.IChampionAffix;
import iskallia.vault.entity.champion.IChampionOnHitAffix;
import iskallia.vault.entity.champion.IChampionPacifyEffect;
import iskallia.vault.entity.champion.IChampionTickableAffix;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ClientboundChampionMessage;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.prestige.ChampionDamagePrestigePower;
import iskallia.vault.skill.prestige.helper.PrestigeHelper;
import iskallia.vault.skill.tree.PrestigeTree;
import iskallia.vault.util.LootInitialization;
import iskallia.vault.world.data.ServerVaults;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class ChampionLogic {
    private static final String AFFIXES_TAG = "affixes";
    private final List<IChampionAffix> affixes = new ArrayList<IChampionAffix>();
    public static final String CHAMPION_TAG = "vault_champion";
    public static final String NO_DROPS = "no_drops";
    public static final String CHAMPION_TEMPLATE_TAG = "ENTITY_CHAMPION";
    private boolean pacified = false;

    public static boolean isChampion(Entity entity) {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && ChampionLogic.isChampion(livingEntity = (LivingEntity)entity);
    }

    public static boolean isChampion(LivingEntity entity) {
        return entity.m_19880_().contains(CHAMPION_TAG);
    }

    private static boolean shouldDropLoot(LivingEntity entity) {
        return !entity.m_19880_().contains(NO_DROPS);
    }

    public boolean isPacified() {
        return this.pacified;
    }

    public static ChampionLogic deserialize(CompoundTag tag) {
        ChampionLogic championLogic = new ChampionLogic();
        if (tag.m_128441_(AFFIXES_TAG)) {
            CompoundTag affixesNbt = tag.m_128469_(AFFIXES_TAG);
            affixesNbt.m_128431_().forEach(key -> {
                CompoundTag affixCompound = affixesNbt.m_128469_(key);
                ChampionAffixRegistry.deserialize(affixCompound).ifPresent(championLogic::addAffix);
            });
        }
        return championLogic;
    }

    @SubscribeEvent
    public static void onEntityAttack(LivingAttackEvent event) {
        LivingEntity livingEntity;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity && ChampionLogic.isChampion(livingEntity = (LivingEntity)entity) && (entity = event.getEntityLiving()) instanceof Player) {
            Player player = (Player)entity;
            ChampionLogic.runIfChampion((Entity)livingEntity, championLogic -> championLogic.runOnAffixesThatImplement(IChampionOnHitAffix.class, affix -> affix.onChampionHitPlayer(livingEntity, player, event.getAmount())));
        }
    }

    @SubscribeEvent
    public static void onEntityDrops(LivingDropsEvent event) {
        Entity entity;
        if (ChampionLogic.isChampion(event.getEntityLiving()) && ChampionLogic.shouldDropLoot(event.getEntityLiving()) && (entity = event.getSource().m_7639_()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ServerVaults.get((Level)player.m_183503_()).ifPresent(vault -> {
                int level = vault.get(Vault.LEVEL).get();
                LegacyLootTablesConfig.Level levelLootTables = ModConfigs.LOOT_TABLES.getForLevel(level);
                if (levelLootTables == null) {
                    return;
                }
                PrestigeTree prestige = PrestigeHelper.getPrestige((Player)player);
                boolean extraRoll = !prestige.getAll(ChampionDamagePrestigePower.class, Skill::isUnlocked).isEmpty();
                String lootTableId = levelLootTables.CHAMPION;
                int rolls = extraRoll ? 2 : 1;
                LivingEntity champion = event.getEntityLiving();
                for (int i = 0; i < rolls; ++i) {
                    LootTableGenerator generator = new LootTableGenerator(Version.latest(), VaultRegistry.LOOT_TABLE.getKey(lootTableId), 0.0f);
                    generator.generate(JavaRandom.ofNanoTime());
                    generator.getItems().forEachRemaining(item -> {
                        item = LootInitialization.initializeVaultLoot(item, vault, champion.m_142538_());
                        event.getDrops().add(new ItemEntity(champion.f_19853_, champion.m_20185_(), champion.m_20186_(), champion.m_20189_(), item));
                    });
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPotionAdded(PotionEvent.PotionAddedEvent event) {
        LivingEntity livingEntity;
        if (!event.isCanceled() && ChampionLogic.isChampion(event.getEntityLiving()) && (livingEntity = event.getEntityLiving()) instanceof IChampionLogicHolder) {
            IChampionLogicHolder championLogicHolder = (IChampionLogicHolder)livingEntity;
            if (event.getPotionEffect().m_19544_() instanceof IChampionPacifyEffect) {
                championLogicHolder.getChampionLogic().pacified = true;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPotionExpired(PotionEvent.PotionExpiryEvent event) {
        LivingEntity livingEntity;
        if (!event.isCanceled() && ChampionLogic.isChampion(event.getEntityLiving()) && (livingEntity = event.getEntityLiving()) instanceof IChampionLogicHolder) {
            IChampionLogicHolder championLogicHolder = (IChampionLogicHolder)livingEntity;
            if (event.getPotionEffect() != null && event.getPotionEffect().m_19544_() instanceof IChampionPacifyEffect) {
                ChampionLogic.makeAngryAgainIfNoOtherPacifyingEffects((PotionEvent)event, championLogicHolder);
            }
        }
    }

    private static void makeAngryAgainIfNoOtherPacifyingEffects(PotionEvent event, IChampionLogicHolder championLogicHolder) {
        boolean hasNoOtherPacifyingEffects = true;
        for (MobEffectInstance effectInstance : event.getEntityLiving().m_21220_()) {
            if (effectInstance.m_19544_() == event.getPotionEffect().m_19544_() || !(effectInstance.m_19544_() instanceof IChampionPacifyEffect)) continue;
            hasNoOtherPacifyingEffects = false;
            break;
        }
        if (hasNoOtherPacifyingEffects) {
            championLogicHolder.getChampionLogic().pacified = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPotionRemoved(PotionEvent.PotionRemoveEvent event) {
        LivingEntity livingEntity;
        if (!event.isCanceled() && ChampionLogic.isChampion(event.getEntityLiving()) && (livingEntity = event.getEntityLiving()) instanceof IChampionLogicHolder) {
            IChampionLogicHolder championLogicHolder = (IChampionLogicHolder)livingEntity;
            if (event.getPotionEffect() != null && event.getPotionEffect().m_19544_() instanceof IChampionPacifyEffect) {
                ChampionLogic.makeAngryAgainIfNoOtherPacifyingEffects((PotionEvent)event, championLogicHolder);
            }
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Entity entity;
        if (ChampionLogic.isChampion(event.getTarget()) && (entity = event.getTarget()) instanceof IChampionLogicHolder) {
            IChampionLogicHolder championLogicHolder = (IChampionLogicHolder)entity;
            entity = event.getTarget();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                entity = event.getPlayer();
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    ChampionLogic championLogic = championLogicHolder.getChampionLogic();
                    championLogic.syncClientData(livingEntity, PacketDistributor.PLAYER.with(() -> player));
                }
            }
        }
    }

    public Optional<CompoundTag> serialize() {
        if (this.affixes.isEmpty()) {
            return Optional.empty();
        }
        CompoundTag affixesNbt = new CompoundTag();
        this.affixes.forEach(affix -> affixesNbt.m_128365_(affix.getType(), (Tag)affix.serialize()));
        CompoundTag ret = new CompoundTag();
        ret.m_128365_(AFFIXES_TAG, (Tag)affixesNbt);
        return Optional.of(ret);
    }

    private static void runIfChampion(Entity entity, Consumer<ChampionLogic> consumer) {
        if (entity instanceof IChampionLogicHolder) {
            IChampionLogicHolder championLogicHolder = (IChampionLogicHolder)entity;
            if (!championLogicHolder.getChampionLogic().pacified) {
                consumer.accept(championLogicHolder.getChampionLogic());
            }
        }
    }

    private <T extends IChampionAffix> void runOnAffixesThatImplement(Class<T> clazz, Consumer<T> consumer) {
        this.getAffixes().forEach(affix -> {
            if (clazz.isInstance(affix)) {
                consumer.accept(affix);
            }
        });
    }

    public void tick(Entity entity) {
        LivingEntity livingEntity;
        if (!(entity instanceof LivingEntity) || !ChampionLogic.isChampion(livingEntity = (LivingEntity)entity)) {
            return;
        }
        ChampionLogic.runIfChampion(entity, championLogic -> championLogic.runOnAffixesThatImplement(IChampionTickableAffix.class, affix -> affix.tick(livingEntity)));
    }

    public void addAffix(IChampionAffix affix) {
        this.affixes.add(affix);
    }

    public List<IChampionAffix> getAffixes() {
        return this.affixes;
    }

    public void setAffixes(List<IChampionAffix> affixes) {
        this.affixes.clear();
        this.affixes.addAll(affixes);
    }

    public void syncClientData(LivingEntity entity, PacketDistributor.PacketTarget target) {
        ModNetwork.CHANNEL.send(target, (Object)new ClientboundChampionMessage(entity.m_142049_(), this.affixes));
    }

    public static interface IChampionLogicHolder {
        public ChampionLogic getChampionLogic();
    }
}

