/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import iskallia.vault.entity.ai.greed.AcidPursuerGroundSlamGoal;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class AcidPursuerEntity
extends Monster
implements IAnimatable,
IAnimationTickable {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private boolean isAttacking = false;
    private AttackType currentAttackType = AttackType.NONE;
    private static final AnimationBuilder WALK_ANIMATION = new AnimationBuilder().addAnimation("animation.acid_pursuer.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    private static final AnimationBuilder IDLE_ANIMATION = new AnimationBuilder().addAnimation("animation.acid_pursuer.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    private static final AnimationBuilder TELEPORT_STARTUP = new AnimationBuilder().addAnimation("animation.acid_pursuer.teleportattack.startup", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationBuilder TELEPORT_ATTACK = new AnimationBuilder().addAnimation("animation.acid_pursuer.teleportattack.attack", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);

    public AcidPursuerEntity(EntityType<? extends AcidPursuerEntity> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22277_, 16.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new AcidPursuerGroundSlamGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void startGroundSlamAttack() {
        this.isAttacking = true;
        this.currentAttackType = AttackType.GROUND_SLAM;
        AnimationData data = this.factory.getOrCreateAnimationData(this.m_142049_());
        AnimationController controller = (AnimationController)data.getAnimationControllers().get("Attack");
        if (controller != null) {
            controller.markNeedsReload();
            controller.setAnimation(TELEPORT_ATTACK);
        }
    }

    public void stopAttacking() {
        this.isAttacking = false;
        this.currentAttackType = AttackType.NONE;
    }

    public boolean isAttacking() {
        return this.isAttacking;
    }

    public AttackType getCurrentAttackType() {
        return this.currentAttackType;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "Movement", 0.0f, this::movementController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "Attack", 0.0f, event -> PlayState.STOP));
    }

    private <T extends IAnimatable> PlayState movementController(AnimationEvent<AcidPursuerEntity> event) {
        AnimationController controller = event.getController();
        if (event.isMoving()) {
            controller.setAnimation(WALK_ANIMATION);
            return PlayState.CONTINUE;
        }
        controller.setAnimation(IDLE_ANIMATION);
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    public static enum AttackType {
        NONE,
        GROUND_SLAM;

    }
}

