/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import iskallia.vault.core.Version;
import iskallia.vault.core.data.key.LootTableKey;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.vault.VaultRegistry;
import iskallia.vault.core.world.loot.generator.LootTableGenerator;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.SkinProfile;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AncientCopperGolemEntity
extends PathfinderMob {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(AncientCopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<CompoundTag> DATA_POSING = SynchedEntityData.m_135353_(AncientCopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<Boolean> DATA_WAXED = SynchedEntityData.m_135353_(AncientCopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int MAX_AGE = 800;
    private int age = 800;
    public String lastName = "";
    public SkinProfile skin;

    public AncientCopperGolemEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        if (world.f_46443_) {
            this.skin = new SkinProfile();
        }
        this.setAge(ModConfigs.ANCIENT_COPPER_GOLEM.degradeTime);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoalGolem(this, 1.5));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoalGolem(this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.ANCIENT_COPPER_INGOT}), false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoalGolem(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, (double)0.18f).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
        this.f_19804_.m_135372_(DATA_POSING, (Object)new CompoundTag());
        this.f_19804_.m_135372_(DATA_WAXED, (Object)false);
    }

    public void setPosing(Optional<CompoundTag> pose) {
        CompoundTag tag = new CompoundTag();
        pose.ifPresent(oTag -> tag.m_128365_("pose", (Tag)oTag));
        this.f_19804_.m_135381_(DATA_POSING, (Object)tag);
    }

    public Optional<CompoundTag> getPosing() {
        CompoundTag tag = (CompoundTag)this.f_19804_.m_135370_(DATA_POSING);
        return tag.m_128441_("pose") ? Optional.of(tag.m_128469_("pose")) : Optional.empty();
    }

    public void loadAngles(CompoundTag tag) {
        this.m_146926_(tag.m_128457_("xRot"));
        this.m_5616_(tag.m_128457_("yHeadRot"));
        this.m_5618_(tag.m_128457_("yBodyRot"));
        this.f_20886_ = this.m_6080_();
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        this.f_20925_ = tag.m_128457_("animationPosition");
        this.f_20923_ = this.f_20924_ = tag.m_128457_("animationSpeed");
    }

    public CompoundTag saveAngles() {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("xRot", this.m_146909_());
        tag.m_128350_("yHeadRot", this.m_6080_());
        tag.m_128350_("yBodyRot", this.f_20883_);
        tag.m_128350_("animationPosition", this.f_20925_);
        tag.m_128350_("animationSpeed", this.f_20924_);
        return tag;
    }

    public CompoundTag saveAnglesWithBodyRot(float bodyRot) {
        CompoundTag tag = new CompoundTag();
        float diff = this.f_20883_ - bodyRot;
        float xRot = this.m_146909_();
        tag.m_128350_("xRot", xRot);
        tag.m_128350_("yHeadRot", this.m_6080_() - diff);
        tag.m_128350_("yBodyRot", bodyRot);
        tag.m_128350_("animationPosition", this.f_20925_);
        tag.m_128350_("animationSpeed", this.f_20924_);
        return tag;
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Variant", this.getTypeVariant());
        pCompound.m_128379_("Waxed", this.getWaxed());
        if (this.getPosing().isPresent()) {
            pCompound.m_128365_("Pose", (Tag)this.getPosing().get());
        }
        pCompound.m_128405_("Age", this.getAge());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setTypeVariant(pCompound.m_128451_("Variant"));
        this.setWaxed(pCompound.m_128471_("Waxed"));
        if (pCompound.m_128441_("Pose")) {
            this.setPosing(Optional.of(pCompound.m_128469_("Pose")));
        }
        this.setAge(pCompound.m_128451_("Age"));
    }

    private void setTypeVariant(int p_30737_) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)p_30737_);
    }

    public int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    private void setAge(int age) {
        this.age = age;
    }

    public int getAge() {
        return this.age;
    }

    public boolean getWaxed() {
        return (Boolean)this.f_19804_.m_135370_(DATA_WAXED);
    }

    public void setWaxed(boolean waxed) {
        this.f_19804_.m_135381_(DATA_WAXED, (Object)waxed);
    }

    public float m_6113_() {
        if (this.getWaxed()) {
            return 0.0f;
        }
        return super.m_6113_();
    }

    protected InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (itemstack.m_41619_()) {
            if (pHand == InteractionHand.MAIN_HAND && this.getWaxed()) {
                if (!this.f_19853_.f_46443_) {
                    Vec3 vec3 = pPlayer.m_20182_().m_82546_(this.m_20182_());
                    this.setPosing(Optional.of(this.saveAnglesWithBodyRot((float)(-(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875)))));
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            return InteractionResult.PASS;
        }
        if (itemstack.m_150930_(Items.f_42784_)) {
            if (this.getWaxed()) {
                return InteractionResult.PASS;
            }
            if (!this.f_19853_.f_46443_) {
                this.setWaxed(true);
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175828_, this.m_20182_().f_82479_ + (double)0.3f, this.m_20182_().f_82480_ + (double)(this.m_20206_() / 2.0f), this.m_20182_().f_82481_, 5, Mth.m_14064_((Random)this.f_19853_.f_46441_, (double)-0.25, (double)0.25), Mth.m_14064_((Random)this.f_19853_.f_46441_, (double)-0.25, (double)0.25), Mth.m_14064_((Random)this.f_19853_.f_46441_, (double)-0.05, (double)0.05), 1.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175828_, this.m_20182_().f_82479_ - (double)0.3f, this.m_20182_().f_82480_ + (double)(this.m_20206_() / 2.0f), this.m_20182_().f_82481_, 5, Mth.m_14064_((Random)this.f_19853_.f_46441_, (double)-0.25, (double)0.25), Mth.m_14064_((Random)this.f_19853_.f_46441_, (double)-0.25, (double)0.25), Mth.m_14064_((Random)this.f_19853_.f_46441_, (double)-0.05, (double)0.05), 1.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175828_, this.m_20182_().f_82479_, this.m_20182_().f_82480_ + (double)(this.m_20206_() / 2.0f), this.m_20182_().f_82481_ - (double)0.3f, 5, Mth.m_14064_((Random)this.f_19853_.f_46441_, (double)-0.05, (double)0.05), Mth.m_14064_((Random)this.f_19853_.f_46441_, (double)-0.25, (double)0.25), Mth.m_14064_((Random)this.f_19853_.f_46441_, (double)-0.25, (double)0.25), 1.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175828_, this.m_20182_().f_82479_, this.m_20182_().f_82480_ + (double)(this.m_20206_() / 2.0f), this.m_20182_().f_82481_ + (double)0.3f, 5, Mth.m_14064_((Random)this.f_19853_.f_46441_, (double)-0.05, (double)0.05), Mth.m_14064_((Random)this.f_19853_.f_46441_, (double)-0.25, (double)0.25), Mth.m_14064_((Random)this.f_19853_.f_46441_, (double)-0.25, (double)0.25), 1.0);
                }
                this.f_19853_.m_6269_(null, (Entity)this, SoundEvents.f_144178_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (itemstack.m_41720_() instanceof AxeItem) {
            if (!this.getWaxed()) {
                return InteractionResult.PASS;
            }
            if (!this.f_19853_.f_46443_) {
                this.setWaxed(false);
                this.setPosing(Optional.empty());
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175829_, this.m_20182_().f_82479_ + (double)0.3f, this.m_20182_().f_82480_ + (double)(this.m_20206_() / 2.0f), this.m_20182_().f_82481_, 5, Mth.m_14064_((Random)this.f_19853_.f_46441_, (double)-0.25, (double)0.25), Mth.m_14064_((Random)this.f_19853_.f_46441_, (double)-0.25, (double)0.25), Mth.m_14064_((Random)this.f_19853_.f_46441_, (double)-0.05, (double)0.05), 1.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175829_, this.m_20182_().f_82479_ - (double)0.3f, this.m_20182_().f_82480_ + (double)(this.m_20206_() / 2.0f), this.m_20182_().f_82481_, 5, Mth.m_14064_((Random)this.f_19853_.f_46441_, (double)-0.25, (double)0.25), Mth.m_14064_((Random)this.f_19853_.f_46441_, (double)-0.25, (double)0.25), Mth.m_14064_((Random)this.f_19853_.f_46441_, (double)-0.05, (double)0.05), 1.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175829_, this.m_20182_().f_82479_, this.m_20182_().f_82480_ + (double)(this.m_20206_() / 2.0f), this.m_20182_().f_82481_ - (double)0.3f, 5, Mth.m_14064_((Random)this.f_19853_.f_46441_, (double)-0.05, (double)0.05), Mth.m_14064_((Random)this.f_19853_.f_46441_, (double)-0.25, (double)0.25), Mth.m_14064_((Random)this.f_19853_.f_46441_, (double)-0.25, (double)0.25), 1.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175829_, this.m_20182_().f_82479_, this.m_20182_().f_82480_ + (double)(this.m_20206_() / 2.0f), this.m_20182_().f_82481_ + (double)0.3f, 5, Mth.m_14064_((Random)this.f_19853_.f_46441_, (double)-0.05, (double)0.05), Mth.m_14064_((Random)this.f_19853_.f_46441_, (double)-0.25, (double)0.25), Mth.m_14064_((Random)this.f_19853_.f_46441_, (double)-0.25, (double)0.25), 1.0);
                }
                this.f_19853_.m_6269_(null, (Entity)this, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.m_5776_()) {
            if (this.getWaxed()) {
                if (this.getPosing().isEmpty()) {
                    this.setPosing(Optional.of(this.saveAngles()));
                }
                this.getPosing().ifPresent(this::loadAngles);
            } else if (this.getAge() > 0) {
                --this.age;
                if (this.getAge() == 0) {
                    if (this.getTypeVariant() < 3) {
                        this.setTypeVariant(this.getTypeVariant() + 1);
                        if (this.getTypeVariant() == 2) {
                            this.setAge(ModConfigs.ANCIENT_COPPER_GOLEM.degradeTime);
                        } else {
                            this.setAge(ModConfigs.ANCIENT_COPPER_GOLEM.finalDegradeTime);
                        }
                    } else {
                        this.m_6074_();
                    }
                }
            }
        } else {
            String name;
            if (this.getWaxed()) {
                this.getPosing().ifPresent(this::loadAngles);
            }
            if (this.m_8077_() && this.m_7770_() != null && !this.lastName.equals(name = this.m_7770_().getString())) {
                this.skin.updateSkin(name);
                this.lastName = name;
            }
        }
    }

    public void m_6043_() {
    }

    protected void m_7625_(DamageSource pDamageSource, boolean pAttackedRecently) {
        super.m_7625_(pDamageSource, pAttackedRecently);
        if (this.f_19853_.m_5776_()) {
            return;
        }
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel sWorld = (ServerLevel)level;
            if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                ResourceLocation loc = new ResourceLocation(ModConfigs.ANCIENT_COPPER_GOLEM.LOOT_TABLES.get(this.getOxidizationLevel()));
                ArrayList loot = new ArrayList();
                LootTableKey key = VaultRegistry.LOOT_TABLE.getKey(loc);
                if (key != null) {
                    LootTableGenerator generator = new LootTableGenerator(Version.latest(), key, 0.0f);
                    generator.generate(JavaRandom.ofNanoTime());
                    generator.getItems().forEachRemaining(loot::add);
                }
                if (this.f_19853_ instanceof ServerLevel) {
                    loot.forEach(stack -> AncientCopperGolemEntity.popResource(this.f_19853_, this.m_20182_(), stack));
                }
                if (this.m_8077_() && this.m_7770_() != null) {
                    ItemStack headDrop = new ItemStack((ItemLike)Items.f_42680_, 1);
                    CompoundTag nbt = new CompoundTag();
                    nbt.m_128359_("SkullOwner", this.m_7770_().getString());
                    headDrop.m_41751_(nbt);
                    ItemEntity entity = new ItemEntity(this.f_19853_, this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_(), headDrop);
                    this.f_19853_.m_7967_((Entity)entity);
                }
            }
        }
    }

    public static void popResource(Level pLevel, Vec3 pPos, ItemStack pStack) {
        float f = EntityType.f_20461_.m_20679_() / 2.0f;
        double d0 = (double)((float)pPos.m_7096_()) + Mth.m_14064_((Random)pLevel.f_46441_, (double)-0.25, (double)0.25);
        double d1 = (double)((float)pPos.m_7098_()) + Mth.m_14064_((Random)pLevel.f_46441_, (double)-0.25, (double)0.25) - (double)f;
        double d2 = (double)((float)pPos.m_7094_()) + Mth.m_14064_((Random)pLevel.f_46441_, (double)-0.25, (double)0.25);
        AncientCopperGolemEntity.popResource(pLevel, () -> new ItemEntity(pLevel, d0, d1, d2, pStack), pStack);
    }

    private static void popResource(Level pLevel, Supplier<ItemEntity> pItemEntitySupplier, ItemStack pStack) {
        if (!pLevel.f_46443_ && !pStack.m_41619_() && pLevel.m_46469_().m_46207_(GameRules.f_46136_) && !pLevel.restoringBlockSnapshots) {
            ItemEntity itementity = pItemEntitySupplier.get();
            itementity.m_32060_();
            pLevel.m_7967_((Entity)itementity);
        }
    }

    public String getOxidizationLevel() {
        return switch (this.getTypeVariant()) {
            default -> "Copper";
            case 1 -> "Exposed";
            case 2 -> "Weathered";
            case 3 -> "Oxidized";
        };
    }

    public boolean m_6162_() {
        return false;
    }

    public void m_6863_(boolean pChildZombie) {
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        super.m_7350_(pKey);
    }

    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setAge(ModConfigs.ANCIENT_COPPER_GOLEM.degradeTime);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public static class PanicGoalGolem
    extends PanicGoal {
        protected final AncientCopperGolemEntity f_25684_;

        public PanicGoalGolem(AncientCopperGolemEntity pMob, double pSpeedModifier) {
            super((PathfinderMob)pMob, pSpeedModifier);
            this.f_25684_ = pMob;
        }

        public boolean m_8036_() {
            if (this.f_25684_.getWaxed()) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (this.f_25684_.getWaxed()) {
                return false;
            }
            return super.m_8045_();
        }
    }

    public static class TemptGoalGolem
    extends TemptGoal {
        protected final AncientCopperGolemEntity f_25924_;

        public TemptGoalGolem(AncientCopperGolemEntity pMob, double pSpeedModifier, Ingredient pItems, boolean pCanScare) {
            super((PathfinderMob)pMob, pSpeedModifier, pItems, pCanScare);
            this.f_25924_ = pMob;
        }

        public boolean m_8036_() {
            if (this.f_25924_.getWaxed()) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (this.f_25924_.getWaxed()) {
                return false;
            }
            return super.m_8045_();
        }
    }

    public static class WaterAvoidingRandomStrollGoalGolem
    extends WaterAvoidingRandomStrollGoal {
        protected final float f_25985_;
        protected final AncientCopperGolemEntity f_25725_;

        public WaterAvoidingRandomStrollGoalGolem(AncientCopperGolemEntity p_25987_, double p_25988_) {
            this(p_25987_, p_25988_, 0.001f);
        }

        public WaterAvoidingRandomStrollGoalGolem(AncientCopperGolemEntity pMob, double pSpeedModifier, float pProbability) {
            super((PathfinderMob)pMob, pSpeedModifier);
            this.f_25725_ = pMob;
            this.f_25985_ = pProbability;
        }

        public boolean m_8036_() {
            if (this.f_25725_.getWaxed()) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (this.f_25725_.getWaxed()) {
                return false;
            }
            return super.m_8045_();
        }
    }
}

