/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import iskallia.vault.init.ModSounds;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class CrabEntity
extends Animal
implements IAnimatable,
NeutralMob {
    private static final EntityDataAccessor<Boolean> DATA_SHELL = SynchedEntityData.m_135353_(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    @javax.annotation.Nullable
    private UUID persistentAngerTarget;
    private final AnimationFactory animationFactory = GeckoLibUtil.createFactory((IAnimatable)this);
    private static final AnimationBuilder WALK_ANIMATION = new AnimationBuilder().addAnimation("animation.crab.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    private static final AnimationBuilder IDLE_ANIMATION = new AnimationBuilder().addAnimation("animation.crab.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);

    public CrabEntity(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public boolean m_6898_(ItemStack pStack) {
        return false;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, new CrabAvoidGoal<Player>(this, Player.class, 8.0f, 2.0, 2.0));
        this.f_21345_.m_25352_(2, (Goal)new CrabMeleeAttackGoal(this, 1.0, true));
        this.f_21345_.m_25352_(3, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new CrabNearestAttackableTargetGoal<Player>(this, Player.class, 10, true, false, arg_0 -> ((CrabEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AgeableMob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_((Attribute)ForgeMod.REACH_DISTANCE.get(), 3.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return super.m_6469_(pSource, this.hasShell() ? pAmount / 2.0f : pAmount);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_21223_() <= this.m_21233_() / 2.0f && this.hasShell()) {
            this.breakShell();
        }
    }

    private void breakShell() {
        this.setHasShell(false);
        this.m_21662_();
        this.playShellSmashSound();
    }

    public boolean m_6040_() {
        return true;
    }

    protected float m_6108_() {
        return 0.98f;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public boolean m_6573_(Player pPlayer) {
        return false;
    }

    public void setHasShell(boolean hasShell) {
        this.f_19804_.m_135381_(DATA_SHELL, (Object)hasShell);
    }

    public boolean hasShell() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SHELL);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SHELL, (Object)true);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("HasShell", this.hasShell());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("HasShell")) {
            this.setHasShell(pCompound.m_128471_("HasShell"));
        } else {
            this.setHasShell(true);
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return super.m_7515_();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return super.m_7975_(pDamageSource);
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return super.m_5592_();
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
    }

    protected void playShellSmashSound() {
        this.m_5496_(ModSounds.CRAB_SHELL_SMASH, 0.2f, 1.0f);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "Walking", 5.0f, this::walkAnimationController));
        data.addAnimationController(new AnimationController((IAnimatable)this, "Idle", 0.0f, this::idleAnimController));
    }

    private PlayState walkAnimationController(AnimationEvent<CrabEntity> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(WALK_ANIMATION);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private PlayState idleAnimController(AnimationEvent<CrabEntity> event) {
        if (!event.isMoving()) {
            event.getController().setAnimation(IDLE_ANIMATION);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimationFactory getFactory() {
        return this.animationFactory;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int remainingPersistentAngerTime) {
        this.remainingPersistentAngerTime = remainingPersistentAngerTime;
    }

    @javax.annotation.Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@javax.annotation.Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_142270_(this.f_19796_));
    }

    static class CrabAvoidGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final CrabEntity crab;

        public CrabAvoidGoal(CrabEntity pMob, Class<T> pEntityClassToAvoid, float pMaxDistance, double pWalkSpeedModifier, double pSprintSpeedModifier) {
            super((PathfinderMob)pMob, pEntityClassToAvoid, pMaxDistance, pWalkSpeedModifier, pSprintSpeedModifier, EntitySelector.f_20408_::test);
            this.crab = pMob;
        }

        public boolean m_8036_() {
            return !this.crab.hasShell() && super.m_8036_();
        }
    }

    static class CrabMeleeAttackGoal
    extends MeleeAttackGoal {
        private final CrabEntity crab;

        public CrabMeleeAttackGoal(CrabEntity pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super((PathfinderMob)pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
            this.crab = pMob;
        }

        public boolean m_8036_() {
            return this.crab.hasShell() && super.m_8036_();
        }

        public boolean m_8045_() {
            return this.crab.hasShell() && super.m_8045_();
        }

        public void m_8056_() {
            if (!this.crab.hasShell()) {
                this.crab.m_21561_(false);
                this.m_8041_();
            } else {
                super.m_8056_();
            }
        }
    }

    static class CrabNearestAttackableTargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        private final CrabEntity crab;

        public CrabNearestAttackableTargetGoal(CrabEntity pMob, Class<T> pTargetType, int pRandomInterval, boolean pMustSee, boolean pMustReach, @javax.annotation.Nullable Predicate<LivingEntity> pTargetPredicate) {
            super((Mob)pMob, pTargetType, pRandomInterval, pMustSee, pMustReach, pTargetPredicate);
            this.crab = pMob;
        }

        public boolean m_8036_() {
            return this.crab.hasShell() && super.m_8036_();
        }
    }
}

