/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import com.mojang.authlib.GameProfile;
import iskallia.vault.entity.IPlayerSkinHolder;
import iskallia.vault.item.VaultDollItem;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.world.data.DollLootData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.Nullable;

public class DollMiniMeEntity
extends Monster
implements IPlayerSkinHolder {
    private static final int ATTACK_COOLDOWN_SECONDS_MIN = 1;
    private static final int ATTACK_COOLDOWN_SECONDS_MAX = 5;
    private static final String OWNER_PROFILE_TAG = "ownerProfile";
    private static final String DOLL_ID_TAG = "dollId";
    private static final String XP_POINTS_TAG = "xpPoints";
    private long attackCooldownTime = 0L;
    private GameProfile gameProfile = null;
    private UUID dollId = null;
    private int experiencePoints = 0;
    private ResourceLocation skinLocation = null;
    private boolean updatingSkin = false;
    private boolean slimSkin = false;
    private static final int PANIC_DISTANCE = 20;

    public DollMiniMeEntity(EntityType<DollMiniMeEntity> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 50.0).m_22268_(Attributes.f_22282_, 10.0).m_22268_(Attributes.f_22279_, (double)0.34f).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        if (dataTag != null) {
            VaultDollItem.getPlayerGameProfile(dataTag).ifPresent(this::setGameProfile);
            VaultDollItem.getDollUUID(dataTag).ifPresent(dollUuid -> {
                this.dollId = dollUuid;
            });
            this.experiencePoints = VaultDollItem.getExperience(dataTag);
        }
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MoveCloserToTargetGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new DollMiniMePanicGoal(this, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new DollMiniMeMeleeAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHit) {
        Player player;
        super.m_7472_(source, looting, recentlyHit);
        if (recentlyHit && (player = this.f_20888_) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (!(this.f_20888_ instanceof FakePlayer) && (player = this.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)player;
                DollLootData dollLootData = DollLootData.get(serverLevel, this.dollId);
                List<ItemStack> loot = dollLootData.getLoot();
                InventoryUtil.makeItemsRotten(loot);
                loot.forEach(arg_0 -> ((DollMiniMeEntity)this).m_19983_(arg_0));
                dollLootData.clearLoot();
                PlayerVaultStatsData statsData = PlayerVaultStatsData.get(player2.m_183503_());
                statsData.addVaultExp(player2, this.experiencePoints);
            }
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IPlayerSkinHolder.OPTIONAL_GAME_PROFILE, Optional.empty());
    }

    public boolean m_7327_(Entity entity) {
        boolean result = super.m_7327_(entity);
        this.attackCooldownTime = this.f_19853_.m_46467_() + (long)this.f_19796_.nextInt(1, 5) * 20L;
        return result;
    }

    public boolean isOutOfCoolDownTime() {
        return this.f_19853_.m_46467_() > this.attackCooldownTime;
    }

    public boolean m_21532_() {
        return true;
    }

    public boolean m_6162_() {
        return true;
    }

    public boolean isTargetLookingAtMe() {
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return false;
        }
        Vec3 targetViewVector = target.m_20252_(1.0f).m_82541_();
        Vec3 positionsVector = new Vec3(this.m_20185_() - target.m_20185_(), this.m_20188_() - target.m_20188_(), this.m_20189_() - target.m_20189_());
        double closenessRatio = targetViewVector.m_82526_(positionsVector = positionsVector.m_82541_());
        return closenessRatio > 0.5 && target.m_142582_((Entity)this);
    }

    @Override
    public Optional<GameProfile> getGameProfile() {
        return (Optional)this.f_19804_.m_135370_(IPlayerSkinHolder.OPTIONAL_GAME_PROFILE);
    }

    @Override
    public void setGameProfile(GameProfile gameProfile) {
        this.gameProfile = gameProfile;
        this.f_19804_.m_135381_(IPlayerSkinHolder.OPTIONAL_GAME_PROFILE, Optional.ofNullable(gameProfile));
    }

    @Override
    public Optional<ResourceLocation> getSkinLocation() {
        return Optional.ofNullable(this.skinLocation);
    }

    @Override
    public boolean isUpdatingSkin() {
        return this.updatingSkin;
    }

    @Override
    public void setSkinLocation(ResourceLocation skinLocation) {
        this.skinLocation = skinLocation;
    }

    @Override
    public void startUpdatingSkin() {
        this.updatingSkin = true;
    }

    @Override
    public void stopUpdatingSkin() {
        this.updatingSkin = false;
    }

    @Override
    public boolean hasSlimSkin() {
        return this.slimSkin;
    }

    @Override
    public void setSlimSkin(boolean slimSkin) {
        this.slimSkin = slimSkin;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.gameProfile != null) {
            compound.m_128365_(OWNER_PROFILE_TAG, (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)this.gameProfile));
        }
        if (this.dollId != null) {
            compound.m_128362_(DOLL_ID_TAG, this.dollId);
        }
        compound.m_128405_(XP_POINTS_TAG, this.experiencePoints);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setGameProfile(compound.m_128441_(OWNER_PROFILE_TAG) ? NbtUtils.m_129228_((CompoundTag)compound.m_128469_(OWNER_PROFILE_TAG)) : null);
        if (compound.m_128441_(DOLL_ID_TAG)) {
            this.dollId = compound.m_128342_(DOLL_ID_TAG);
        }
        this.experiencePoints = compound.m_128451_(XP_POINTS_TAG);
    }

    private static class MoveCloserToTargetGoal
    extends Goal {
        private static final int HALF_PANIC_DISTANCE = 10;
        private final DollMiniMeEntity mob;
        private int ticksUntilNextPathRecalculation;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;

        public MoveCloserToTargetGoal(DollMiniMeEntity mob) {
            this.mob = mob;
        }

        public boolean m_8036_() {
            LivingEntity target = this.mob.m_5448_();
            return target != null && !this.mob.isTargetLookingAtMe() && this.mob.m_20280_((Entity)this.mob.m_5448_()) > 100.0;
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            if (target != null) {
                this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                double d0 = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                if (this.mob.m_21574_().m_148306_((Entity)target) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || target.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_21187_().nextFloat() < 0.05f)) {
                    this.pathedTargetX = target.m_20185_();
                    this.pathedTargetY = target.m_20186_();
                    this.pathedTargetZ = target.m_20189_();
                    this.ticksUntilNextPathRecalculation = 4 + this.mob.m_21187_().nextInt(7);
                    if (d0 > 1024.0) {
                        this.ticksUntilNextPathRecalculation += 10;
                    } else if (d0 > 256.0) {
                        this.ticksUntilNextPathRecalculation += 5;
                    }
                    if (!this.mob.m_21573_().m_5624_((Entity)target, 1.0)) {
                        this.ticksUntilNextPathRecalculation += 15;
                    }
                    this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
                }
            }
        }

        public void m_8056_() {
            this.ticksUntilNextPathRecalculation = 0;
            Path path = this.mob.m_21573_().m_6570_((Entity)this.mob.m_5448_(), 0);
            this.mob.m_21573_().m_26536_(path, 1.0);
        }

        public void m_8041_() {
            this.mob.m_21573_().m_26573_();
        }
    }

    private static class DollMiniMePanicGoal
    extends PanicGoal {
        private final DollMiniMeEntity miniMe;

        public DollMiniMePanicGoal(DollMiniMeEntity miniMe, double speedModifier) {
            super((PathfinderMob)miniMe, speedModifier);
            this.miniMe = miniMe;
        }

        protected boolean m_202729_() {
            LivingEntity target = this.f_25684_.m_5448_();
            return target != null && this.f_25684_.m_20280_((Entity)this.f_25684_.m_5448_()) < 400.0 && this.miniMe.isTargetLookingAtMe();
        }

        protected boolean m_25702_() {
            Vec3 vec3 = DefaultRandomPos.m_148407_((PathfinderMob)this.f_25684_, (int)5, (int)4, (Vec3)this.f_25684_.m_5448_().m_20318_(0.0f));
            if (vec3 == null) {
                return false;
            }
            this.f_25686_ = vec3.f_82479_;
            this.f_25687_ = vec3.f_82480_;
            this.f_25688_ = vec3.f_82481_;
            return true;
        }
    }

    private static class DollMiniMeMeleeAttackGoal
    extends MeleeAttackGoal {
        private final DollMiniMeEntity dollMiniMe;

        public DollMiniMeMeleeAttackGoal(DollMiniMeEntity mob) {
            super((PathfinderMob)mob, 1.0, true);
            this.dollMiniMe = mob;
        }

        public boolean m_8036_() {
            LivingEntity target = this.dollMiniMe.m_5448_();
            return target != null && this.dollMiniMe.isOutOfCoolDownTime() && (!this.dollMiniMe.isTargetLookingAtMe() || this.m_6639_(target) > this.dollMiniMe.m_20280_((Entity)target)) && super.m_8036_();
        }

        public boolean m_8045_() {
            LivingEntity target = this.dollMiniMe.m_5448_();
            return target != null && this.dollMiniMe.isOutOfCoolDownTime() && (!this.dollMiniMe.isTargetLookingAtMe() || this.m_6639_(target) > this.dollMiniMe.m_20280_((Entity)target)) && super.m_8045_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 2.0 * super.m_6639_(attackTarget);
        }
    }
}

