/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import com.mojang.authlib.GameProfile;
import iskallia.vault.client.ClientEternalData;
import iskallia.vault.entity.IPlayerSkinHolder;
import iskallia.vault.entity.eternal.EternalDataSnapshot;
import iskallia.vault.util.SkinProfile;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EternalSpiritEntity
extends Mob
implements IPlayerSkinHolder {
    private static final String OWNER_PROFILE_TAG = "ownerProfile";
    private GameProfile gameProfile = null;
    private UUID eternalUUID;
    private UUID ownerUUID;
    private long yeetCooldown;
    private ResourceLocation skinLocation = null;
    private final SkinProfile skinProfile = new SkinProfile();
    private boolean updatingSkin = false;
    private boolean slimSkin = false;
    private static final EntityDataAccessor<Optional<UUID>> DATA_ID_ETERNAL_UUID = SynchedEntityData.m_135353_(EternalSpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_ID_OWNER_UUID = SynchedEntityData.m_135353_(EternalSpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public EternalSpiritEntity(EntityType<EternalSpiritEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_ETERNAL_UUID, Optional.empty());
        this.f_19804_.m_135372_(DATA_ID_OWNER_UUID, Optional.empty());
    }

    public void m_6043_() {
    }

    public boolean m_6573_(Player pPlayer) {
        return false;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand pHand) {
        if (player.m_20197_().isEmpty() && this.putInPlayersHand(player)) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, pHand);
    }

    public boolean putInPlayersHand(Player player) {
        if (this.getOwnerUUID() != null && !this.getOwnerUUID().equals(player.m_142081_())) {
            return false;
        }
        if (!player.m_21206_().m_41619_()) {
            player.m_5661_((Component)new TextComponent("You can't pick me up with that in offhand"), true);
            return false;
        }
        if (this.m_20329_((Entity)player)) {
            this.m_20124_(Pose.SLEEPING);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSetPassengersPacket((Entity)player));
            }
            this.yeetCooldown = player.f_19853_.m_46467_() + 20L;
            return true;
        }
        return false;
    }

    public boolean m_7998_(Entity pEntity, boolean pForce) {
        boolean ret = super.m_7998_(pEntity, pForce);
        if (this.m_20159_()) {
            this.m_20124_(Pose.SLEEPING);
        }
        return ret;
    }

    public void m_8119_() {
        Vec3 movement;
        super.m_8119_();
        if (this.f_19853_.m_5776_()) {
            EternalDataSnapshot snapshot;
            if (this.skinProfile.isEmpty() && (snapshot = ClientEternalData.getSnapshot(this.getEternalUUID())) != null) {
                this.skinProfile.updateSkin(snapshot.getName());
            }
            return;
        }
        Entity vehicle = this.m_20202_();
        if (vehicle != null) {
            Player player;
            if (this.yeetCooldown > this.f_19853_.m_46467_()) {
                return;
            }
            if (vehicle instanceof Player && !(player = (Player)vehicle).m_21206_().m_41619_()) {
                this.m_8127_();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSetPassengersPacket(vehicle));
                }
                float motionAngle = vehicle.m_6080_() + 90.0f;
                float x = Mth.m_14089_((float)(motionAngle * ((float)Math.PI / 180)));
                float z = Mth.m_14031_((float)(motionAngle * ((float)Math.PI / 180)));
                this.m_146884_(this.m_20318_(0.0f).m_82520_((double)x, 0.0, (double)z));
                player.m_5661_((Component)new TextComponent("You can't hold me with that in offhand"), true);
            } else if (vehicle.m_6047_()) {
                this.m_8127_();
                if (vehicle instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)vehicle;
                    serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSetPassengersPacket(vehicle));
                }
                this.m_146884_(this.m_20318_(0.0f).m_82520_(0.0, 1.0, 0.0));
                float motionAngle = vehicle.m_6080_() + 90.0f;
                float x = Mth.m_14089_((float)(motionAngle * ((float)Math.PI / 180)));
                float z = Mth.m_14031_((float)(motionAngle * ((float)Math.PI / 180)));
                Vec3 vehicleMotion = vehicle.m_20184_();
                this.m_20256_(new Vec3((double)x + vehicleMotion.m_7096_() * 10.0, 0.1, (double)z + vehicleMotion.m_7094_() * 10.0));
            }
        } else if (this.m_20089_() == Pose.SLEEPING && Math.abs((movement = this.m_20184_()).m_7096_()) + Math.abs(movement.m_7094_()) < 0.2) {
            this.m_20124_(Pose.STANDING);
        }
    }

    public void setEternalUUID(UUID eternalUUID) {
        this.f_19804_.m_135381_(DATA_ID_ETERNAL_UUID, Optional.ofNullable(eternalUUID));
        this.eternalUUID = eternalUUID;
    }

    public void setOwnerUUID(UUID ownerUUID) {
        this.f_19804_.m_135381_(DATA_ID_OWNER_UUID, Optional.ofNullable(ownerUUID));
        this.ownerUUID = ownerUUID;
    }

    public UUID getEternalUUID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_ID_ETERNAL_UUID)).isPresent() ? (UUID)((Optional)this.f_19804_.m_135370_(DATA_ID_ETERNAL_UUID)).get() : this.eternalUUID;
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_ID_OWNER_UUID)).isPresent() ? (UUID)((Optional)this.f_19804_.m_135370_(DATA_ID_OWNER_UUID)).get() : this.ownerUUID;
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_6673_(DamageSource pSource) {
        return true;
    }

    public Iterable<ItemStack> m_6168_() {
        return new ArrayList<ItemStack>();
    }

    public ItemStack m_6844_(EquipmentSlot pSlot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot pSlot, ItemStack pStack) {
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    @Override
    public Optional<GameProfile> getGameProfile() {
        return Optional.of(this.gameProfile);
    }

    @Override
    public void setGameProfile(GameProfile gameProfile) {
        this.gameProfile = gameProfile;
    }

    @Override
    public Optional<ResourceLocation> getSkinLocation() {
        return Optional.ofNullable(this.skinProfile.getLocationSkin());
    }

    @Override
    public boolean isUpdatingSkin() {
        return this.updatingSkin;
    }

    @Override
    public void setSkinLocation(ResourceLocation skinLocation) {
        this.skinLocation = skinLocation;
    }

    @Override
    public void startUpdatingSkin() {
        this.updatingSkin = true;
    }

    @Override
    public void stopUpdatingSkin() {
        this.updatingSkin = false;
    }

    @Override
    public boolean hasSlimSkin() {
        return this.slimSkin;
    }

    @Override
    public void setSlimSkin(boolean slimSkin) {
        this.slimSkin = slimSkin;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.gameProfile != null) {
            compound.m_128365_(OWNER_PROFILE_TAG, (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)this.gameProfile));
        }
        if (this.eternalUUID != null) {
            compound.m_128362_("eternalUUID", this.eternalUUID);
        }
        if (this.ownerUUID != null) {
            compound.m_128362_("ownerUUID", this.ownerUUID);
        }
        if (this.m_20159_()) {
            compound.m_128379_("isBeingCarried", true);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setGameProfile(compound.m_128441_(OWNER_PROFILE_TAG) ? NbtUtils.m_129228_((CompoundTag)compound.m_128469_(OWNER_PROFILE_TAG)) : null);
        if (compound.m_128441_("eternalUUID")) {
            this.setEternalUUID(compound.m_128342_("eternalUUID"));
        }
        if (compound.m_128441_("ownerUUID")) {
            this.setOwnerUUID(compound.m_128342_("ownerUUID"));
        }
        if (compound.m_128471_("isBeingCarried")) {
            this.m_20124_(Pose.SLEEPING);
        }
    }
}

