/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import iskallia.vault.client.util.ColorizationHelper;
import iskallia.vault.client.util.color.ColorUtil;
import iskallia.vault.init.ModEntities;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class FloatingItemEntity
extends ItemEntity {
    private static final EntityDataAccessor<Integer> COLOR1 = SynchedEntityData.m_135353_(FloatingItemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COLOR2 = SynchedEntityData.m_135353_(FloatingItemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DROPPING_PARTICLES = SynchedEntityData.m_135353_(FloatingItemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public FloatingItemEntity(EntityType<? extends ItemEntity> type, Level world) {
        super(type, world);
        this.m_20049_("PreventMagnetMovement");
    }

    public FloatingItemEntity(Level worldIn, double x, double y, double z) {
        this(ModEntities.FLOATING_ITEM, worldIn);
        this.m_6034_(x, y, z);
        this.m_146922_(this.f_19796_.nextFloat() * 360.0f);
        this.m_20334_(this.f_19796_.nextDouble() * 0.2 - 0.1, 0.2, this.f_19796_.nextDouble() * 0.2 - 0.1);
    }

    public FloatingItemEntity(Level worldIn, double x, double y, double z, ItemStack stack) {
        this(worldIn, x, y, z);
        this.m_32045_(stack);
        this.lifespan = Integer.MAX_VALUE;
    }

    public static FloatingItemEntity create(Level world, BlockPos pos, ItemStack stack) {
        return new FloatingItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(COLOR1, (Object)0xFFFFFF);
        this.m_20088_().m_135372_(COLOR2, (Object)0xFFFFFF);
        this.f_19804_.m_135372_(DROPPING_PARTICLES, (Object)false);
    }

    public FloatingItemEntity setColor(int color) {
        this.setColor(color, color);
        return this;
    }

    public FloatingItemEntity setColor(int color1, int color2) {
        this.f_19804_.m_135381_(COLOR1, (Object)color1);
        this.f_19804_.m_135381_(COLOR2, (Object)color2);
        return this;
    }

    public void m_8119_() {
        this.m_20256_(Vec3.f_82478_);
        super.m_8119_();
        if (this.m_6084_() && this.m_20193_().m_5776_()) {
            this.playEffects();
        }
    }

    public void m_6478_(MoverType type, Vec3 velocity) {
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playEffects() {
        if (this.f_19853_.f_46443_) {
            int color1 = (Integer)this.f_19804_.m_135370_(COLOR1);
            int color2 = (Integer)this.f_19804_.m_135370_(COLOR2);
            boolean droppingParticles = (Boolean)this.f_19804_.m_135370_(DROPPING_PARTICLES);
            if (droppingParticles) {
                this.spawnDroppingParticles(color1, color2);
            } else {
                this.spawnSurroundingParticles(color1, color2);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnSurroundingParticles(int color1, int color2) {
        SimpleAnimatedParticle p;
        ParticleEngine mgr = Minecraft.m_91087_().f_91061_;
        Vec3 thisPos = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 4.0f), 0.0);
        if (color1 == 0xFFFFFF && color2 == 0xFFFFFF) {
            color1 = ColorizationHelper.getColor(this.m_32055_()).map(Color::getRGB).orElse(0xFFFFFF);
            this.f_19804_.m_135381_(COLOR1, (Object)color1);
            int r = Math.min((color1 >> 16 & 0xFF) * 2, 255);
            int g = Math.min((color1 >> 8 & 0xFF) * 2, 255);
            int b = Math.min((color1 >> 0 & 0xFF) * 2, 255);
            color2 = r << 16 | g << 8 | b;
            this.f_19804_.m_135381_(COLOR2, (Object)color2);
        }
        if (this.f_19796_.nextInt(3) == 0) {
            Vec3 rPos = thisPos.m_82520_((double)((this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * (this.f_19796_.nextFloat() * 8.0f)), (double)((this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * (this.f_19796_.nextFloat() * 8.0f)), (double)((this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * (this.f_19796_.nextFloat() * 8.0f)));
            SimpleAnimatedParticle p2 = (SimpleAnimatedParticle)mgr.m_107370_((ParticleOptions)ParticleTypes.f_123815_, rPos.f_82479_, rPos.f_82480_, rPos.f_82481_, 0.0, 0.0, 0.0);
            if (p2 != null) {
                p2.m_107657_(ColorUtil.blendColors(color1, color2, this.f_19796_.nextFloat()));
            }
        }
        if (this.f_19796_.nextBoolean() && (p = (SimpleAnimatedParticle)mgr.m_107370_((ParticleOptions)ParticleTypes.f_123815_, thisPos.f_82479_, thisPos.f_82480_, thisPos.f_82481_, (double)(this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2, (double)(this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2, (double)(this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2)) != null) {
            p.m_107657_(ColorUtil.blendColors(color1, color2, this.f_19796_.nextFloat()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnDroppingParticles(int color1, int color2) {
        Random random = this.f_19853_.f_46441_;
        ParticleEngine mgr = Minecraft.m_91087_().f_91061_;
        double x = this.m_20185_();
        double y = this.m_20186_() + 0.3;
        double z = this.m_20189_();
        for (int i = 0; i < 1; ++i) {
            double offsetX = random.nextGaussian() * 0.1;
            double offsetZ = random.nextGaussian() * 0.1;
            if (random.nextInt(5) != 0) {
                return;
            }
            SimpleAnimatedParticle particle = (SimpleAnimatedParticle)mgr.m_107370_((ParticleOptions)ParticleTypes.f_123815_, x + offsetX, y, z + offsetZ, 0.0, 0.0, 0.0);
            if (particle == null) continue;
            particle.m_107657_(ColorUtil.blendColors(color1, color2, random.nextFloat()));
        }
    }

    public void m_6123_(Player player) {
        boolean wasAlive = this.m_6084_();
        super.m_6123_(player);
        if (wasAlive && !this.m_6084_()) {
            player.m_20193_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12210_, SoundSource.PLAYERS, 0.6f, 1.0f);
        }
    }

    public boolean m_20068_() {
        return true;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public FloatingItemEntity setDroppingParticles(boolean droppingParticles) {
        this.f_19804_.m_135381_(DROPPING_PARTICLES, (Object)droppingParticles);
        return this;
    }

    public boolean isDroppingParticles() {
        return (Boolean)this.f_19804_.m_135370_(DROPPING_PARTICLES);
    }
}

