/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import iskallia.vault.init.ModAttributes;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.ClientboundHealSpellParticleMessage;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class HealerEntity
extends AbstractIllager {
    private static final EntityDataAccessor<Boolean> IS_SPELLCASTING = SynchedEntityData.m_135353_(SpellcasterIllager.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int spellCastingTickCount;

    public HealerEntity(EntityType<? extends AbstractIllager> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22277_, 18.0).m_22268_(Attributes.f_22276_, 32.0).m_22268_(ModAttributes.HEAL_RANGE, 15.0).m_22268_(ModAttributes.HEAL_AMOUNT, 6.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new HealerSpellGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new FollowHurtMonsterGoal((Mob)this, 1.0, 5.0f, 25.0f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_SPELLCASTING, (Object)false);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.spellCastingTickCount = nbt.m_128451_("SpellTicks");
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.isCastingSpell()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        return this.m_37888_() ? AbstractIllager.IllagerArmPose.CELEBRATING : AbstractIllager.IllagerArmPose.CROSSED;
    }

    public boolean isCastingSpell() {
        if (this.f_19853_.f_46443_) {
            return (Boolean)this.f_19804_.m_135370_(IS_SPELLCASTING);
        }
        return this.spellCastingTickCount > 0;
    }

    public void startCastingSpell() {
        this.f_19804_.m_135381_(IS_SPELLCASTING, (Object)true);
    }

    public void stopCastingSpell() {
        this.f_19804_.m_135381_(IS_SPELLCASTING, (Object)false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_ && this.isCastingSpell()) {
            double red = 0.625;
            double green = 0.0;
            double blue = 0.0;
            float f = this.f_20883_ * ((float)Math.PI / 180) + Mth.m_14089_((float)((float)this.f_19797_ * 0.6662f)) * 0.25f;
            float f1 = Mth.m_14089_((float)f);
            float f2 = Mth.m_14031_((float)f);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() + (double)f2 * 0.6, red, green, blue);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() - (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() - (double)f2 * 0.6, red, green, blue);
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.spellCastingTickCount > 0) {
            --this.spellCastingTickCount;
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("SpellTicks", this.spellCastingTickCount);
    }

    private SoundEvent getCastingSoundEvent() {
        return ModSounds.HEAL;
    }

    public void m_7895_(int raidWave, boolean iDontSeemToBeUsedForAnything) {
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_12048_;
    }

    private class HealerSpellGoal
    extends Goal {
        public static final int CASTING_TIME = 100;
        public static final int CASTING_INTERVAL = 120;
        private final HealerEntity healerEntity;
        protected int healWarmupDelay;
        protected int nextAttackTickCount;

        public HealerSpellGoal(HealerEntity healerEntity2) {
            this.healerEntity = healerEntity2;
        }

        public boolean m_8036_() {
            if (HealerEntity.this.isCastingSpell() || this.getEntitiesToHeal().isEmpty()) {
                return false;
            }
            return HealerEntity.this.f_19797_ >= this.nextAttackTickCount;
        }

        public boolean m_8045_() {
            return this.healWarmupDelay > 0;
        }

        public void m_8056_() {
            this.healWarmupDelay = this.m_183277_(this.getCastWarmupTime());
            HealerEntity.this.spellCastingTickCount = this.getCastingTime();
            this.nextAttackTickCount = HealerEntity.this.f_19797_ + this.getCastingInterval();
            SoundEvent soundevent = this.getSpellPrepareSound();
            if (soundevent != null) {
                HealerEntity.this.m_5496_(soundevent, 1.0f, 1.0f);
            }
            HealerEntity.this.startCastingSpell();
        }

        public void m_8041_() {
            HealerEntity.this.stopCastingSpell();
        }

        public void m_8037_() {
            --this.healWarmupDelay;
            if (this.healWarmupDelay == 0) {
                this.performSpellCasting();
                HealerEntity.this.m_5496_(HealerEntity.this.getCastingSoundEvent(), 0.5f, 0.6f + HealerEntity.this.f_19853_.f_46441_.nextFloat(0.2f));
            }
        }

        protected void performSpellCasting() {
            List<Monster> entitiesToHeal = this.getEntitiesToHeal();
            entitiesToHeal.forEach(entity -> entity.m_5634_((float)this.healerEntity.m_21133_(ModAttributes.HEAL_AMOUNT)));
            ClientboundHealSpellParticleMessage message = new ClientboundHealSpellParticleMessage(this.healerEntity.m_20185_(), this.healerEntity.m_20186_() + 1.0, this.healerEntity.m_20189_(), entitiesToHeal.stream().map(Entity::m_142049_).toList());
            ModNetwork.CHANNEL.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.healerEntity.m_20185_(), this.healerEntity.m_20186_(), this.healerEntity.m_20189_(), 64.0, HealerEntity.this.f_19853_.m_46472_())), (Object)message);
        }

        private List<Monster> getEntitiesToHeal() {
            return this.healerEntity.m_183503_().m_6249_((Entity)this.healerEntity, this.healerEntity.m_142469_().m_82400_(this.healerEntity.m_21133_(ModAttributes.HEAL_RANGE)), Monster.class::isInstance).stream().map(Monster.class::cast).filter(e -> e.m_21223_() < e.m_21233_()).toList();
        }

        protected int getCastWarmupTime() {
            return 20;
        }

        protected int getCastingTime() {
            return 100;
        }

        protected int getCastingInterval() {
            return 120;
        }

        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_12054_;
        }
    }

    private class FollowHurtMonsterGoal
    extends FollowMobGoal {
        public FollowHurtMonsterGoal(Mob pMob, double pSpeedModifier, float pStopDistance, float pAreaSize) {
            super(pMob, pSpeedModifier, pStopDistance, pAreaSize);
            this.f_25262_ = mob -> mob instanceof Monster && mob.m_21223_() < mob.m_21233_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.f_25263_.m_21223_() < this.f_25263_.m_21233_();
        }
    }
}

