/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.init.ModEntities;
import iskallia.vault.init.ModParticles;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class IceBoltEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> MODEL = SynchedEntityData.m_135353_(IceBoltEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ALLOW_PVP = SynchedEntityData.m_135353_(IceBoltEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final Consumer<HitResult> onHit;
    private Vec3 velocity;
    private boolean allowLuckyHit;

    public IceBoltEntity(EntityType<? extends AbstractArrow> type, Level world) {
        super(type, world);
        this.onHit = result -> {};
        this.initialize();
    }

    public IceBoltEntity(LivingEntity thrower, Model model, Consumer<HitResult> onHit) {
        super(ModEntities.ICE_BOLT, thrower, thrower.m_183503_());
        this.setModel(model);
        this.onHit = onHit;
        this.initialize();
    }

    public void m_37251_(Entity projectile, float x, float y, float z, float velocity, float inaccuracy) {
        super.m_37251_(projectile, x, y, z, velocity, inaccuracy);
        this.velocity = this.m_20184_();
    }

    private void initialize() {
        this.velocity = Vec3.f_82478_;
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
        this.m_20242_(true);
        this.m_36781_(0.0);
    }

    public Model getModel() {
        int index = (Integer)this.f_19804_.m_135370_(MODEL);
        return index >= 0 && index < Model.values().length ? Model.values()[index] : null;
    }

    public void setModel(Model model) {
        this.f_19804_.m_135381_(MODEL, (Object)model.ordinal());
    }

    public void setAllowLuckyHit(boolean allow) {
        this.allowLuckyHit = allow;
    }

    public boolean allowLuckyHit() {
        return this.allowLuckyHit;
    }

    public void setAllowPvP(boolean allow) {
        this.f_19804_.m_135381_(ALLOW_PVP, (Object)allow);
    }

    public boolean allowsPvP() {
        return (Boolean)this.f_19804_.m_135370_(ALLOW_PVP);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MODEL, (Object)-1);
        this.f_19804_.m_135372_(ALLOW_PVP, (Object)false);
    }

    public byte m_36796_() {
        return super.m_36796_();
    }

    public void m_8119_() {
        if (this.f_19853_.m_5776_() && !this.f_36703_ && this.f_19797_ > 2) {
            ParticleEngine engine = Minecraft.m_91087_().f_91061_;
            for (int i = 0; i < 4; ++i) {
                Particle particle = engine.m_107370_((ParticleOptions)ModParticles.ENDER_ANCHOR.get(), this.m_20182_().f_82479_ + this.m_20184_().f_82479_ / (double)i, this.m_20182_().f_82480_ + this.m_20184_().f_82480_ / (double)i, this.m_20182_().f_82481_ + this.m_20184_().f_82481_ / (double)i, 0.0, 0.0, 0.0);
                if (particle == null) continue;
                if (this.f_19796_.nextBoolean()) {
                    particle.m_107253_(0.6f, 0.7f, 0.9f);
                    particle.m_6569_(1.0f);
                    continue;
                }
                particle.m_107253_(0.7f, 0.8f, 1.0f);
                particle.m_6569_(0.45f);
            }
        }
        super.m_8119_();
        this.m_6901_();
    }

    protected void m_6532_(@NotNull HitResult result) {
        Runnable run = () -> {
            super.m_6532_(result);
            if (this.f_19853_.m_5776_()) {
                ParticleEngine engine = Minecraft.m_91087_().f_91061_;
                for (int i = 0; i < 12; ++i) {
                    Particle particle = engine.m_107370_((ParticleOptions)ModParticles.ENDER_ANCHOR.get(), this.m_20182_().f_82479_ + this.m_20184_().f_82479_ / (double)i, this.m_20182_().f_82480_ + this.m_20184_().f_82480_ / (double)i, this.m_20182_().f_82481_ + this.m_20184_().f_82481_ / (double)i, 0.0, 0.0, 0.0);
                    if (particle == null) continue;
                    if (this.f_19796_.nextBoolean()) {
                        particle.m_107253_(0.6f, 0.7f, 0.9f);
                        particle.m_6569_(1.5f);
                        continue;
                    }
                    particle.m_107253_(0.7f, 0.8f, 1.0f);
                    particle.m_6569_(0.7f);
                }
            }
            this.onHit.accept(result);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        };
        if (this.allowLuckyHit) {
            run.run();
        } else {
            ActiveFlags.IS_AOE_ATTACKING.runIfNotSet(run);
        }
    }

    protected boolean m_5603_(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        boolean ownerIsPlayer = this.m_37282_() instanceof Player;
        boolean targetIsPlayer = entity instanceof Player;
        boolean allowPlayers = this.allowsPvP();
        if (ownerIsPlayer && targetIsPlayer && !allowPlayers) {
            return false;
        }
        if (ownerIsPlayer && entity instanceof EternalEntity) {
            return false;
        }
        return super.m_5603_(entity);
    }

    protected void m_20157_() {
    }

    public boolean m_6072_() {
        return false;
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_11983_;
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("x", this.velocity.f_82479_);
        tag.m_128347_("y", this.velocity.f_82480_);
        tag.m_128347_("z", this.velocity.f_82481_);
        nbt.m_128365_("velocity", (Tag)tag);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        CompoundTag tag = nbt.m_128469_("velocity");
        this.velocity = new Vec3(tag.m_128459_("x"), tag.m_128459_("y"), tag.m_128459_("z"));
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }

    public static enum Model {
        ARROW,
        CHUNK;

    }
}

