/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import iskallia.vault.event.ActiveFlags;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModEntities;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModParticles;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.StunnedParticleMessage;
import iskallia.vault.skill.ability.effect.LightningOrbsAbility;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.talent.type.LightningDamageTalent;
import iskallia.vault.skill.talent.type.LightningStunTalent;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.util.calc.AbilityPowerHelper;
import iskallia.vault.world.data.PlayerTalentsData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;

public class LightningOrbEntity
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<Float> DAMAGE_MIN = SynchedEntityData.m_135353_(LightningOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DAMAGE_MAX = SynchedEntityData.m_135353_(LightningOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SPEED = SynchedEntityData.m_135353_(LightningOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> CHAIN_RANGE = SynchedEntityData.m_135353_(LightningOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(LightningOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DURATION = SynchedEntityData.m_135353_(LightningOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AGE = SynchedEntityData.m_135353_(LightningOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> SHOOTER_UUID = SynchedEntityData.m_135353_(LightningOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private Vec3 direction;
    private Player cachedShooter;
    private final Set<Integer> hitEntities = new HashSet<Integer>();
    private final Map<Integer, Integer> hitCooldowns = new HashMap<Integer, Integer>();
    private static final int HIT_COOLDOWN_TICKS = 20;

    public LightningOrbEntity(EntityType<? extends LightningOrbEntity> type, Level level) {
        super(type, level);
        this.direction = Vec3.f_82478_;
        this.m_20242_(true);
    }

    public LightningOrbEntity(Level level, ServerPlayer shooter, LightningOrbsAbility ability) {
        super(ModEntities.LIGHTNING_ORB, (LivingEntity)shooter, level);
        Vec3 eyePos = shooter.m_146892_();
        Vec3 look = shooter.m_20154_();
        Vec3 crosshair = eyePos.m_82549_(look.m_82541_().m_82490_(1.0));
        this.m_146884_(crosshair);
        this.m_20256_(look.m_82490_((double)ability.getOrbSpeed()));
        this.direction = shooter.m_20154_();
        this.m_20242_(true);
        this.f_19804_.m_135381_(DAMAGE_MIN, (Object)Float.valueOf(ability.getRandomDamagePercent(shooter)));
        this.f_19804_.m_135381_(DAMAGE_MAX, (Object)Float.valueOf(ability.getRandomDamagePercent(shooter)));
        this.f_19804_.m_135381_(SPEED, (Object)Float.valueOf(ability.getOrbSpeed()));
        this.f_19804_.m_135381_(CHAIN_RANGE, (Object)Float.valueOf(ability.getChainRange()));
        this.f_19804_.m_135381_(RADIUS, (Object)Float.valueOf(ability.getHitRadius()));
        this.f_19804_.m_135381_(DURATION, (Object)ability.getDurationTicks((LivingEntity)shooter));
        this.f_19804_.m_135381_(AGE, (Object)0);
        this.f_19804_.m_135381_(SHOOTER_UUID, Optional.of(shooter.m_142081_()));
        this.cachedShooter = shooter;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DAMAGE_MIN, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DAMAGE_MAX, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SPEED, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(CHAIN_RANGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(RADIUS, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(DURATION, (Object)0);
        this.f_19804_.m_135372_(AGE, (Object)0);
        this.f_19804_.m_135372_(SHOOTER_UUID, Optional.empty());
    }

    private Player getShooter() {
        if (this.cachedShooter != null && !this.cachedShooter.m_146910_()) {
            return this.cachedShooter;
        }
        this.cachedShooter = ((Optional)this.f_19804_.m_135370_(SHOOTER_UUID)).map(arg_0 -> ((Level)this.f_19853_).m_46003_(arg_0)).orElse(null);
        return this.cachedShooter;
    }

    protected void m_6532_(HitResult result) {
        EntityHitResult ehr;
        Entity entity;
        if (!this.f_19853_.f_46443_ && result instanceof EntityHitResult && (entity = (ehr = (EntityHitResult)result).m_82443_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living == this.m_37282_()) {
                return;
            }
            int id = living.m_142049_();
            int cooldown = this.hitCooldowns.getOrDefault(id, 0);
            if (cooldown <= 0) {
                Player player = this.getShooter();
                if (player != null) {
                    float abilityPower = AbilityPowerHelper.getAbilityPower(player);
                    float damage = abilityPower * this.getModifiedLightningDamage(player, Mth.m_14068_((Random)player.m_21187_(), (float)((Float)this.f_19804_.m_135370_(DAMAGE_MIN)).floatValue(), (float)((Float)this.f_19804_.m_135370_(DAMAGE_MAX)).floatValue()));
                    this.applyLightningDamage(living, damage, player);
                    Entity bolt = ModEntities.SMITE_ABILITY_BOLT.m_20615_(living.f_19853_);
                    if (bolt != null) {
                        bolt.m_20219_(living.m_20182_());
                        living.f_19853_.m_7967_(bolt);
                    }
                    living.f_19853_.m_6269_(null, (Entity)living, ModSounds.LIGHTING_BOLT, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                this.hitCooldowns.put(id, 20);
            }
        }
    }

    private float getModifiedLightningDamage(Player player, float baseDamage) {
        float additional = 0.0f;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TalentTree talents = PlayerTalentsData.get(serverPlayer.m_183503_()).getTalents(player);
            for (LightningDamageTalent talent : talents.getAll(LightningDamageTalent.class, Skill::isUnlocked)) {
                additional += talent.getIncreasedDamageDealtPercentage();
            }
        }
        return baseDamage * (1.0f + additional);
    }

    private void applyLightningDamage(LivingEntity target, float damage, Player player) {
        ActiveFlags.IS_AP_ATTACKING.runIfNotSet(() -> ActiveFlags.IS_AOE_ATTACKING.runIfNotSet(() -> target.m_6469_(DamageSource.m_19344_((Player)player), damage)));
        Entity bolt = ModEntities.SMITE_ABILITY_BOLT.m_20615_(target.f_19853_);
        if (bolt != null) {
            bolt.m_20219_(target.m_20182_());
            target.f_19853_.m_7967_(bolt);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TalentTree talents = PlayerTalentsData.get(serverPlayer.m_183503_()).getTalents(player);
            for (LightningStunTalent talent : talents.getAll(LightningStunTalent.class, Skill::isUnlocked)) {
                if (!(player.f_19853_.f_46441_.nextFloat() < talent.getStunChance())) continue;
                target.m_7292_(new MobEffectInstance(ModEffects.NO_AI, (int)(talent.getStunDuration() * 20.0f), 0, false, false, true){

                    public boolean m_19552_(LivingEntity livingEntity, Runnable p_19554_) {
                        if (!livingEntity.m_21224_()) {
                            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new StunnedParticleMessage(new Vec3(livingEntity.m_20185_(), livingEntity.m_20186_() + (double)livingEntity.m_20206_(), livingEntity.m_20189_()), livingEntity.m_20205_()));
                        }
                        return super.m_19552_(livingEntity, p_19554_);
                    }
                });
            }
        }
    }

    public void m_8119_() {
        Player shooter = this.getShooter();
        if (shooter == null || !shooter.m_6084_()) {
            this.m_146870_();
            return;
        }
        int age = (Integer)this.f_19804_.m_135370_(AGE) + 1;
        this.f_19804_.m_135381_(AGE, (Object)age);
        if (age > (Integer)this.f_19804_.m_135370_(DURATION)) {
            this.m_146870_();
            return;
        }
        this.direction = shooter.m_20154_();
        this.m_20256_(this.direction.m_82541_().m_82490_((double)((Float)this.f_19804_.m_135370_(SPEED)).floatValue()));
        super.m_8119_();
        this.hitCooldowns.replaceAll((id, cd) -> cd > 0 ? cd - 1 : 0);
        Vec3 pos = this.m_20182_();
        Vec3 particlePos = pos.m_82546_(this.direction.m_82490_(0.5));
        for (int i = 0; i < 3; ++i) {
            Vec3 offset = new Vec3(this.f_19796_.nextDouble() * 0.2 - 0.1, this.f_19796_.nextDouble() * 0.2 - 0.1, this.f_19796_.nextDouble() * 0.2 - 0.1);
            this.f_19853_.m_7106_((ParticleOptions)ModParticles.LIGHTNING_ORB.get(), particlePos.f_82479_ + offset.f_82479_, particlePos.f_82480_ + 0.25 + offset.f_82480_, particlePos.f_82481_ + offset.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    protected Item m_7881_() {
        return Items.f_41852_;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_20157_() {
    }

    public boolean m_6072_() {
        return false;
    }
}

