/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.math.Vector3f;
import iskallia.vault.client.particles.GridGatewayParticle;
import iskallia.vault.core.vault.modifier.spi.predicate.IModifierImmunity;
import iskallia.vault.core.vault.modifier.spi.predicate.ModifierPredicate;
import iskallia.vault.entity.ILandmineIgnore;
import iskallia.vault.entity.IPlayerSkinHolder;
import iskallia.vault.entity.ITotemIgnore;
import iskallia.vault.entity.ai.FollowEntityGoal;
import iskallia.vault.entity.ai.PetSleepOnBedGoal;
import iskallia.vault.entity.entity.pet.PetHelper;
import iskallia.vault.entity.entity.pet.trait.IPetTrait;
import iskallia.vault.entity.entity.pet.trait.PetTraitRegistry;
import iskallia.vault.init.ModParticles;
import iskallia.vault.integration.IntegrationCurios;
import iskallia.vault.item.CompanionItem;
import iskallia.vault.item.CompanionParticleTrailItem;
import iskallia.vault.item.CompanionPetManager;
import iskallia.vault.item.CompanionSeries;
import iskallia.vault.world.data.ServerVaults;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;
import top.theillusivec4.curios.api.CuriosApi;

public class PetEntity
extends PathfinderMob
implements IAnimatable,
IPlayerSkinHolder,
ITotemIgnore,
IModifierImmunity,
ILandmineIgnore {
    private static final EntityDataAccessor<String> PET_NAME = SynchedEntityData.m_135353_(PetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> PET_TYPE = SynchedEntityData.m_135353_(PetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> PET_SERIES = SynchedEntityData.m_135353_(PetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Optional<GameProfile>> GAME_PROFILE = SynchedEntityData.m_135353_(PetEntity.class, (EntityDataSerializer)OPTIONAL_GAME_PROFILE_SERIALIZER);
    private static final EntityDataAccessor<String> SKIN_LOCATION = SynchedEntityData.m_135353_(PetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> IS_UPDATING_SKIN = SynchedEntityData.m_135353_(PetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_SLIM_SKIN = SynchedEntityData.m_135353_(PetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> COMPANION_ID = SynchedEntityData.m_135353_(PetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<CompoundTag> VANILLA_ENTITY_DATA = SynchedEntityData.m_135353_(PetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<Boolean> IS_SLEEPING = SynchedEntityData.m_135353_(PetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> COMPANION_LEVEL = SynchedEntityData.m_135353_(PetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<CompoundTag> PARTICLE_COLOURS = SynchedEntityData.m_135353_(PetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<CompoundTag> PARTICLE_TYPES = SynchedEntityData.m_135353_(PetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<Boolean> IS_DANCING = SynchedEntityData.m_135353_(PetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private UUID ownerUUID;
    private ServerPlayer owner;
    private Entity cachedRenderEntity;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private Map<String, IPetTrait> traits = new LinkedHashMap<String, IPetTrait>();
    private static final String COLOUR_TAG = "colours";
    private static final String TYPE_TAG_NAME = "types";

    public PetEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.m_20331_(true);
        this.m_20242_(false);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "Main", 5.0f, this::mainAnimController));
        PetTraitRegistry.getAll(this).forEach(pet -> pet.registerControllers(this, data));
    }

    public boolean m_7337_(Entity pEntity) {
        return false;
    }

    public void m_5496_(SoundEvent pSound, float pVolume, float pPitch) {
    }

    private PlayState mainAnimController(AnimationEvent<PetEntity> event) {
        AnimationController controller = event.getController();
        if (controller.getCurrentAnimation() != null && this.isDancing() && !"dance".equals(controller.getCurrentAnimation().toString())) {
            controller.setAnimation(new AnimationBuilder().addAnimation("dance", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (controller.getCurrentAnimation() != null && this.m_5803_() && !"sleep".equals(controller.getCurrentAnimation().toString())) {
            controller.setAnimation(new AnimationBuilder().addAnimation("sleep", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME).addAnimation("sleepy", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (event.isMoving()) {
            controller.setAnimation(new AnimationBuilder().addAnimation("run", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            controller.setAnimation(new AnimationBuilder().addAnimation("idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PET_NAME, (Object)"");
        this.f_19804_.m_135372_(PET_TYPE, (Object)"");
        this.f_19804_.m_135372_(PET_SERIES, (Object)"");
        this.f_19804_.m_135372_(GAME_PROFILE, Optional.empty());
        this.f_19804_.m_135372_(SKIN_LOCATION, (Object)"");
        this.f_19804_.m_135372_(IS_UPDATING_SKIN, (Object)false);
        this.f_19804_.m_135372_(HAS_SLIM_SKIN, (Object)false);
        this.f_19804_.m_135372_(COMPANION_ID, (Object)"");
        this.f_19804_.m_135372_(VANILLA_ENTITY_DATA, (Object)new CompoundTag());
        this.f_19804_.m_135372_(IS_SLEEPING, (Object)false);
        this.f_19804_.m_135372_(COMPANION_LEVEL, (Object)1);
        this.f_19804_.m_135372_(PARTICLE_COLOURS, (Object)new CompoundTag());
        this.f_19804_.m_135372_(PARTICLE_TYPES, (Object)new CompoundTag());
        this.f_19804_.m_135372_(IS_DANCING, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, new FollowEntityGoal(this, 2.0, 4.0f, 2.0f, false, () -> Optional.ofNullable(this.getOwner())));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f){

            public boolean m_8036_() {
                return super.m_8036_() && !PetEntity.this.m_5803_();
            }

            public boolean m_8045_() {
                return super.m_8045_() && !PetEntity.this.m_5803_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new PetSleepOnBedGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean m_8036_() {
                return super.m_8036_() && !PetEntity.this.m_5803_();
            }

            public boolean m_8045_() {
                return super.m_8045_() && !PetEntity.this.m_5803_();
            }
        });
    }

    public void setOwner(ServerPlayer owner) {
        this.owner = owner;
        this.ownerUUID = owner.m_142081_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return PathfinderMob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22277_, 16.0);
    }

    public ServerPlayer getOwner() {
        if (this.owner == null && this.ownerUUID != null && this.f_19853_.m_142572_() != null) {
            this.owner = this.f_19853_.m_142572_().m_6846_().m_11259_(this.ownerUUID);
        }
        return this.owner;
    }

    public void setCompanionData(ItemStack petStack) {
        boolean isLegend;
        String petName = CompanionItem.getPetName(petStack);
        String petType = CompanionItem.getPetType(petStack);
        CompanionSeries series = CompanionItem.getPetSeries(petStack);
        boolean bl = isLegend = series == CompanionSeries.LEGEND;
        if (petName != null) {
            this.f_19804_.m_135381_(PET_NAME, (Object)petName);
            this.m_6593_((Component)new TextComponent(petName));
            this.m_20340_(true);
        }
        if (petType != null) {
            this.f_19804_.m_135381_(PET_TYPE, (Object)petType);
        }
        if (series != null) {
            this.f_19804_.m_135381_(PET_SERIES, (Object)series.name());
        }
        this.f_19804_.m_135381_(COMPANION_ID, (Object)(CompanionItem.getPetId(petStack) == null ? "" : CompanionItem.getPetId(petStack)));
        this.f_19804_.m_135381_(COMPANION_LEVEL, (Object)CompanionItem.getCompanionLevel(petStack));
        if (isLegend && petName != null) {
            CompanionItem.getUserProfile(petStack).ifPresent(profile -> {
                UUID uuid = profile.getId();
                if (uuid != null) {
                    GameProfile gp = new GameProfile(uuid, petName);
                    this.f_19804_.m_135381_(GAME_PROFILE, Optional.of(gp));
                }
            });
        }
    }

    public String getPetName() {
        return (String)this.f_19804_.m_135370_(PET_NAME);
    }

    public String getPetType() {
        return (String)this.f_19804_.m_135370_(PET_TYPE);
    }

    public CompanionSeries getPetSeries() {
        String seriesName = (String)this.f_19804_.m_135370_(PET_SERIES);
        if (seriesName.isEmpty()) {
            return CompanionSeries.LEGEND;
        }
        try {
            return CompanionSeries.valueOf(seriesName);
        }
        catch (IllegalArgumentException e) {
            return CompanionSeries.LEGEND;
        }
    }

    public boolean isPlayerPet() {
        return this.getPetSeries() == CompanionSeries.LEGEND;
    }

    public String getCompanionId() {
        return (String)this.f_19804_.m_135370_(COMPANION_ID);
    }

    public void setPetName(String name) {
        this.f_19804_.m_135381_(PET_NAME, (Object)name);
    }

    @Override
    public Optional<GameProfile> getGameProfile() {
        return (Optional)this.f_19804_.m_135370_(GAME_PROFILE);
    }

    @Override
    public void setGameProfile(@Nullable GameProfile gameProfile) {
        this.f_19804_.m_135381_(GAME_PROFILE, Optional.ofNullable(gameProfile));
    }

    public int getCompanionLevel() {
        return (Integer)this.f_19804_.m_135370_(COMPANION_LEVEL);
    }

    public void setCompanionLevel(int level) {
        this.f_19804_.m_135381_(COMPANION_LEVEL, (Object)level);
    }

    @Override
    public Optional<ResourceLocation> getSkinLocation() {
        String skinString = (String)this.f_19804_.m_135370_(SKIN_LOCATION);
        if (skinString.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ResourceLocation(skinString));
    }

    public List<Integer> getParticleColours() {
        CompoundTag tag = (CompoundTag)this.f_19804_.m_135370_(PARTICLE_COLOURS);
        if (tag.m_128441_(COLOUR_TAG)) {
            return Arrays.stream(tag.m_128465_(COLOUR_TAG)).boxed().toList();
        }
        return Collections.emptyList();
    }

    public void setParticleColours(List<Integer> colours) {
        CompoundTag tag = new CompoundTag();
        tag.m_128385_(COLOUR_TAG, colours.stream().mapToInt(i -> i).toArray());
        this.f_19804_.m_135381_(PARTICLE_COLOURS, (Object)tag);
    }

    public List<CompanionParticleTrailItem.TrailType> getParticleTrailTypes() {
        CompoundTag tag = (CompoundTag)this.f_19804_.m_135370_(PARTICLE_TYPES);
        if (tag.m_128441_(TYPE_TAG_NAME)) {
            int[] arr = tag.m_128465_(TYPE_TAG_NAME);
            ArrayList<CompanionParticleTrailItem.TrailType> list = new ArrayList<CompanionParticleTrailItem.TrailType>();
            for (int ord : arr) {
                if (ord >= 0 && ord < CompanionParticleTrailItem.TrailType.values().length) {
                    list.add(CompanionParticleTrailItem.TrailType.values()[ord]);
                    continue;
                }
                list.add(CompanionParticleTrailItem.TrailType.DUST);
            }
            return list;
        }
        return Collections.emptyList();
    }

    public void setParticleTrailTypes(List<CompanionParticleTrailItem.TrailType> types) {
        CompoundTag tag = new CompoundTag();
        tag.m_128385_(TYPE_TAG_NAME, types.stream().mapToInt(Enum::ordinal).toArray());
        this.f_19804_.m_135381_(PARTICLE_TYPES, (Object)tag);
    }

    public int getParticleColour() {
        List<Integer> cols = this.getParticleColours();
        return cols.isEmpty() ? -1 : cols.get(0);
    }

    public void setParticleColour(int colour) {
        this.setParticleColours(List.of(Integer.valueOf(colour)));
    }

    @Override
    public void setSkinLocation(ResourceLocation skinLocation) {
        this.f_19804_.m_135381_(SKIN_LOCATION, (Object)(skinLocation != null ? skinLocation.toString() : ""));
    }

    @Override
    public boolean isUpdatingSkin() {
        return (Boolean)this.f_19804_.m_135370_(IS_UPDATING_SKIN);
    }

    @Override
    public void startUpdatingSkin() {
        this.f_19804_.m_135381_(IS_UPDATING_SKIN, (Object)true);
    }

    @Override
    public void stopUpdatingSkin() {
        this.f_19804_.m_135381_(IS_UPDATING_SKIN, (Object)false);
    }

    @Override
    public boolean hasSlimSkin() {
        return (Boolean)this.f_19804_.m_135370_(HAS_SLIM_SKIN);
    }

    @Override
    public void setSlimSkin(boolean slimSkin) {
        this.f_19804_.m_135381_(HAS_SLIM_SKIN, (Object)slimSkin);
    }

    public void setVanillaEntityData(@Nullable CompoundTag tag) {
        this.f_19804_.m_135381_(VANILLA_ENTITY_DATA, (Object)(tag == null ? new CompoundTag() : tag));
    }

    public CompoundTag getVanillaEntityData() {
        return (CompoundTag)this.f_19804_.m_135370_(VANILLA_ENTITY_DATA);
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(IS_SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.f_19804_.m_135381_(IS_SLEEPING, (Object)sleeping);
    }

    public boolean isDancing() {
        return (Boolean)this.f_19804_.m_135370_(IS_DANCING);
    }

    public void setDancing(boolean dancing) {
        this.f_19804_.m_135381_(IS_DANCING, (Object)dancing);
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack held = player.m_21120_(hand);
            if (held.m_41720_() == Items.f_42656_ && held.m_41788_()) {
                String newName = held.m_41786_().getString();
                ItemStack companionStack = this.findCompanionStack(serverPlayer);
                if (!companionStack.m_41619_()) {
                    CompanionItem.setPetName(companionStack, newName);
                    this.setPetName(newName);
                    if (CompanionItem.getPetSeries(companionStack) == CompanionSeries.LEGEND) {
                        GameProfile profile = new GameProfile(null, newName);
                        this.setGameProfile(profile);
                    }
                    held.m_41774_(1);
                    return InteractionResult.SUCCESS;
                }
                return this.m_6071_(player, hand);
            }
        }
        return super.m_7111_(player, vec, hand);
    }

    private int findCompanionSlot(ServerPlayer player, ItemStack stack) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack invStack = player.m_150109_().m_8020_(i);
            if (!(invStack.m_41720_() instanceof CompanionItem) || !ItemStack.m_41728_((ItemStack)invStack, (ItemStack)stack)) continue;
            return i;
        }
        return -1;
    }

    public ItemStack findCompanionStack(ServerPlayer player) {
        String companionId = this.getCompanionId();
        if (companionId.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return CuriosApi.getCuriosHelper().findEquippedCurio(stack -> {
            if (stack.m_41720_() instanceof CompanionItem) {
                String stackId = CompanionItem.getPetId(stack);
                return companionId.equals(stackId);
            }
            return false;
        }, (LivingEntity)player).map(pair -> (ItemStack)pair.right).orElse(ItemStack.f_41583_);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_8119_() {
        block25: {
            ServerPlayer owner;
            block24: {
                super.m_8119_();
                owner = this.getOwner();
                if (this.f_19853_.f_46443_) break block24;
                if (!(owner instanceof ServerPlayer)) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                    return;
                }
                ServerPlayer serverPlayer = owner;
                if (this.findCompanionStack(serverPlayer).m_41619_()) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                    return;
                }
                double distance = this.m_20270_((Entity)serverPlayer);
                if (serverPlayer.m_21255_()) {
                    this.m_20115_(7, true);
                    this.m_20242_(true);
                    this.m_20256_(serverPlayer.m_20184_());
                    Vec3 offset = serverPlayer.m_20154_().m_82541_().m_82490_(-1.5);
                    this.m_7678_(serverPlayer.m_20185_() + offset.f_82479_, serverPlayer.m_20186_() + offset.f_82480_, serverPlayer.m_20189_() + offset.f_82481_, serverPlayer.m_146908_(), serverPlayer.m_146909_());
                    break block25;
                } else {
                    this.m_20242_(false);
                    if (this.m_20291_(7)) {
                        this.m_20115_(7, false);
                    }
                    if (distance > 16.0) {
                        this.teleportToOwner((Player)serverPlayer);
                    }
                }
                break block25;
            }
            if (owner != null) {
                double distance = this.m_20270_((Entity)owner);
                if (owner.m_21255_()) {
                    this.m_20115_(7, true);
                    this.m_20242_(true);
                    this.m_20256_(owner.m_20184_());
                    Vec3 offset = owner.m_20154_().m_82541_().m_82490_(-1.5);
                    this.m_7678_(owner.m_20185_() + offset.f_82479_, owner.m_20186_() + offset.f_82480_, owner.m_20189_() + offset.f_82481_, owner.m_146908_(), owner.m_146909_());
                } else {
                    this.m_20242_(false);
                    if (this.m_20291_(7)) {
                        this.m_20115_(7, false);
                    }
                    if (distance > 16.0) {
                        this.teleportToOwner((Player)owner);
                    }
                }
            }
        }
        for (Map.Entry<String, IPetTrait> traits : this.traits.entrySet()) {
            traits.getValue().tick(this);
        }
        if (this.cachedRenderEntity != null) {
            this.cachedRenderEntity.m_8119_();
        }
        if (this.f_19853_.f_46443_) {
            Vec3 motion;
            if (this.f_19797_ % 2 == 0) {
                return;
            }
            List<Integer> colours = this.getParticleColours();
            List<CompanionParticleTrailItem.TrailType> types = this.getParticleTrailTypes();
            if (!colours.isEmpty() && (motion = this.m_20184_()).m_82556_() > 1.0E-4) {
                Vec3 reverseMotion = motion.m_82541_().m_82490_(-0.25);
                double trailX = this.m_20185_() + reverseMotion.f_82479_;
                double trailY = this.m_20186_() + (double)this.m_20206_() * 0.5 + reverseMotion.f_82480_;
                double trailZ = this.m_20189_() + reverseMotion.f_82481_;
                int count = Math.min(colours.size(), types.size());
                for (int idx = 0; idx < count; ++idx) {
                    int colour = colours.get(idx);
                    if (colour == -1) continue;
                    CompanionParticleTrailItem.TrailType type = idx < types.size() ? types.get(idx) : CompanionParticleTrailItem.TrailType.DUST;
                    float r = (float)(colour >> 16 & 0xFF) / 255.0f;
                    float g = (float)(colour >> 8 & 0xFF) / 255.0f;
                    float b = (float)(colour & 0xFF) / 255.0f;
                    block8: for (int i = 0; i < 1; ++i) {
                        float size = 0.25f + this.f_19796_.nextFloat() * 0.3f;
                        double offsetX = (this.f_19796_.nextDouble() - 0.5) * 0.5;
                        double offsetY = (this.f_19796_.nextDouble() - 0.5) * 0.5;
                        double offsetZ = (this.f_19796_.nextDouble() - 0.5) * 0.5;
                        switch (type) {
                            case DUST: {
                                this.f_19853_.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(r, g, b), size), trailX + offsetX, trailY + offsetY, trailZ + offsetZ, 0.0, 0.05, 0.0);
                                continue block8;
                            }
                            case SCRAPE: {
                                Particle p = Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_175831_, trailX + offsetX, trailY + offsetY, trailZ + offsetZ, 0.0, 0.01, 0.0);
                                if (p == null) continue block8;
                                p.m_107253_(r, g, b);
                                p.m_6569_(size);
                                continue block8;
                            }
                            case GRID_GATEWAY: {
                                Particle p = Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ModParticles.GRID_GATEWAY.get(), trailX + offsetX, trailY + offsetY, trailZ + offsetZ, 0.0, 0.05, 0.0);
                                if (!(p instanceof GridGatewayParticle)) continue block8;
                                GridGatewayParticle ggp = (GridGatewayParticle)p;
                                ggp.setColor(colour);
                                continue block8;
                            }
                            case HEART: {
                                this.f_19853_.m_7106_((ParticleOptions)ModParticles.HEART.get(), trailX + offsetX, trailY + offsetY, trailZ + offsetZ, (double)r, (double)g, (double)b);
                                continue block8;
                            }
                        }
                    }
                }
            }
        }
    }

    private void teleportToOwner(Player owner) {
        for (int i = 0; i < 10; ++i) {
            double x = owner.m_20185_() + (this.f_19796_.nextDouble() - 0.5) * 2.0;
            double y = owner.m_20186_();
            double z = owner.m_20189_() + (this.f_19796_.nextDouble() - 0.5) * 2.0;
            if (!this.f_19853_.m_45756_((Entity)this, this.m_142469_().m_82386_(x - this.m_20185_(), y - this.m_20186_(), z - this.m_20189_()))) continue;
            this.m_6021_(x, y, z);
            break;
        }
    }

    public void m_7380_(CompoundTag tag) {
        List<CompanionParticleTrailItem.TrailType> types;
        super.m_7380_(tag);
        if (this.ownerUUID != null) {
            tag.m_128362_("OwnerUUID", this.ownerUUID);
        }
        tag.m_128359_("PetName", this.getPetName());
        tag.m_128359_("PetType", this.getPetType());
        tag.m_128359_("PetSeries", this.getPetSeries().name());
        tag.m_128379_("HasSlimSkin", this.hasSlimSkin());
        tag.m_128359_("PetId", (String)this.f_19804_.m_135370_(COMPANION_ID));
        tag.m_128405_("PetLevel", this.getCompanionLevel());
        this.getGameProfile().ifPresent(profile -> {
            UUID id = profile.getId();
            CompoundTag profileTag = new CompoundTag();
            profileTag.m_128359_("Name", profile.getName());
            if (id != null) {
                profileTag.m_128359_("Id", id.toString());
            }
            tag.m_128365_("GameProfile", (Tag)profileTag);
        });
        tag.m_128359_("SkinLocation", this.getSkinLocation().map(ResourceLocation::toString).orElse(""));
        tag.m_128365_("VanillaData", (Tag)this.getVanillaEntityData());
        tag.m_128379_("IsDancing", this.isDancing());
        List<Integer> cols = this.getParticleColours();
        if (!cols.isEmpty()) {
            tag.m_128385_("TrailColours", cols.stream().mapToInt(i -> i).toArray());
        }
        if (!(types = this.getParticleTrailTypes()).isEmpty()) {
            tag.m_128385_("TrailTypes", types.stream().mapToInt(Enum::ordinal).toArray());
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128403_("OwnerUUID")) {
            this.ownerUUID = tag.m_128342_("OwnerUUID");
        }
        this.f_19804_.m_135381_(PET_NAME, (Object)tag.m_128461_("PetName"));
        this.f_19804_.m_135381_(PET_TYPE, (Object)tag.m_128461_("PetType"));
        this.f_19804_.m_135381_(PET_SERIES, (Object)tag.m_128461_("PetSeries"));
        this.f_19804_.m_135381_(HAS_SLIM_SKIN, (Object)tag.m_128471_("HasSlimSkin"));
        this.f_19804_.m_135381_(COMPANION_ID, (Object)tag.m_128461_("PetId"));
        this.f_19804_.m_135381_(COMPANION_LEVEL, (Object)(tag.m_128441_("PetLevel") ? tag.m_128451_("PetLevel") : 1));
        if (tag.m_128441_("GameProfile")) {
            CompoundTag profileTag = tag.m_128469_("GameProfile");
            String name = profileTag.m_128461_("Name");
            String idStr = profileTag.m_128461_("Id");
            UUID id = null;
            if (!idStr.isEmpty()) {
                try {
                    id = UUID.fromString(idStr);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            GameProfile profile = new GameProfile(id, name);
            this.f_19804_.m_135381_(GAME_PROFILE, Optional.of(profile));
        }
        this.f_19804_.m_135381_(SKIN_LOCATION, (Object)tag.m_128461_("SkinLocation"));
        if (tag.m_128441_("VanillaData")) {
            this.f_19804_.m_135381_(VANILLA_ENTITY_DATA, (Object)tag.m_128469_("VanillaData"));
        }
        this.f_19804_.m_135381_(IS_DANCING, (Object)tag.m_128471_("IsDancing"));
        if (this.traits.isEmpty()) {
            PetHelper.getVariant(this.getPetType()).ifPresent(variant -> {
                if (variant.traits() != null) {
                    variant.traits().apply(this);
                }
            });
        }
        if (tag.m_128441_("TrailColours")) {
            this.setParticleColours(Arrays.stream(tag.m_128465_("TrailColours")).boxed().toList());
        } else {
            this.f_19804_.m_135381_(PARTICLE_COLOURS, (Object)new CompoundTag());
            if (tag.m_128441_("TrailColour")) {
                this.setParticleColour(tag.m_128451_("TrailColour"));
            }
        }
        if (tag.m_128441_("TrailTypes")) {
            int[] arr = tag.m_128465_("TrailTypes");
            ArrayList<CompanionParticleTrailItem.TrailType> ts = new ArrayList<CompanionParticleTrailItem.TrailType>();
            for (int ord : arr) {
                if (ord >= 0 && ord < CompanionParticleTrailItem.TrailType.values().length) {
                    ts.add(CompanionParticleTrailItem.TrailType.values()[ord]);
                    continue;
                }
                ts.add(CompanionParticleTrailItem.TrailType.DUST);
            }
            this.setParticleTrailTypes(ts);
        } else {
            this.f_19804_.m_135381_(PARTICLE_TYPES, (Object)new CompoundTag());
        }
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    protected boolean m_6107_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public boolean m_6673_(DamageSource source) {
        return true;
    }

    public boolean m_142066_() {
        return false;
    }

    public boolean m_142065_() {
        return true;
    }

    public boolean m_21532_() {
        return true;
    }

    public boolean m_8023_() {
        return true;
    }

    public void m_6667_(DamageSource damageSource) {
    }

    public boolean m_21224_() {
        return false;
    }

    public boolean m_6162_() {
        if (this.getPetSeries() == CompanionSeries.LEGEND) {
            String type = this.getPetType();
            return "minion".equalsIgnoreCase(type) || "antlion".equalsIgnoreCase(type);
        }
        return false;
    }

    public Collection<IPetTrait> getTraits() {
        return this.traits.values();
    }

    public void addTrait(String id, IPetTrait trait) {
        if (this.traits.containsKey(id)) {
            this.traits.get(id).addStack(trait);
        } else {
            this.traits.put(id, trait);
            trait.apply(this);
        }
    }

    public void setTraits(Map<String, IPetTrait> traits) {
        this.traits = traits;
    }

    public boolean m_20147_() {
        return true;
    }

    @Override
    public boolean isTotemIgnored() {
        return true;
    }

    @Override
    public ModifierPredicate getImmunity() {
        return ModifierPredicate.TRUE;
    }

    @Override
    public void setImmunity(ModifierPredicate predicate) {
    }

    @Override
    public boolean isLandmineIgnored() {
        return true;
    }

    public boolean m_7301_(MobEffectInstance potionEffect) {
        return false;
    }

    public boolean m_147207_(MobEffectInstance effect, @Nullable Entity source) {
        return false;
    }

    public boolean m_5825_() {
        return true;
    }

    public void m_7311_(int ticks) {
        super.m_7311_(0);
    }

    public void m_20254_(int seconds) {
        super.m_20254_(0);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        String companionId;
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).m_6144_() && serverPlayer.equals((Object)this.getOwner()) && ServerVaults.get(serverPlayer.f_19853_).isEmpty() && !(companionId = this.getCompanionId()).isEmpty()) {
            CompanionItem.getCompanion((LivingEntity)player).ifPresent(companionStack -> {
                if (companionId.equals(CompanionItem.getPetId(companionStack))) {
                    IntegrationCurios.setCurioItemStack((LivingEntity)serverPlayer, ItemStack.f_41583_, "head", 0);
                    CompanionPetManager.despawnPet(serverPlayer);
                    ItemStack insert = companionStack.m_41777_();
                    if (player.m_21120_(hand).m_41619_()) {
                        player.m_21008_(hand, insert);
                    } else if (!player.m_150109_().m_36054_(insert)) {
                        player.m_36176_(insert, false);
                    }
                }
            });
        }
        return super.m_6071_(player, hand);
    }

    public void m_6818_(BlockPos pPos, boolean pIsPartying) {
        PetHelper.getVariant(this.getPetType()).ifPresent(variant -> {
            if (variant.traits() == null) {
                return;
            }
            if (variant.traits().traits().containsKey("Dance")) {
                this.setDancing(pIsPartying);
                this.setSleeping(!pIsPartying);
            }
        });
    }
}

