/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.entity.entity;

import com.mojang.authlib.GameProfile;
import iskallia.vault.VaultMod;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.sync.context.DiskSyncContext;
import iskallia.vault.core.net.ArrayBitBuffer;
import iskallia.vault.core.vault.EntityState;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.modifier.modifier.PlayerInventoryRestoreModifier;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.modifier.spi.predicate.IModifierImmunity;
import iskallia.vault.core.vault.modifier.spi.predicate.ModifierPredicate;
import iskallia.vault.core.vault.objective.RoyaleObjective;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.entity.IPlayerSkinHolder;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEntities;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.util.SidedHelper;
import iskallia.vault.world.VaultMode;
import iskallia.vault.world.data.InventorySnapshot;
import iskallia.vault.world.data.PlayerSpiritRecoveryData;
import iskallia.vault.world.data.ServerVaults;
import iskallia.vault.world.data.VaultJoinSnapshotData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.PlayerRespawnLogic;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SpiritEntity
extends Mob
implements IPlayerSkinHolder,
IModifierImmunity {
    private static final String OWNER_PROFILE_TAG = "ownerProfile";
    private static final String JOIN_STATE_TAG = "joinState";
    private static final String RECYCLABLE_TAG = "recyclable";
    private GameProfile gameProfile = null;
    @Deprecated
    private final NonNullList<ItemStack> items = NonNullList.m_122779_();
    private int vaultLevel;
    private int playerLevel;
    private boolean recyclable = false;
    private long yeetCooldown;
    private ResourceLocation skinLocation = null;
    private boolean updatingSkin = false;
    private boolean slimSkin = false;
    @Nullable
    private EntityState joinState = null;
    @Nullable
    private UUID heroId = null;
    private float rescuedBonus = 0.0f;
    @Nullable
    private InventorySnapshot inventorySnapshot = null;
    @Nullable
    private InventorySnapshot joinInventorySnapshot = null;

    public SpiritEntity(EntityType<SpiritEntity> entityType, Level level) {
        super(entityType, level);
    }

    public void transferSpiritData(Player player, EntityState joinState, InventorySnapshot invSnapshot, InventorySnapshot joinInvSnapshot, int vaultLevel) {
        this.setGameProfile(player.m_36316_());
        this.setVaultLevel(vaultLevel);
        this.setPlayerLevel(SidedHelper.getVaultLevel(player));
        this.addDrops(invSnapshot);
        this.setJoinInventorySnapshot(joinInvSnapshot);
        this.setJoinState(joinState);
    }

    private void addDrops(InventorySnapshot invSnapshot) {
        this.inventorySnapshot = invSnapshot;
    }

    public void setJoinState(EntityState joinState) {
        this.joinState = joinState;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPlayerDeath(LivingDeathEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        ServerLevel serverLevel = player.m_183503_();
        MinecraftServer server = serverLevel.m_142572_();
        ServerVaults.get((Level)serverLevel).ifPresent(vault -> {
            boolean shouldSpawnSpirit;
            if (VaultUtils.isPvPVault(vault)) {
                return;
            }
            boolean hasNonInstantRestoreModifier = false;
            boolean hasInstantRestoreModifier = false;
            for (VaultModifier<?> modifier : vault.get(Vault.MODIFIERS).getModifiers()) {
                if (!(modifier instanceof PlayerInventoryRestoreModifier)) continue;
                PlayerInventoryRestoreModifier restoreModifier = (PlayerInventoryRestoreModifier)modifier;
                if (((PlayerInventoryRestoreModifier.Properties)restoreModifier.properties()).isInstantRevival()) {
                    hasInstantRestoreModifier = true;
                    continue;
                }
                hasNonInstantRestoreModifier = true;
            }
            boolean isTimerDeath = event.getSource() == VaultMod.DMG_VAULT_TIMER;
            boolean bl = shouldSpawnSpirit = !hasNonInstantRestoreModifier && (!hasInstantRestoreModifier || isTimerDeath);
            if (!vault.get(Vault.OBJECTIVES).getAll(RoyaleObjective.class).isEmpty()) {
                shouldSpawnSpirit = false;
            }
            if (shouldSpawnSpirit && ((VaultMode.GameRuleValue)serverLevel.m_46469_().m_46170_(ModGameRules.MODE)).get() != VaultMode.HARDCORE) {
                int vaultLevel = vault.get(Vault.LEVEL).get();
                PlayerSpiritRecoveryData data = PlayerSpiritRecoveryData.get(serverLevel);
                InventorySnapshot invSnapshot = new InventorySnapshot.Builder((Player)player).setStackFilter((p, stack) -> SpiritEntity.shouldAddItem(stack)).createSnapshot();
                InventorySnapshot joinSnapshot = VaultJoinSnapshotData.get(serverLevel).getLastSnapshot(player.m_142081_()).orElse(invSnapshot);
                if (serverLevel.m_6907_().size() > 1) {
                    EntityState joinState = vault.get(Vault.LISTENERS).get(player.m_142081_()).get(Listener.JOIN_STATE);
                    server.m_6937_((Runnable)new TickTask(server.m_129921_() + 10, () -> {
                        data.putVaultSpiritData(SpiritEntity.initSpiritData(vault, player, invSnapshot, joinSnapshot, vaultLevel));
                        Entity entity = ModEntities.SPIRIT.m_20592_(serverLevel, null, null, player.m_142538_(), MobSpawnType.EVENT, false, false);
                        if (entity instanceof SpiritEntity) {
                            SpiritEntity spirit = (SpiritEntity)entity;
                            spirit.transferSpiritData((Player)player, joinState, invSnapshot, joinSnapshot, vaultLevel);
                        }
                    }));
                } else {
                    server.m_6937_((Runnable)new TickTask(server.m_129921_() + 10, () -> data.putVaultSpiritData(SpiritEntity.initSpiritData(vault, player, invSnapshot, joinSnapshot, vaultLevel))));
                }
            }
        });
    }

    public static void onVaultEnd(Level world, UUID vaultId) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        PlayerSpiritRecoveryData data = PlayerSpiritRecoveryData.get(serverLevel);
        MinecraftServer server = serverLevel.m_142572_();
        server.m_6937_((Runnable)new TickTask(server.m_129921_() + 20, () -> {
            Set<PlayerSpiritRecoveryData.SpiritData> vaultSpiritDataSet = data.getVaultSpiritData(vaultId);
            for (PlayerSpiritRecoveryData.SpiritData spiritData : vaultSpiritDataSet) {
                ServerLevel respawnLevel = server.m_129880_(spiritData.respawnDimension());
                SpiritEntity.spawnSpirit(respawnLevel, spiritData.vaultLevel(), spiritData.drops(), spiritData.inventorySnapshot(), spiritData.joinInventorySnapshot(), spiritData.playerLevel(), Vec3.m_82512_((Vec3i)spiritData.respawnPos()), spiritData.respawnPos(), spiritData.playerGameProfile());
            }
            data.removeVaultSpiritData(vaultId);
        }));
    }

    private static void spawnSpirit(ServerLevel respawnLevel, int vaultLevel, List<ItemStack> drops, InventorySnapshot inventorySnapshot, InventorySnapshot joinInventorySnapshot, int playerLevel, Vec3 precisePosition, BlockPos position, GameProfile playerGameProfile) {
        for (BlockPos.MutableBlockPos p : BlockPos.m_121935_((BlockPos)new BlockPos(precisePosition), (int)1, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            Vec3 respawnPos;
            if (p.equals((Object)position) || (respawnPos = DismountHelper.m_38441_(ModEntities.SPIRIT, (CollisionGetter)respawnLevel, (BlockPos)p.m_7949_(), (boolean)false)) == null) continue;
            SpiritEntity.spawnSpirit(respawnLevel, respawnPos, playerLevel, vaultLevel, drops, inventorySnapshot, joinInventorySnapshot, playerGameProfile);
            return;
        }
        SpiritEntity.spawnSpirit(respawnLevel, precisePosition, playerLevel, vaultLevel, drops, inventorySnapshot, joinInventorySnapshot, playerGameProfile);
    }

    private static PlayerSpiritRecoveryData.SpiritData initSpiritData(Vault vault, ServerPlayer player, InventorySnapshot invSnapshot, InventorySnapshot joinSnapshot, int vaultLevel) {
        BlockPos respawnPosition = player.m_8961_();
        if (respawnPosition == null) {
            ServerLevel respawnDimensionLevel = player.m_20194_().m_129880_(player.m_8963_());
            respawnPosition = respawnDimensionLevel.m_8900_();
            respawnPosition = PlayerRespawnLogic.m_183928_((ServerLevel)respawnDimensionLevel, (int)respawnPosition.m_123341_(), (int)respawnPosition.m_123343_());
        }
        return new PlayerSpiritRecoveryData.SpiritData(vault.get(Vault.ID), player.m_142081_(), invSnapshot, joinSnapshot, vaultLevel, SidedHelper.getVaultLevel((Player)player), (ResourceKey<Level>)player.m_8963_(), respawnPosition, player.m_36316_());
    }

    private static void spawnSpirit(ServerLevel serverLevel, Vec3 respawnPos, int playerLevel, int vaultLevel, List<ItemStack> drops, InventorySnapshot inventorySnapshot, InventorySnapshot joinInventorySnapshot, GameProfile playerGameProfile) {
        Entity entity = ModEntities.SPIRIT.m_20592_(serverLevel, null, null, new BlockPos(respawnPos), MobSpawnType.EVENT, false, false);
        if (entity instanceof SpiritEntity) {
            SpiritEntity spirit = (SpiritEntity)entity;
            spirit.setItems(drops);
            spirit.setInventorySnapshot(inventorySnapshot);
            spirit.setJoinInventorySnapshot(joinInventorySnapshot);
            spirit.setGameProfile(playerGameProfile);
            spirit.setVaultLevel(vaultLevel);
            spirit.setPlayerLevel(playerLevel);
            spirit.setRecyclable(true);
        }
    }

    public void setInventorySnapshot(InventorySnapshot inventorySnapshot) {
        this.inventorySnapshot = inventorySnapshot;
    }

    public void setJoinInventorySnapshot(InventorySnapshot joinInventorySnapshot) {
        this.joinInventorySnapshot = joinInventorySnapshot;
    }

    public void addPlayersItems(Player player) {
        this.setInventorySnapshot(new InventorySnapshot.Builder(player).setStackFilter((p, stack) -> SpiritEntity.shouldAddItem(stack)).createSnapshot());
    }

    private static boolean shouldAddItem(ItemStack stack) {
        return !stack.m_41619_() && (!AttributeGearData.hasData(stack) || ((AttributeGearData)((Object)AttributeGearData.read(stack))).get(ModGearAttributes.SOULBOUND, VaultGearAttributeTypeMerger.anyTrue()) == false);
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public void setVaultLevel(int vaultLevel) {
        this.vaultLevel = vaultLevel;
    }

    public int getVaultLevel() {
        return this.vaultLevel;
    }

    public void setPlayerLevel(int playerLevel) {
        this.playerLevel = playerLevel;
    }

    public int getPlayerLevel() {
        return this.playerLevel;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IPlayerSkinHolder.OPTIONAL_GAME_PROFILE, Optional.empty());
    }

    public void m_6043_() {
    }

    public boolean m_6573_(Player pPlayer) {
        return false;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand pHand) {
        if (player.m_20197_().isEmpty() && this.putInPlayersHand(player)) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, pHand);
    }

    public boolean putInPlayersHand(Player player) {
        if (!player.m_21206_().m_41619_()) {
            player.m_5661_((Component)new TextComponent("You can't pick me up with that in offhand"), true);
            return false;
        }
        if (this.m_20329_((Entity)player)) {
            this.m_20124_(Pose.SLEEPING);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSetPassengersPacket((Entity)player));
            }
            this.yeetCooldown = player.f_19853_.m_46467_() + 20L;
            return true;
        }
        return false;
    }

    public boolean m_7998_(Entity pEntity, boolean pForce) {
        boolean ret = super.m_7998_(pEntity, pForce);
        if (this.m_20159_()) {
            this.m_20124_(Pose.SLEEPING);
        }
        return ret;
    }

    public void m_8119_() {
        Vec3 movement;
        super.m_8119_();
        if (this.f_19853_.m_5776_()) {
            return;
        }
        Entity vehicle = this.m_20202_();
        if (vehicle != null) {
            Player player;
            if (this.yeetCooldown > this.f_19853_.m_46467_()) {
                return;
            }
            if (vehicle instanceof Player && !(player = (Player)vehicle).m_21206_().m_41619_()) {
                this.m_8127_();
                this.markWithHero(vehicle);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSetPassengersPacket(vehicle));
                }
                float motionAngle = vehicle.m_6080_() + 90.0f;
                float x = Mth.m_14089_((float)(motionAngle * ((float)Math.PI / 180)));
                float z = Mth.m_14031_((float)(motionAngle * ((float)Math.PI / 180)));
                this.m_146884_(this.m_20318_(0.0f).m_82520_((double)x, 0.0, (double)z));
                player.m_5661_((Component)new TextComponent("You can't hold me with that in offhand"), true);
            } else if (vehicle.m_6047_()) {
                this.m_8127_();
                this.markWithHero(vehicle);
                if (vehicle instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)vehicle;
                    serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSetPassengersPacket(vehicle));
                }
                this.m_146884_(this.m_20318_(0.0f).m_82520_(0.0, 1.0, 0.0));
                float motionAngle = vehicle.m_6080_() + 90.0f;
                float x = Mth.m_14089_((float)(motionAngle * ((float)Math.PI / 180)));
                float z = Mth.m_14031_((float)(motionAngle * ((float)Math.PI / 180)));
                Vec3 vehicleMotion = vehicle.m_20184_();
                this.m_20256_(new Vec3((double)x + vehicleMotion.m_7096_() * 10.0, 0.1, (double)z + vehicleMotion.m_7094_() * 10.0));
            }
        } else if (this.m_20089_() == Pose.SLEEPING && Math.abs((movement = this.m_20184_()).m_7096_()) + Math.abs(movement.m_7094_()) < 0.2) {
            this.m_20124_(Pose.STANDING);
        }
    }

    private void markWithHero(Entity vehicle) {
        if (vehicle instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)vehicle;
            if (ServerVaults.get(vehicle.f_19853_).isPresent() && this.items.size() > 5 && this.gameProfile.getId() != player.m_142081_()) {
                this.heroId = player.m_142081_();
            }
        }
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_6673_(DamageSource pSource) {
        return pSource != DamageSource.f_19317_;
    }

    public Iterable<ItemStack> m_6168_() {
        return new ArrayList<ItemStack>();
    }

    public ItemStack m_6844_(EquipmentSlot pSlot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot pSlot, ItemStack pStack) {
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    @Override
    public Optional<GameProfile> getGameProfile() {
        return (Optional)this.f_19804_.m_135370_(IPlayerSkinHolder.OPTIONAL_GAME_PROFILE);
    }

    @Override
    public void setGameProfile(GameProfile gameProfile) {
        this.f_19804_.m_135381_(OPTIONAL_GAME_PROFILE, Optional.ofNullable(gameProfile));
        this.gameProfile = gameProfile;
    }

    public void setRecyclable(boolean recyclable) {
        this.recyclable = recyclable;
    }

    @Override
    public Optional<ResourceLocation> getSkinLocation() {
        return Optional.ofNullable(this.skinLocation);
    }

    @Override
    public boolean isUpdatingSkin() {
        return this.updatingSkin;
    }

    @Override
    public void setSkinLocation(ResourceLocation skinLocation) {
        this.skinLocation = skinLocation;
    }

    @Override
    public void startUpdatingSkin() {
        this.updatingSkin = true;
    }

    @Override
    public void stopUpdatingSkin() {
        this.updatingSkin = false;
    }

    @Override
    public boolean hasSlimSkin() {
        return this.slimSkin;
    }

    @Override
    public void setSlimSkin(boolean slimSkin) {
        this.slimSkin = slimSkin;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.gameProfile != null) {
            compound.m_128365_(OWNER_PROFILE_TAG, (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)this.gameProfile));
        }
        ListTag itemList = new ListTag();
        for (ItemStack item : this.items) {
            itemList.add((Object)item.m_41739_(new CompoundTag()));
        }
        compound.m_128365_("items", (Tag)itemList);
        if (this.inventorySnapshot != null) {
            compound.m_128365_("inventorySnapshot", (Tag)this.inventorySnapshot.serializeNBT());
        }
        if (this.joinInventorySnapshot != null) {
            compound.m_128365_("joinInventorySnapshot", (Tag)this.joinInventorySnapshot.serializeNBT());
        }
        compound.m_128405_("vaultLevel", this.vaultLevel);
        compound.m_128405_("playerLevel", this.playerLevel);
        if (this.joinState != null) {
            ArrayBitBuffer buffer = ArrayBitBuffer.empty();
            this.joinState.write(buffer, new DiskSyncContext(Version.v1_0));
            compound.m_128388_(JOIN_STATE_TAG, buffer.toLongArray());
        }
        if (this.m_20159_()) {
            compound.m_128379_("isBeingCarried", true);
        }
        compound.m_128379_(RECYCLABLE_TAG, this.recyclable);
        if (this.heroId != null) {
            compound.m_128362_("heroId", this.heroId);
        }
        compound.m_128350_("rescuedBonus", this.rescuedBonus);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setGameProfile(compound.m_128441_(OWNER_PROFILE_TAG) ? NbtUtils.m_129228_((CompoundTag)compound.m_128469_(OWNER_PROFILE_TAG)) : null);
        this.items.clear();
        for (Tag tag : compound.m_128437_("items", 10)) {
            this.items.add((Object)ItemStack.m_41712_((CompoundTag)((CompoundTag)tag)));
        }
        if (compound.m_128441_("inventorySnapshot")) {
            this.inventorySnapshot = new InventorySnapshot(false, false);
            this.inventorySnapshot.deserializeNBT(compound.m_128469_("inventorySnapshot"));
        } else {
            this.inventorySnapshot = null;
        }
        if (compound.m_128441_("joinInventorySnapshot")) {
            this.joinInventorySnapshot = new InventorySnapshot(false, false);
            this.joinInventorySnapshot.deserializeNBT(compound.m_128469_("joinInventorySnapshot"));
        } else {
            this.joinInventorySnapshot = null;
        }
        this.vaultLevel = compound.m_128451_("vaultLevel");
        this.playerLevel = compound.m_128441_("playerLevel") ? compound.m_128451_("playerLevel") : this.vaultLevel;
        this.joinState = compound.m_128425_(JOIN_STATE_TAG, 12) ? (EntityState)new EntityState().read(ArrayBitBuffer.backing(compound.m_128467_(JOIN_STATE_TAG), 0), new DiskSyncContext(Version.v1_0)) : null;
        if (compound.m_128471_("isBeingCarried")) {
            this.m_20124_(Pose.SLEEPING);
        }
        boolean bl = this.recyclable = !compound.m_128441_(RECYCLABLE_TAG) || compound.m_128471_(RECYCLABLE_TAG);
        if (compound.m_128425_("heroId", 11)) {
            this.heroId = compound.m_128342_("heroId");
        }
        this.rescuedBonus = compound.m_128457_("rescuedBonus");
    }

    public void setItems(List<ItemStack> items) {
        this.items.clear();
        this.items.addAll(items);
    }

    public void teleportOut() {
        if (this.joinState != null) {
            Level level;
            ServerVaults.get(this.f_19853_).ifPresent(vault -> {
                Level patt18925$temp = this.f_19853_;
                if (patt18925$temp instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)patt18925$temp;
                    PlayerSpiritRecoveryData data = PlayerSpiritRecoveryData.get(serverLevel);
                    data.removeVaultSpiritData(this.gameProfile.getId(), vault.get(Vault.ID));
                }
            });
            if (this.m_20159_()) {
                this.m_8127_();
            }
            this.joinState.teleport((Entity)this);
            this.joinState = null;
            if (this.heroId != null && (level = this.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                PlayerSpiritRecoveryData.get(serverLevel).setHeroDiscount(this.heroId, serverLevel.f_46441_);
            }
            this.rescuedBonus = ModConfigs.SPIRIT.getRescuedBonus(this.f_19853_.f_46441_);
        }
    }

    public boolean isRecyclable() {
        return this.recyclable;
    }

    public float getRescuedBonus() {
        return this.rescuedBonus;
    }

    public void setRescuedBonus(float rescuedBonus) {
        this.rescuedBonus = rescuedBonus;
    }

    public InventorySnapshot getInventorySnapshot() {
        return this.inventorySnapshot;
    }

    public InventorySnapshot getJoinInventorySnapshot() {
        return this.joinInventorySnapshot;
    }

    @Override
    public ModifierPredicate getImmunity() {
        return ModifierPredicate.TRUE;
    }

    @Override
    public void setImmunity(ModifierPredicate predicate) {
    }
}

